/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.security.Crypto;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.KeyUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class FileSecurity
implements IStorage {
    public static final String FAILED_TO_ENCRYPT = "FAILED TO ENCRYPT";
    public static final String FAILED_TO_WRITE = "FAILED TO WRITE";
    public static final String FAILED_TO_CREATE_KEY = "FAILED_TO_CREATE_KEY";
    public static final String FAILED_TO_READ_FILE = "FAILED_TO_READ_FILE";
    public static final String FAILED_TO_READ = "FAILED TO READ";
    public static final String NOT_READY_TO_READ = "NOT_READY_TO_READ";
    public static final String NOT_READY_TO_WRITE = "NOT_READY_TO_WRITE";
    public static final String FAILED_TO_INIT_CIPHERS = "FAILED_TO_INIT_CIPHERS";
    public static final String TO_DECRYPT = "FAILED TO DECRYPT";
    public static final String FAILED_TO_DECRYPT = "FAILED_TO_DECRYPT";
    public static final String KEY_FILE_NOT_FOUND = "KEY_FILE_NOT_FOUND";
    private static final String CONTEST_KEY_FILENAME = "contest.key";
    private static final String RECOVERY_KEY_FILENAME = "recovery.key";
    private PBEParameterSpec algorithm;
    private Cipher dcipher;
    private Cipher ecipher;
    private char[] contestPassword;
    private SecretKey contestSecretKey;
    private KeyPair contestKeyPair;
    private static final byte[] PUBLIC_KEY = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -120, -32, -95, -10, 118, -62, 56, -73, -51, 104, 5, 13, -100, -35, 49, 27, -35, 92, 110, -76, 105, 104, 21, -75, 87, 122, -55, 28, -51, -13, 55, -22, 75, 55, 37, -72, 26, -71, -65, -2, 37, 69, -71, 124, 8, -78, -29, -70, 45, 57, -83, -25, -113, 113, 102, -60, 6, -30, -24, -124, 94, -31, -17, -25, -23, -38, -18, -125, -46, 70, 68, 97, 28, 86, -24, -68, -41, 124, 38, -85, -5, -51, 46, -25, -121, 84, 46, 99, -5, -36, -94, -88, -31, 9, -117, 17, -10, 22, -104, -13, 17, -115, 74, 78, 55, 95, -124, -5, -92, 70, -72, 26, -64, -45, 32, -109, -59, -82, 60, -79, 76, 69, 32, -72, 95, 91, 116, 33, 2, 3, 1, 0, 1};
    private boolean readyToReadWrite = false;
    private Crypto fileCrypt = null;
    private String contestDirectory = "." + File.separator;

    public FileSecurity(String inContestDirectory) {
        int iteration = 128;
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        this.readyToReadWrite = false;
        this.algorithm = new PBEParameterSpec(salt, iteration);
        Utilities.insureDir(inContestDirectory);
        if (!inContestDirectory.endsWith(File.separator)) {
            inContestDirectory = inContestDirectory + File.separator;
        }
        this.contestDirectory = inContestDirectory;
        this.fileCrypt = new Crypto();
        SecretKey sk = this.fileCrypt.generateSecretKey(this.fileCrypt.getPublicKey(), this.fileCrypt.getPrivateKey());
        this.fileCrypt.setSecretKey(sk);
    }

    public String getContestDirectory() {
        return this.contestDirectory;
    }

    public boolean verifyPassword(char[] password) throws FileSecurityException {
        SealedObject objectFromDisk;
        SecretKey secretKey = null;
        KeyPair tmpKeyPair = null;
        if (!Utilities.isFileThere(this.contestDirectory + CONTEST_KEY_FILENAME)) {
            throw new FileSecurityException(KEY_FILE_NOT_FOUND);
        }
        try {
            objectFromDisk = (SealedObject)this.readObjectFromFile(this.contestDirectory + CONTEST_KEY_FILENAME);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to read file from disk", e);
            throw new FileSecurityException(FAILED_TO_READ_FILE);
        }
        try {
            secretKey = this.makeSecretKey(password);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to create key from password", e);
            throw new FileSecurityException(FAILED_TO_CREATE_KEY);
        }
        this.contestPassword = password;
        this.contestSecretKey = secretKey;
        try {
            this.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - initialize ciphers", e);
            throw new FileSecurityException(FAILED_TO_INIT_CIPHERS);
        }
        try {
            tmpKeyPair = (KeyPair)this.decryptObject(objectFromDisk, secretKey);
        }
        catch (Exception e) {
            if (StaticLog.getLog() != null) {
                StaticLog.getLog().log(Log.INFO, "verify password - failed to decrypt object", e);
            }
            throw new FileSecurityException(FAILED_TO_DECRYPT);
        }
        this.fileCrypt.setMyKeyPair(tmpKeyPair);
        SecretKey sk = this.fileCrypt.generateSecretKey(this.fileCrypt.getPublicKey(), this.fileCrypt.getPrivateKey());
        this.fileCrypt.setSecretKey(sk);
        this.readyToReadWrite = true;
        return true;
    }

    public SecretKey getSecretKey() {
        return this.contestSecretKey;
    }

    public void saveSecretKey(SecretKey theKey, char[] password) throws FileSecurityException {
        this.contestSecretKey = theKey;
        this.contestPassword = password;
        try {
            this.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - initialize ciphers", e);
            throw new FileSecurityException(FAILED_TO_INIT_CIPHERS);
        }
        this.contestKeyPair = this.fileCrypt.getKeyPair();
        this.writePC2RecoveryInfo();
        SealedObject sealedSecretKey = null;
        try {
            sealedSecretKey = this.encryptObject(this.contestKeyPair, this.contestSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to encrypt contestSecretKey", e);
            throw new FileSecurityException(FAILED_TO_ENCRYPT, e);
        }
        try {
            this.writeObjectToFile(this.contestDirectory + CONTEST_KEY_FILENAME, sealedSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
        this.readyToReadWrite = true;
    }

    public void saveSecretKey(PublicKey theKey, String filename) throws FileSecurityException {
        try {
            this.writeObjectToFile(this.contestDirectory + filename, (Serializable)this.contestPassword);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writePC2RecoveryFile - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
    }

    public void saveSecretKey(char[] password) throws FileSecurityException {
        SealedObject sealedSecretKey = null;
        SecretKey secretKey = null;
        this.contestPassword = password;
        try {
            this.contestSecretKey = this.makeSecretKey(password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - initialize ciphers", e);
            throw new FileSecurityException(FAILED_TO_INIT_CIPHERS);
        }
        this.contestKeyPair = this.fileCrypt.getKeyPair();
        try {
            sealedSecretKey = this.encryptObject(this.contestKeyPair, secretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to encrypt contestSecretKey", e);
            throw new FileSecurityException(FAILED_TO_ENCRYPT, e);
        }
        try {
            this.writeObjectToFile(this.contestDirectory + CONTEST_KEY_FILENAME, sealedSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
        this.writePC2RecoveryInfo();
        this.readyToReadWrite = true;
    }

    private void writePC2RecoveryInfo() throws FileSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PUBLIC_KEY);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            KeyUtilities.encryptString(this.contestDirectory + new String(this.contestPassword), this.contestDirectory + RECOVERY_KEY_FILENAME, publicKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writePC2RecoveryFile - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
    }

    public String getPassword() {
        return new String(this.contestPassword);
    }

    public boolean writeSealedFile(String fileName, Serializable objectToWrite) throws FileSecurityException {
        SealedObject sealedObjectToWrite;
        if (!this.readyToReadWrite) {
            throw new FileSecurityException(NOT_READY_TO_WRITE);
        }
        try {
            sealedObjectToWrite = this.fileCrypt.encrypt(objectToWrite);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writeFile - failed to encrypt object", e);
            throw new FileSecurityException(FAILED_TO_ENCRYPT, e);
        }
        try {
            this.writeObjectToFile(fileName, sealedObjectToWrite);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writeFile - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
        return true;
    }

    private Serializable readSealedFile(String fileName) throws FileSecurityException, IOException, ClassNotFoundException {
        Serializable objectToReturn = null;
        if (!this.readyToReadWrite) {
            throw new FileSecurityException(NOT_READY_TO_READ);
        }
        SealedObject sealedObjectFromDisk = (SealedObject)this.readObjectFromFile(fileName);
        try {
            objectToReturn = this.fileCrypt.decrypt(sealedObjectFromDisk);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "readFile - failed to decrypt object", e);
            throw new FileSecurityException(TO_DECRYPT, e);
        }
        return objectToReturn;
    }

    private SecretKey makeSecretKey(char[] pwd) throws Exception {
        SecretKey key = null;
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(pwd);
            SecretKeyFactory keyBuilder = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            key = keyBuilder.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    private void cipherInit() throws Exception {
        try {
            this.ecipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.ecipher.init(1, (Key)this.contestSecretKey, this.algorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception(e.getMessage());
        }
        try {
            this.dcipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.dcipher.init(2, (Key)this.contestSecretKey, this.algorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception(e.getMessage());
        }
    }

    private SealedObject encryptObject(Serializable objToEncrypt, SecretKey inSecretKey) throws Exception {
        SealedObject encryptedObject = null;
        try {
            encryptedObject = new SealedObject(objToEncrypt, this.ecipher);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e.getMessage());
        }
        return encryptedObject;
    }

    private Serializable decryptObject(SealedObject encryptedObject, SecretKey inSecretKey) throws Exception {
        Serializable decryptedObject = null;
        try {
            decryptedObject = (Serializable)encryptedObject.getObject(this.dcipher);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new Exception(e.getMessage());
        }
        return decryptedObject;
    }

    public boolean writeObjectToFile(String filename, Serializable serializable) throws IOException {
        FileOutputStream f = new FileOutputStream(filename);
        ObjectOutputStream s = new ObjectOutputStream(f);
        s.writeObject(serializable);
        s.flush();
        s.close();
        s = null;
        return true;
    }

    public Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        Object object = new Object();
        FileInputStream in = new FileInputStream(filename);
        ObjectInputStream s = new ObjectInputStream(in);
        object = s.readObject();
        in.close();
        s.close();
        return object;
    }

    public String getDirectoryName() {
        return this.getContestDirectory();
    }

    public Serializable load(String fileName) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.readSealedFile(fileName);
    }

    public boolean store(String fileName, Serializable serializable) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.writeSealedFile(fileName, serializable);
    }

    public boolean isReadyToReadWrite() {
        return this.readyToReadWrite;
    }

    public static String getContestKeyFileName() {
        return CONTEST_KEY_FILENAME;
    }
}

