/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.scoring;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.BalloonSettingsComparatorbySite;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.list.RunComparatorByTeam;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.scoring.DefaultStandingsRecordComparator;
import edu.csus.ecs.pc2.core.scoring.IScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.ProblemSummaryInfo;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import edu.csus.ecs.pc2.core.scoring.SummaryRow;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScoringAlgorithm
implements IScoringAlgorithm {
    private static final long serialVersionUID = -2471349413867745412L;
    public static final String POINTS_PER_NO = "Points per No";
    public static final String POINTS_PER_YES_MINUTE = "Points per Minute (for 1st yes)";
    public static final String BASE_POINTS_PER_YES = "Base Points per Yes";
    private static String[][] propList = new String[][]{{"Points per No", "20:Integer"}, {"Points per Minute (for 1st yes)", "1:Integer"}, {"Base Points per Yes", "0:Integer"}};
    private Properties props = new Properties();
    private Object mutex = new Object();
    private int grandTotalAttempts;
    private int grandTotalSolutions;
    private int grandTotalProblemAttempts;
    private int[] problemBestTime = null;
    private int[] problemLastTime = null;
    private int[] problemSolutions = null;
    private int[] problemAttempts = null;
    private Log log;
    private boolean countPreliminaryJudgements = false;
    private PermissionList permissionList = new PermissionList();
    private boolean respectSendToTeam = false;
    private boolean respectEOC = false;

    public DefaultScoringAlgorithm() {
        for (int i = 0; i < propList.length; ++i) {
            String key = propList[i][0];
            String value = propList[i][1];
            int colon = value.indexOf(":");
            String defaultValue = value.substring(0, colon);
            this.props.put(key, defaultValue);
        }
    }

    AccountList getAccountList(IInternalContest theContest) {
        Vector<Account> accountVect = theContest.getAccounts(ClientType.Type.ALL);
        AccountList accountList = new AccountList();
        Enumeration<Account> accountEnum = accountVect.elements();
        while (accountEnum.hasMoreElements()) {
            Account a = accountEnum.nextElement();
            accountList.add(a);
        }
        return accountList;
    }

    private ProblemSummaryInfo calcProblemScoreData(TreeMap<Run, Run> treeMap) throws IllegalContestState {
        ProblemSummaryInfo problemSummaryInfo = new ProblemSummaryInfo();
        int score = 0;
        int attempts = 0;
        ElementId problemId = null;
        long solutionTime = -1L;
        boolean solved = false;
        boolean unJudgedRun = false;
        if (treeMap.isEmpty()) {
            problemSummaryInfo = null;
        } else {
            Collection<Run> coll = treeMap.values();
            Object[] o = coll.toArray();
            for (int i = 0; i < o.length; ++i) {
                Run run = (Run)o[i];
                if (run.isDeleted()) continue;
                ++attempts;
                problemId = run.getProblemId();
                if (run.isSolved() && this.isValidJudgement(run)) {
                    solved = true;
                    solutionTime = run.getElapsedMins();
                    score = (int)((long)score + (solutionTime * (long)this.getPenaltyPointsPerYesMinute() + (long)this.getBasePointsPerYes()));
                    break;
                }
                if (this.isValidJudgement(run)) {
                    score += this.getPenaltyPointsPerNo();
                    continue;
                }
                unJudgedRun = true;
            }
        }
        if (!solved) {
            score = 0;
        }
        problemSummaryInfo.setSolved(solved);
        problemSummaryInfo.setSolutionTime(solutionTime);
        problemSummaryInfo.setProblemId(problemId);
        problemSummaryInfo.setNumberSubmitted(attempts);
        problemSummaryInfo.setPenaltyPoints(score);
        problemSummaryInfo.setUnJudgedRuns(unJudgedRun);
        return problemSummaryInfo;
    }

    private int getPropIntValue(String key) {
        String s = this.props.getProperty(key);
        Integer i = Integer.parseInt(s);
        return i;
    }

    private int getBasePointsPerYes() {
        return this.getPropIntValue(BASE_POINTS_PER_YES);
    }

    private int getPenaltyPointsPerNo() {
        return this.getPropIntValue(POINTS_PER_NO);
    }

    private int getPenaltyPointsPerYesMinute() {
        return this.getPropIntValue(POINTS_PER_YES_MINUTE);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStandings(IInternalContest theContest, Properties properties, Log inputLog) throws IllegalContestState {
        String xmlString;
        BalloonSettings[] balloonSettings;
        if (theContest == null) {
            throw new InvalidParameterException("Invalid model (null)");
        }
        if (properties == null || properties.isEmpty()) {
            properties = this.getProperties();
        }
        this.log = inputLog;
        this.props = properties;
        this.respectSendToTeam = this.isAllowed(theContest, theContest.getClientId(), Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        this.respectEOC = this.isAllowed(theContest, theContest.getClientId(), Permission.Type.RESPECT_EOC_SUPPRESSION);
        this.countPreliminaryJudgements = theContest.getContestInformation().isPreliminaryJudgementsUsedByBoard();
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("contestStandings");
        IMemento summaryMememento = this.createSummaryMomento(theContest.getContestInformation(), mementoRoot);
        AccountList accountList = this.getAccountList(theContest);
        Problem[] allProblems = theContest.getProblems();
        Hashtable<ElementId, Integer> problemsIndexHash = new Hashtable<ElementId, Integer>();
        int p2 = 0;
        for (int p = 1; p <= allProblems.length; ++p) {
            Problem prob = allProblems[p - 1];
            if (!prob.isActive()) continue;
            problemsIndexHash.put(prob.getElementId(), new Integer(++p2));
        }
        Problem[] problems = new Problem[p2];
        Set keys = problemsIndexHash.keySet();
        for (ElementId type : keys) {
            int p = (Integer)problemsIndexHash.get(type);
            problems[p - 1] = theContest.getProblem(type);
        }
        summaryMememento.putLong("problemCount", problems.length);
        Site[] sites = theContest.getSites();
        summaryMememento.putInteger("siteCount", sites.length);
        Group[] groups = theContest.getGroups();
        if (groups != null) {
            this.dumpGroupList(groups, summaryMememento);
        }
        if ((balloonSettings = theContest.getBalloonSettings()) != null) {
            Arrays.sort(balloonSettings, new BalloonSettingsComparatorbySite());
            IMemento listMemento = summaryMememento.createChild("colorList");
            for (int i = 0; i < balloonSettings.length; ++i) {
                int id = i + 1;
                IMemento balloonSettingsMemento = listMemento.createChild("colors");
                balloonSettingsMemento.putInteger("id", id);
                this.dumpBalloonSettings(balloonSettings[i], problems, balloonSettingsMemento);
            }
        }
        Run[] runs = theContest.getRuns();
        Object i = this.mutex;
        synchronized (i) {
            int i2;
            Account[] accounts = accountList.getList();
            Hashtable<String, StandingsRecord> standingsRecordHash = new Hashtable<String, StandingsRecord>();
            RunComparatorByTeam runComparatorByTeam = new RunComparatorByTeam();
            TreeMap<Run, Run> runTreeMap = new TreeMap<Run, Run>(runComparatorByTeam);
            Hashtable<String, Problem> problemHash = new Hashtable<String, Problem>();
            for (i2 = 0; i2 < problems.length; ++i2) {
                Problem problem = problems[i2];
                if (!problem.isActive()) continue;
                problemHash.put(problem.getElementId().toString(), problem);
            }
            this.initializeStandingsRecordHash(accountList, accounts, problems, standingsRecordHash);
            for (i2 = 0; i2 < runs.length; ++i2) {
                Account account = accountList.getAccount(runs[i2].getSubmitter());
                if (account == null) {
                    this.log.info("account could not be located for " + runs[i2].getSubmitter());
                    continue;
                }
                if (runs[i2].isDeleted() || !account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD) || !problemHash.containsKey(runs[i2].getProblemId().toString())) continue;
                Run runToAdd = runs[i2];
                if (this.respectSendToTeam && runToAdd.getAllJudgementRecords().length > 0 && !runToAdd.getJudgementRecord().isSendToTeam()) {
                    runToAdd = RunUtilities.createNewRun(runs[i2], theContest);
                }
                JudgementNotificationsList judgementNotificationsList = theContest.getContestInformation().getJudgementNotificationsList();
                ContestTime contestTime = theContest.getContestTime();
                if (this.respectEOC && RunUtilities.supppressJudgement(judgementNotificationsList, runs[i2], contestTime)) {
                    runToAdd = RunUtilities.createNewRun(runs[i2], theContest);
                }
                runTreeMap.put(runToAdd, runToAdd);
            }
            if (!runTreeMap.isEmpty()) {
                this.generateStandingsValues(runTreeMap, standingsRecordHash, problemsIndexHash);
            }
            DefaultStandingsRecordComparator src = new DefaultStandingsRecordComparator();
            src.setCachedAccountList(accountList);
            TreeMap<StandingsRecord, StandingsRecord> treeMap = new TreeMap<StandingsRecord, StandingsRecord>(src);
            Collection<StandingsRecord> enumeration = standingsRecordHash.values();
            for (StandingsRecord record : enumeration) {
                treeMap.put(record, record);
            }
            this.createStandingXML(treeMap, mementoRoot, accountList, problems, problemsIndexHash, groups, summaryMememento);
        }
        try {
            xmlString = mementoRoot.saveToString();
        }
        catch (IOException e) {
            this.log.log(Log.WARNING, "Trouble saving momentoRoot to String ", e);
            xmlString = "";
        }
        return xmlString;
    }

    private void initializePermissions(IInternalContest theContest, ClientId clientId) {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList(theContest));
    }

    private PermissionList getPermissionList(IInternalContest theContest) {
        ClientId id = theContest.getClientId();
        Account account = theContest.getAccount(id);
        PermissionList list = null;
        list = account == null ? new PermissionGroup().getPermissionList(id.getClientType()) : account.getPermissionList();
        return list;
    }

    private boolean isAllowed(IInternalContest theContest, ClientId clientId, Permission.Type type) {
        this.initializePermissions(theContest, clientId);
        return this.permissionList.isAllowed(type);
    }

    private void dumpBalloonSettings(BalloonSettings balloonSettings, Problem[] problems, IMemento memento) {
        memento.putInteger("siteNum", balloonSettings.getSiteNumber());
        if (problems != null) {
            for (int i = 0; i < problems.length; ++i) {
                int id = i + 1;
                IMemento problemMemento = memento.createChild("problem");
                problemMemento.putInteger("id", id);
                problemMemento.putString("color", balloonSettings.getColor(problems[i]));
            }
        }
    }

    private void dumpGroupList(Group[] groups, IMemento memento) {
        memento.putInteger("groupCount", groups.length + 1);
        IMemento groupsMemento = memento.createChild("groupList");
        int id = 0;
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].isDisplayOnScoreboard()) continue;
            IMemento groupMemento = groupsMemento.createChild("group");
            groupMemento.putInteger("id", ++id);
            groupMemento.putString("title", groups[i].getDisplayName());
            groupMemento.putInteger("externalId", groups[i].getGroupId());
            if (groups[i].getSite() == null) continue;
            groupMemento.putInteger("pc2Site", groups[i].getSite().getSiteNumber());
        }
    }

    private void createStandingXML(TreeMap<StandingsRecord, StandingsRecord> treeMap, XMLMemento mementoRoot, AccountList accountList, Problem[] problems, Hashtable<ElementId, Integer> problemsIndexHash, Group[] groups, IMemento summaryMememento) {
        Hashtable<ElementId, Group> groupHash = new Hashtable<ElementId, Group>();
        Hashtable<Group, Integer> groupIndexHash = new Hashtable<Group, Integer>();
        int groupCount = 0;
        for (Group group : groups) {
            if (!group.isDisplayOnScoreboard()) continue;
            groupHash.put(group.getElementId(), group);
            groupIndexHash.put(group, groupCount);
            ++groupCount;
        }
        StandingsRecord[] srArray = new StandingsRecord[treeMap.size()];
        Collection<StandingsRecord> coll = treeMap.values();
        Iterator<StandingsRecord> iterator = coll.iterator();
        this.problemBestTime = new int[problems.length + 1];
        this.problemLastTime = new int[problems.length + 1];
        this.problemSolutions = new int[problems.length + 1];
        this.problemAttempts = new int[problems.length + 1];
        for (int p = 1; p <= problems.length; ++p) {
            this.problemBestTime[p] = -1;
        }
        this.grandTotalAttempts = 0;
        this.grandTotalSolutions = 0;
        this.grandTotalProblemAttempts = 0;
        long numSolved = -1L;
        long score = 0L;
        long lastSolved = 0L;
        int rank = 0;
        int indexRank = 0;
        int index = 0;
        long[] groupNumSolved = new long[groupCount];
        for (int i = 0; i < groupNumSolved.length; ++i) {
            groupNumSolved[i] = -1L;
        }
        long[] groupScore = new long[groupCount];
        long[] groupLastSolved = new long[groupCount];
        int[] groupRank = new int[groupCount];
        int[] groupIndexRank = new int[groupCount];
        for (int i = 0; i < groupIndexRank.length; ++i) {
            groupScore[i] = 0L;
            groupLastSolved[i] = 0L;
            groupRank[i] = 0;
            groupIndexRank[i] = 0;
        }
        while (iterator.hasNext()) {
            StandingsRecord o;
            StandingsRecord standingsRecord = o = iterator.next();
            ++indexRank;
            if (!this.isTeamTied(standingsRecord, numSolved, score, lastSolved)) {
                numSolved = standingsRecord.getNumberSolved();
                score = standingsRecord.getPenaltyPoints();
                lastSolved = standingsRecord.getLastSolved();
                rank = indexRank;
                standingsRecord.setRankNumber(rank);
            } else {
                standingsRecord.setRankNumber(rank);
            }
            long totalAttempts = 0L;
            long problemsAttempted = 0L;
            IMemento standingsRecordMemento = mementoRoot.createChild("teamStanding");
            standingsRecordMemento.putLong("firstSolved", standingsRecord.getFirstSolved());
            standingsRecordMemento.putLong("lastSolved", standingsRecord.getLastSolved());
            standingsRecordMemento.putLong("points", standingsRecord.getPenaltyPoints());
            standingsRecordMemento.putInteger("solved", standingsRecord.getNumberSolved());
            standingsRecordMemento.putInteger("rank", standingsRecord.getRankNumber());
            standingsRecordMemento.putInteger("index", index);
            Account account = accountList.getAccount(standingsRecord.getClientId());
            standingsRecordMemento.putString("teamName", account.getDisplayName());
            standingsRecordMemento.putInteger("teamId", account.getClientId().getClientNumber());
            standingsRecordMemento.putInteger("teamSiteId", account.getClientId().getSiteNumber());
            standingsRecordMemento.putString("teamKey", account.getClientId().getTripletKey());
            standingsRecordMemento.putString("teamExternalId", account.getExternalId());
            if (account.getAliasName().trim().equals("")) {
                standingsRecordMemento.putString("teamAlias", account.getDisplayName() + " (not aliasesd)");
            } else {
                standingsRecordMemento.putString("teamAlias", account.getAliasName().trim());
            }
            Group group = null;
            if (account.getGroupId() != null) {
                group = (Group)groupHash.get(account.getGroupId());
            }
            if (group != null) {
                int groupIndex;
                int n = groupIndex = ((Integer)groupIndexHash.get(group)).intValue();
                groupIndexRank[n] = groupIndexRank[n] + 1;
                if (!this.isTeamTied(standingsRecord, groupNumSolved[groupIndex], groupScore[groupIndex], groupLastSolved[groupIndex])) {
                    groupNumSolved[groupIndex] = standingsRecord.getNumberSolved();
                    groupScore[groupIndex] = standingsRecord.getPenaltyPoints();
                    groupLastSolved[groupIndex] = standingsRecord.getLastSolved();
                    groupRank[groupIndex] = groupIndexRank[groupIndex];
                    standingsRecord.setGroupRankNumber(groupRank[groupIndex]);
                } else {
                    standingsRecord.setGroupRankNumber(groupRank[groupIndex]);
                }
                standingsRecordMemento.putInteger("groupRank", standingsRecord.getGroupRankNumber());
                standingsRecordMemento.putString("teamGroupName", group.getDisplayName());
                standingsRecordMemento.putInteger("teamGroupId", groupIndex + 1);
                standingsRecordMemento.putInteger("teamGroupExternalId", group.getGroupId());
            }
            SummaryRow summaryRow = standingsRecord.getSummaryRow();
            for (int i = 0; i < problems.length; ++i) {
                int id = i + 1;
                ProblemSummaryInfo psi = summaryRow.get(id);
                if (psi == null) {
                    this.log.log(Log.WARNING, "ProblemSummaryInfo not generated/found for problem " + id + " " + problems[i]);
                    System.out.println("error or normal? ProblemSummaryInfo not found for problem " + id);
                    continue;
                }
                IMemento psiMemento = standingsRecordMemento.createChild("problemSummaryInfo");
                psiMemento.putInteger("index", problemsIndexHash.get(psi.getProblemId()));
                psiMemento.putString("problemId", psi.getProblemId().toString());
                psiMemento.putInteger("attempts", psi.getNumberSubmitted());
                psiMemento.putInteger("points", psi.getPenaltyPoints());
                psiMemento.putLong("solutionTime", psi.getSolutionTime());
                psiMemento.putBoolean("isSolved", psi.isSolved());
                psiMemento.putBoolean("isPending", psi.isUnJudgedRuns());
                int n = id;
                this.problemAttempts[n] = this.problemAttempts[n] + psi.getNumberSubmitted();
                totalAttempts += (long)psi.getNumberSubmitted();
                this.grandTotalAttempts += psi.getNumberSubmitted();
                if (psi.getNumberSubmitted() > 0) {
                    ++problemsAttempted;
                }
                if (!psi.isSolved()) continue;
                int n2 = id;
                this.problemSolutions[n2] = this.problemSolutions[n2] + 1;
                ++this.grandTotalSolutions;
                if (psi.getSolutionTime() > (long)this.problemLastTime[id]) {
                    this.problemLastTime[id] = new Long(psi.getSolutionTime()).intValue();
                }
                if (this.problemBestTime[id] >= 0 && psi.getSolutionTime() >= (long)this.problemBestTime[id]) continue;
                this.problemBestTime[id] = new Long(psi.getSolutionTime()).intValue();
            }
            standingsRecordMemento.putLong("totalAttempts", totalAttempts);
            standingsRecordMemento.putLong("problemsAttempted", problemsAttempted);
            srArray[index++] = standingsRecord;
        }
        summaryMememento.putInteger("medianProblemsSolved", this.getMedian(srArray));
        this.generateSummaryTotalsForProblem(problems, problemsIndexHash, summaryMememento);
    }

    private int getMedian(StandingsRecord[] srArray) {
        int median;
        if (srArray == null || srArray.length == 0) {
            median = 0;
        } else if (srArray.length == 1) {
            median = srArray[0].getNumberSolved();
        } else if (srArray.length % 2 == 0) {
            int low = srArray[srArray.length / 2 - 1].getNumberSolved();
            int high = srArray[(srArray.length + 1) / 2].getNumberSolved();
            median = (low + high) / 2;
        } else {
            median = srArray[(srArray.length + 1) / 2 - 1].getNumberSolved();
        }
        return median;
    }

    boolean isValidJudgement(Run run) {
        boolean result = false;
        if (run.getStatus().equals((Object)Run.RunStates.JUDGED)) {
            result = true;
        } else if (run.getJudgementRecord() != null) {
            if (run.getJudgementRecord().isPreliminaryJudgement()) {
                if (this.countPreliminaryJudgements) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    boolean isTeamTied(StandingsRecord standingsRecord, long numSolved, long score, long lastSolved) {
        if (numSolved != (long)standingsRecord.getNumberSolved()) {
            return false;
        }
        if (score != standingsRecord.getPenaltyPoints()) {
            return false;
        }
        return lastSolved == standingsRecord.getLastSolved();
    }

    private void generateSummaryTotalsForProblem(Problem[] problems, Hashtable<ElementId, Integer> problemsIndexHash, IMemento summaryMememento) {
        for (int i = 0; i < problems.length; ++i) {
            int id = i + 1;
            problemsIndexHash.put(problems[i].getElementId(), new Integer(id));
            IMemento problemMemento = summaryMememento.createChild("problem");
            problemMemento.putInteger("id", id);
            problemMemento.putString("title", problems[i].getDisplayName());
            problemMemento.putLong("attempts", this.problemAttempts[id]);
            if (this.problemAttempts[id] > 0) {
                ++this.grandTotalProblemAttempts;
            }
            problemMemento.putLong("numberSolved", this.problemSolutions[id]);
            if (this.problemSolutions[id] <= 0) continue;
            problemMemento.putLong("bestSolutionTime", this.problemBestTime[id]);
            problemMemento.putLong("lastSolutionTime", this.problemLastTime[id]);
        }
        summaryMememento.putInteger("totalAttempts", this.grandTotalAttempts);
        summaryMememento.putInteger("totalSolved", this.grandTotalSolutions);
        summaryMememento.putInteger("problemsAttempted", this.grandTotalProblemAttempts);
    }

    private void generateStandingsValues(TreeMap<Run, Run> runTreeMap, Hashtable<String, StandingsRecord> standingsHash, Hashtable<ElementId, Integer> problemsHash) throws IllegalContestState {
        long oldTime = 0L;
        long youngTime = -1L;
        RunComparatorByTeam runComparatorByTeam = new RunComparatorByTeam();
        TreeMap<Run, Run> problemTreeMap = new TreeMap<Run, Run>(runComparatorByTeam);
        Collection<Run> runColl = runTreeMap.values();
        Iterator<Run> runIterator = runColl.iterator();
        String lastUser = "";
        String lastProblem = "";
        while (runIterator.hasNext()) {
            Run o = runIterator.next();
            Run run = o;
            if (!lastUser.equals(run.getSubmitter().toString()) || !lastProblem.equals(run.getProblemId().toString())) {
                if (!problemTreeMap.isEmpty()) {
                    ProblemSummaryInfo problemSummaryInfo = this.calcProblemScoreData(problemTreeMap);
                    StandingsRecord standingsRecord = standingsHash.get(lastUser);
                    SummaryRow summaryRow = standingsRecord.getSummaryRow();
                    summaryRow.put(problemsHash.get(problemSummaryInfo.getProblemId()), problemSummaryInfo);
                    standingsRecord.setSummaryRow(summaryRow);
                    standingsRecord.setPenaltyPoints(standingsRecord.getPenaltyPoints() + (long)problemSummaryInfo.getPenaltyPoints());
                    if (problemSummaryInfo.isSolved()) {
                        standingsRecord.setNumberSolved(standingsRecord.getNumberSolved() + 1);
                        oldTime = standingsRecord.getLastSolved();
                        youngTime = standingsRecord.getFirstSolved();
                        if (problemSummaryInfo.getSolutionTime() > oldTime) {
                            standingsRecord.setLastSolved(problemSummaryInfo.getSolutionTime());
                        }
                        if (youngTime < 0L || problemSummaryInfo.getSolutionTime() < youngTime) {
                            standingsRecord.setFirstSolved(problemSummaryInfo.getSolutionTime());
                        }
                    }
                    standingsHash.put(lastUser, standingsRecord);
                    problemTreeMap.clear();
                }
                lastUser = run.getSubmitter().toString();
                lastProblem = run.getProblemId().toString();
            }
            problemTreeMap.put(run, run);
        }
        if (!problemTreeMap.isEmpty()) {
            ProblemSummaryInfo problemSummaryInfo = this.calcProblemScoreData(problemTreeMap);
            StandingsRecord standingsRecord = standingsHash.get(lastUser);
            SummaryRow summaryRow = standingsRecord.getSummaryRow();
            summaryRow.put(problemsHash.get(problemSummaryInfo.getProblemId()), problemSummaryInfo);
            standingsRecord.setSummaryRow(summaryRow);
            standingsRecord.setPenaltyPoints(standingsRecord.getPenaltyPoints() + (long)problemSummaryInfo.getPenaltyPoints());
            if (problemSummaryInfo.isSolved()) {
                standingsRecord.setNumberSolved(standingsRecord.getNumberSolved() + 1);
                oldTime = standingsRecord.getLastSolved();
                youngTime = standingsRecord.getFirstSolved();
                if (problemSummaryInfo.getSolutionTime() > oldTime) {
                    standingsRecord.setLastSolved(problemSummaryInfo.getSolutionTime());
                }
                if (youngTime < 0L || problemSummaryInfo.getSolutionTime() < youngTime) {
                    standingsRecord.setFirstSolved(problemSummaryInfo.getSolutionTime());
                }
            }
            standingsHash.put(lastUser, standingsRecord);
        }
        problemTreeMap.clear();
        problemTreeMap = null;
    }

    private void initializeStandingsRecordHash(AccountList accountList, Account[] accounts, Problem[] problems, Hashtable<String, StandingsRecord> standingsRecordHash) {
        for (int i = 0; i < accountList.size(); ++i) {
            Account account = accounts[i];
            if (account.getClientId().getClientType() != ClientType.Type.TEAM || !account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD)) continue;
            StandingsRecord standingsRecord = new StandingsRecord();
            SummaryRow summaryRow = standingsRecord.getSummaryRow();
            for (int j = 0; j < problems.length; ++j) {
                ProblemSummaryInfo problemSummaryInfo = new ProblemSummaryInfo();
                problemSummaryInfo.setProblemId(problems[j].getElementId());
                problemSummaryInfo.setPenaltyPoints(0);
                summaryRow.put(j + 1, problemSummaryInfo);
            }
            standingsRecord.setSummaryRow(summaryRow);
            standingsRecord.setClientId(account.getClientId());
            standingsRecordHash.put(account.getClientId().toString(), standingsRecord);
        }
    }

    private IMemento createSummaryMomento(ContestInformation contestInformation, XMLMemento mementoRoot) {
        IMemento memento = mementoRoot.createChild("standingsHeader");
        String title = contestInformation.getContestTitle();
        if (title == null || title.length() == 0) {
            title = "Contest";
        }
        memento.putString("title", title);
        VersionInfo versionInfo = new VersionInfo();
        memento.putString("systemName", versionInfo.getSystemName());
        memento.putString("systemVersion", versionInfo.getVersionNumber() + " build " + versionInfo.getBuildNumber());
        memento.putString("systemURL", versionInfo.getSystemURL());
        memento.putString("currentDate", new Date().toString());
        memento.putString("generatorId", "$Id: DefaultScoringAlgorithm.java 2534 2012-04-18 02:27:12Z boudreat $");
        return memento;
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        for (int i = 0; i < propList.length; ++i) {
            String key = propList[i][0];
            String value = propList[i][1];
            int colon = value.indexOf(":");
            String defaultValue = value.substring(0, colon);
            properties.put(key, defaultValue);
        }
        return properties;
    }
}

