/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class SolutionsByProblemReport
implements IReport {
    private static final long serialVersionUID = 1389857029019327047L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Hashtable<ElementId, Integer> problemLookup = new Hashtable();
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) {
        Problem[] problems = this.contest.getProblems();
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        if (problems == null || problems.length == 0) {
            printWriter.println("No problems defined, no summary");
            return;
        }
        int idx = 0;
        for (Problem problem : problems) {
            this.problemLookup.put(problem.getElementId(), new Integer(idx));
            ++idx;
        }
        int[] numberSolved = new int[problems.length];
        int[] numberAttempted = new int[problems.length];
        int[] didNotSolve = new int[problems.length];
        int numDeleted = 0;
        int totalNotSolved = 0;
        int totalSolved = 0;
        int totalAttempts = 0;
        for (Run run : runs) {
            if (!run.isDeleted() && this.filter.matches(run)) {
                int theIndex = this.problemLookup.get(run.getProblemId());
                if (run.isSolved()) {
                    int n = theIndex;
                    numberSolved[n] = numberSolved[n] + 1;
                } else {
                    int n = theIndex;
                    didNotSolve[n] = didNotSolve[n] + 1;
                }
                int n = theIndex;
                numberAttempted[n] = numberAttempted[n] + 1;
                continue;
            }
            if (!run.isDeleted() || !this.filter.matches(run)) continue;
            ++numDeleted;
        }
        printWriter.println("Incorrect  Correct  Total     %   Problem Description");
        printWriter.println("--------- --------- ----- ------  -------------------");
        for (IElementObject iElementObject : problems) {
            int theIndex = this.problemLookup.get(((Problem)iElementObject).getElementId());
            totalNotSolved += didNotSolve[theIndex];
            totalSolved += numberSolved[theIndex];
            totalAttempts += numberAttempted[theIndex];
            printWriter.format("   %3d       %3d     %3d ", didNotSolve[theIndex], numberSolved[theIndex], numberAttempted[theIndex]);
            printWriter.print(" " + this.printPercent(numberSolved[theIndex], numberAttempted[theIndex]) + "  ");
            printWriter.println(iElementObject);
        }
        printWriter.println("--------- --------- ----- ------  -------------------");
        printWriter.format("   %3d       %3d     %3d ", totalNotSolved, totalSolved, totalAttempts);
        printWriter.print(" " + this.printPercent(totalSolved, totalAttempts) + "  ");
        printWriter.print("Totals");
        printWriter.println();
        printWriter.println("--------- --------- ----- ------  -------------------");
        if (numDeleted > 0) {
            printWriter.println("There are " + numDeleted + " runs marked deleted");
        }
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Solutions By Problem";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Solutions By Problem Report";
    }

    protected String printPercent(long numerator, long denominator) {
        long intpart = denominator > 0L ? numerator * 10000L / denominator : 0L;
        long decpart = intpart % 100L;
        if (numerator > 0L) {
            return new String(this.longrj(intpart /= 100L, 3, " ") + "." + this.longrj(decpart, 2, "0"));
        }
        return new String("  0.00");
    }

    protected String longrj(long l, int cols, String pads) {
        return this.longrj(new Long(l), cols, pads);
    }

    protected String longrj(Long l, int cols, String pads) {
        String s = "" + l.toString();
        while (s.length() < cols) {
            s = pads + s;
        }
        return s;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

