/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;

public class ProblemsReport
implements IReport {
    private static final long serialVersionUID = 977130815676827828L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    private void writeContestTime(PrintWriter printWriter) {
        printWriter.println();
        GregorianCalendar resumeTime = this.contest.getContestTime().getResumeTime();
        if (resumeTime == null) {
            printWriter.println("Contest date/time: never started");
        } else {
            printWriter.println("Contest date/time: " + resumeTime.getTime());
        }
    }

    private void writeRow(PrintWriter printWriter, Problem problem, ProblemDataFiles problemDataFiles) {
        String deletedText = "";
        if (!problem.isActive()) {
            deletedText = " [HIDDEN] ";
        }
        printWriter.println("  Problem '" + problem + deletedText + "' ver=" + problem.getElementId().getVersionNumber() + " id=" + problem.getElementId());
        printWriter.println("       Data file name   : " + problem.getDataFileName());
        printWriter.println("       Answer file name : " + problem.getAnswerFileName());
        printWriter.print("   Execution time limit : " + problem.getTimeOutInSeconds() + " seconds");
        if (problem.getTimeOutInSeconds() == 0) {
            printWriter.print(" (no time limit when zero seconds)");
        }
        printWriter.println();
        printWriter.println("        Using validator : " + problem.isValidatedProblem());
        printWriter.println("         Validator name : " + problem.getValidatorProgramName());
        printWriter.println("     Validator cmd line : " + problem.getValidatorCommandLine());
        printWriter.println("     Validator option # : " + problem.getWhichPC2Validator());
        printWriter.println("    Using pc2 validator : " + problem.isUsingPC2Validator());
        if (problem.getAnswerFileName() != null) {
            if (problemDataFiles != null) {
                if (problemDataFiles.getJudgesAnswerFiles().length == 0) {
                    printWriter.println("                          Warning - no answer files defined (no contents) ");
                }
            } else {
                printWriter.println("                          Warning - no data/answer files defined (null problemDataFiles) ");
            }
        }
        if (problem.getAnswerFileName() != null) {
            if (problemDataFiles != null) {
                if (problemDataFiles.getJudgesDataFiles().length == 0) {
                    printWriter.println("                          Warning - no judges data files defined (no contents) ");
                }
            } else {
                printWriter.println("                          Warning - no data/judge files defined (null problemDataFiles) ");
            }
        }
        this.writeProblemDataFiles(printWriter, problemDataFiles);
    }

    private void writeProblemDataFiles(PrintWriter printWriter, ProblemDataFiles problemDataFiles) {
        if (problemDataFiles != null) {
            int bytes;
            SerializedFile[] judgesDataFiles = problemDataFiles.getJudgesDataFiles();
            SerializedFile[] judgesAnswerFiles = problemDataFiles.getJudgesAnswerFiles();
            SerializedFile validatorFile = problemDataFiles.getValidatorFile();
            if (judgesDataFiles != null) {
                printWriter.println("                  " + judgesDataFiles.length + " judge data files");
                if (judgesDataFiles.length > 0) {
                    for (SerializedFile serializedFile : judgesDataFiles) {
                        bytes = 0;
                        if (serializedFile.getBuffer() != null) {
                            bytes = serializedFile.getBuffer().length;
                        }
                        printWriter.println("                    judge data file '" + serializedFile.getName() + "' " + bytes + " bytes");
                    }
                }
            } else {
                printWriter.println("                  * No judge's data files *");
            }
            if (judgesAnswerFiles != null) {
                printWriter.println("                  " + judgesAnswerFiles.length + " judge answer files");
                if (judgesAnswerFiles.length > 0) {
                    for (SerializedFile serializedFile : judgesAnswerFiles) {
                        bytes = 0;
                        if (serializedFile.getBuffer() != null) {
                            bytes = serializedFile.getBuffer().length;
                        }
                        printWriter.println("                    judge ans. file '" + serializedFile.getName() + "' " + bytes + " bytes");
                    }
                }
            } else {
                printWriter.println("                  * No judge's answer files *");
            }
            if (validatorFile != null) {
                printWriter.println("                  1 validator file");
                int bytes2 = 0;
                if (validatorFile.getBuffer() != null) {
                    bytes2 = validatorFile.getBuffer().length;
                }
                printWriter.println("                    validator file '" + validatorFile.getName() + "' " + bytes2 + " bytes");
            } else {
                printWriter.println("                  * No validator files *");
            }
        } else {
            printWriter.println("                  * No judge's files *");
        }
    }

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblems().length + " problems --");
        for (Problem problem : this.contest.getProblems()) {
            printWriter.println();
            ProblemDataFiles problemDataFiles = this.contest.getProblemDataFile(problem);
            this.writeRow(printWriter, problem, problemDataFiles);
        }
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblemDataFiles().length + " problem data file sets --");
        for (IElementObject iElementObject : this.contest.getProblemDataFiles()) {
            printWriter.println();
            Problem problem = this.contest.getProblem(((ProblemDataFiles)iElementObject).getProblemId());
            printWriter.println("  Problem Data File set for " + problem + " id=" + ((ProblemDataFiles)iElementObject).getProblemId());
            this.writeProblemDataFiles(printWriter, (ProblemDataFiles)iElementObject);
        }
        if (this.contest.getGeneralProblem() == null) {
            printWriter.println(" General Problem: (not defined) ");
        } else {
            printWriter.println(" General Problem: " + this.contest.getGeneralProblem().getElementId());
        }
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
        this.writeContestTime(printWriter);
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Problems";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Problems Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

