/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.SummaryCounts;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

public class ListRunLanguages
implements IReport {
    private static final long serialVersionUID = 1389857029019327047L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Hashtable<ElementId, Integer> langLookup = new Hashtable();
    private Filter filter = new Filter();

    protected void printClientsShort(PrintWriter printWriter, ClientId[] clientIds) {
        ClientId clientId = null;
        for (int i = 0; i < clientIds.length - 1; ++i) {
            clientId = clientIds[i];
            printWriter.print(clientId.getClientNumber() + "s" + clientId.getSiteNumber() + ",");
        }
        clientId = clientIds[clientIds.length - 1];
        printWriter.print(clientId.getClientNumber() + "s" + clientId.getSiteNumber() + ".");
    }

    protected void printClients(PrintWriter printWriter, ClientId[] clientIds) {
        ClientId clientId = null;
        if (clientIds.length == 0) {
            return;
        }
        ClientId lastClientId = clientIds[0];
        printWriter.print("Site " + lastClientId.getSiteNumber() + " team " + lastClientId.getClientNumber());
        boolean inRange = false;
        for (int i = 1; i < clientIds.length; ++i) {
            clientId = clientIds[i];
            if (lastClientId.getSiteNumber() != clientId.getSiteNumber()) {
                if (inRange) {
                    printWriter.print(lastClientId.getClientNumber());
                    inRange = false;
                }
                printWriter.print(" Site " + clientId.getSiteNumber() + " team " + clientId.getClientNumber());
            } else if (lastClientId.getSiteNumber() == clientId.getSiteNumber() && lastClientId.getClientNumber() + 1 == clientId.getClientNumber()) {
                if (!inRange) {
                    printWriter.print("-");
                    inRange = true;
                }
            } else {
                if (inRange) {
                    printWriter.print(lastClientId.getClientNumber());
                }
                printWriter.print("," + clientId.getClientNumber());
                inRange = false;
            }
            lastClientId = clientId;
        }
        if (inRange) {
            printWriter.print(clientId.getClientNumber());
        }
    }

    public void writeReport(PrintWriter printWriter) {
        int theIndex;
        SummaryCounts summaryCounts = new SummaryCounts();
        Language[] languages = this.contest.getLanguages();
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        if (languages == null || languages.length == 0) {
            printWriter.println("No languages defined, no summary");
            return;
        }
        int idx = 0;
        for (Language language : languages) {
            this.langLookup.put(language.getElementId(), new Integer(idx));
            ++idx;
        }
        int[] numberSolved = new int[languages.length];
        int[] numberAttempted = new int[languages.length];
        int[] didNotSolve = new int[languages.length];
        int numDeleted = 0;
        for (Run run : runs) {
            if (!run.isDeleted() && this.filter.matches(run)) {
                theIndex = this.langLookup.get(run.getLanguageId());
                if (run.isSolved()) {
                    int n = theIndex;
                    numberSolved[n] = numberSolved[n] + 1;
                    summaryCounts.increment(run.getSubmitter(), run.getLanguageId());
                } else {
                    int n = theIndex;
                    didNotSolve[n] = didNotSolve[n] + 1;
                }
                int n = theIndex;
                numberAttempted[n] = numberAttempted[n] + 1;
                continue;
            }
            if (!run.isDeleted() || !this.filter.matches(run)) continue;
            ++numDeleted;
        }
        for (IElementObject iElementObject : languages) {
            theIndex = this.langLookup.get(((Language)iElementObject).getElementId());
            if (!this.filter.matches((Language)iElementObject)) continue;
            printWriter.println("Language " + iElementObject);
            ClientId[] clientIds = summaryCounts.getClients(((Language)iElementObject).getElementId());
            printWriter.print("      " + clientIds.length + " teams: ");
            Arrays.sort(clientIds, new ClientIdComparator());
            this.printClients(printWriter, clientIds);
            printWriter.println();
            printWriter.println("      " + numberSolved[theIndex] + " submissions solved problems");
            printWriter.println("      " + didNotSolve[theIndex] + " submissions did not solved problems");
            printWriter.println("      " + numberAttempted[theIndex] + " total ");
            printWriter.println();
        }
        if (numDeleted > 0) {
            printWriter.println("There are " + numDeleted + " runs marked deleted");
        }
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Submissions by Language";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Submissions by Language Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

