/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Pluralize;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileComparatorByName;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class InternalDumpReport
implements IReport {
    private static final long serialVersionUID = -82937493006891083L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private void printClientSettings(PrintWriter printWriter) {
        ClientSettings[] clientSettingsArray = this.contest.getClientSettingsList();
        printWriter.println();
        printWriter.println("-- Client Settings --");
        Arrays.sort(clientSettingsArray, new ClientSettingsComparator());
        for (ClientSettings clientSettings : clientSettingsArray) {
            printWriter.println("    For: " + clientSettings.getClientId());
            for (String key : clientSettings.getKeys()) {
                printWriter.println("      " + key + " = " + clientSettings.getProperty(key));
            }
        }
    }

    private void printNotificationSettings(PrintWriter printWriter) {
        ClientSettings[] clientSettingsArray = this.contest.getClientSettingsList();
        printWriter.println();
        printWriter.println("-- " + clientSettingsArray.length + " Notification Settings --");
        Arrays.sort(clientSettingsArray, new ClientSettingsComparator());
        for (ClientSettings clientSettings : clientSettingsArray) {
            NotificationSetting notificationSetting = clientSettings.getNotificationSetting();
            if (notificationSetting == null) continue;
            printWriter.println("    For: " + clientSettings.getClientId());
            this.dumpNotification(printWriter, clientSettings.getNotificationSetting());
        }
    }

    protected void dumpNotification(PrintWriter printWriter, NotificationSetting notificationSetting2) {
        printWriter.println();
        if (notificationSetting2 == null) {
            printWriter.println("          No delivery notification settings defined.");
        } else {
            JudgementNotification judgementNotification = null;
            judgementNotification = notificationSetting2.getPreliminaryNotificationYes();
            printWriter.println("          Prelim Yes suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getPreliminaryNotificationNo();
            printWriter.println("          Prelim No  suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationYes();
            printWriter.println("          Final  Yes suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationNo();
            printWriter.println("          Final  No  suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        }
    }

    public void dumpProperties(PrintWriter printWriter, String comment, Properties properties) {
        printWriter.println("  Properties " + comment + " " + properties);
        if (properties == null) {
            return;
        }
        Set<Object> set = properties.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            printWriter.println("     " + (String)key + "='" + properties.get(key) + "'");
        }
    }

    private void printContestInformation(PrintWriter printWriter) {
        ContestInformation contestInformation = this.contest.getContestInformation();
        printWriter.println();
        printWriter.println("-- Contest Information --");
        printWriter.println("  Title : '" + contestInformation.getContestTitle() + "'");
        printWriter.println("  URL   : '" + contestInformation.getContestURL() + "'");
        printWriter.println();
        printWriter.println("  Include Preliminary Judgements in Scoring Algorithm : " + Utilities.yesNoString(contestInformation.isPreliminaryJudgementsUsedByBoard()));
        printWriter.println("  Send Notifications for Preliminary Judgements       : " + Utilities.yesNoString(contestInformation.isPreliminaryJudgementsTriggerNotifications()));
        printWriter.println("  Send Additional Run Status Information              : " + Utilities.yesNoString(contestInformation.isSendAdditionalRunStatusInformation()));
        printWriter.println();
        printWriter.println("  Judges' Default Answer: '" + contestInformation.getJudgesDefaultAnswer() + "'");
        printWriter.println("  Max output file size " + contestInformation.getMaxFileSize());
        if (contestInformation.getTeamDisplayMode() != null) {
            printWriter.println("  Judges see: " + (Object)((Object)contestInformation.getTeamDisplayMode()));
        } else {
            printWriter.println("  Judges see: " + (Object)((Object)ContestInformation.TeamDisplayMask.LOGIN_NAME_ONLY));
        }
        this.dumpProperties(printWriter, "Scoring Properties", contestInformation.getScoringProperties());
        printWriter.println();
        IStorage storage = this.contest.getStorage();
        if (storage == null) {
            printWriter.println("Storage - no storage defined");
            printWriter.println();
        } else {
            printWriter.println("Storage  (dir)  : " + this.contest.getStorage().getDirectoryName());
            printWriter.println("        (class) : " + this.contest.getStorage().getClass().getName());
            printWriter.println();
        }
    }

    private void printAccounts(PrintWriter printWriter, Account[] accounts) {
        Arrays.sort(accounts, new AccountComparator());
        for (Account account : accounts) {
            if (!this.filter.matches(account)) continue;
            printWriter.print("   Site " + account.getSiteNumber());
            printWriter.format(" %-15s", account.getClientId().getName());
            printWriter.println(" id=" + account.getElementId());
        }
    }

    private void printAccounts(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Accounts -- " + this.getFilterText());
        for (ClientType.Type ctype : ClientType.Type.values()) {
            Vector<Account> vector = this.contest.getAccounts(ctype);
            Account[] accounts = vector.toArray(new Account[vector.size()]);
            int accountCount = this.filter.countAccounts(accounts);
            printWriter.print("Accounts " + ctype.toString() + " there are " + accountCount);
            printWriter.println();
            this.printAccounts(printWriter, accounts);
        }
        this.printAllAccounts(printWriter);
    }

    private void printAllAccounts(PrintWriter printWriter) {
        Vector<Account> vector = this.contest.getAccounts(ClientType.Type.ALL);
        printWriter.println();
        Account[] accounts = vector.toArray(new Account[vector.size()]);
        int accountCount = this.filter.countAccounts(accounts);
        printWriter.print("There are " + accountCount);
        printWriter.println();
        this.printAccounts(printWriter, accounts);
    }

    private String getFilterText() {
        if (this.filter != null) {
            return " (filtered) ";
        }
        return "";
    }

    public void writeReport(PrintWriter printWriter) {
        int exceptionCount = 0;
        if (this.contest == null) {
            printWriter.println();
            printWriter.println(" Warning contest is null ");
        }
        if (this.controller == null) {
            printWriter.println();
            printWriter.println(" Warning controller is null ");
        } else if (this.controller.getLog() == null) {
            printWriter.println();
            printWriter.println(" Warning controller log is null ");
        }
        try {
            printWriter.println();
            printWriter.println("This is site " + this.contest.getSiteNumber());
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            printWriter.println();
            printWriter.println("Contest hash is            " + this.contest);
            printWriter.println("Controller hash is         " + this.controller);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printProfile(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printLocalContestTime(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printCurrentClientInfo(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printSites(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printContestTimes(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printContestInformation(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printProblems(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printLanguages(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printJudgements(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printAccounts(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printRuns(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printClarifications(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printLogins(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printConnections(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printClientSettings(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printNotificationSettings(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printContestPassword(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        try {
            this.printFinalizeData(printWriter);
        }
        catch (Exception e) {
            printWriter.println("Exception in report: " + e.getMessage());
            e.printStackTrace(printWriter);
            ++exceptionCount;
        }
        if (exceptionCount > 0) {
            printWriter.println();
            printWriter.println(" There were " + exceptionCount + " exceptions.");
        }
    }

    private void printFinalizeData(PrintWriter printWriter) {
        FinalizeData data = this.contest.getFinalizeData();
        printWriter.println();
        printWriter.println("-- Finalized Info -- ");
        if (data != null) {
            printWriter.println("  certified   : " + data.isCertified());
            if (data.isCertified()) {
                printWriter.println("  certify date: " + data.getCertificationDate());
            }
            printWriter.println("  gold rank   : " + data.getGoldRank());
            printWriter.println("  silver rank : " + data.getSilverRank());
            printWriter.println("  bronze rank : " + data.getBronzeRank());
            printWriter.println("  comment     : " + data.getComment());
        } else {
            printWriter.println("   ** no data ** ");
        }
    }

    private void printContestPassword(PrintWriter printWriter) {
        Profile profile = this.contest.getProfile();
        String password = this.contest.getContestPassword();
        printWriter.println("Profile name  : " + profile.getName());
        printWriter.println("  description : " + profile.getDescription());
        printWriter.println("     password : " + password);
    }

    private void writeProfile(PrintWriter printWriter, Profile profile) {
        printWriter.println("Profile name  : " + profile.getName());
        printWriter.println("  description : " + profile.getDescription());
        printWriter.println("  create date : " + profile.getCreateDate().toString());
        printWriter.println("   element id : " + profile.getElementId());
    }

    private void writeActiveProfile(PrintWriter printWriter) {
        Profile profile = this.contest.getProfile();
        this.writeProfile(printWriter, profile);
    }

    private void printProfile(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Active Profile --");
        this.writeActiveProfile(printWriter);
        printWriter.println();
        Profile[] profiles = this.contest.getProfiles();
        Arrays.sort(profiles, new ProfileComparatorByName());
        printWriter.println("-- " + profiles.length + " " + Pluralize.simplePluralize("Profile", profiles.length) + " --");
        for (Profile profile : profiles) {
            printWriter.println();
            printWriter.println("    title    : " + profile.getName());
            printWriter.println("  identifier : " + profile.getContestId());
            printWriter.println("  description: " + profile.getDescription());
            printWriter.println("      created: " + profile.getCreateDate());
        }
        printWriter.println();
    }

    private void printCurrentClientInfo(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Client Info --");
        printWriter.println();
        Account account = this.contest.getAccount(this.contest.getClientId());
        String name = this.contest.getClientId().getName();
        if (account != null) {
            name = account.getDisplayName();
        }
        printWriter.println("* Client Id = " + this.contest.getClientId() + " " + name);
    }

    private void printLocalContestTime(PrintWriter printWriter) {
        ContestTime localContestTime = this.contest.getContestTime();
        printWriter.println();
        printWriter.println("-- Local Contest Time --");
        printWriter.println();
        if (localContestTime != null) {
            if (localContestTime.isContestRunning()) {
                printWriter.print("Contest is RUNNING");
            } else {
                printWriter.print("Contest is STOPPED");
            }
            printWriter.print(" elapsed = " + localContestTime.getElapsedTimeStr());
            printWriter.print(" remaining = " + localContestTime.getRemainingTimeStr());
            printWriter.print(" length = " + localContestTime.getContestLengthStr());
            printWriter.println();
        } else {
            printWriter.println("Contest Time is undefined (null)");
        }
    }

    private void printContestTimes(PrintWriter printWriter) {
        printWriter.println();
        ContestTime[] contestTimes = this.contest.getContestTimes();
        Arrays.sort(contestTimes, new ContestTimeComparator());
        printWriter.println("-- " + contestTimes.length + " Contest Times --");
        for (ContestTime contestTime : contestTimes) {
            if (this.contest.getSiteNumber() == contestTime.getSiteNumber()) {
                printWriter.print("  * ");
            } else {
                printWriter.print("    ");
            }
            String state = "STOPPED";
            if (contestTime.isContestRunning()) {
                state = "STARTED";
            }
            printWriter.println("  Site " + contestTime.getSiteNumber() + " " + state + " " + contestTime.getElapsedTimeStr() + " " + contestTime.getRemainingTimeStr() + " " + contestTime.getContestLengthStr());
            printWriter.println("         past end " + contestTime.isPastEndOfContest() + ", halt at end " + contestTime.isHaltContestAtTimeZero() + ", offset " + contestTime.getLocalClockOffset() + ", id=" + contestTime.getElementId() + " site " + contestTime.getElementId().getSiteNumber());
        }
    }

    private void printLanguages(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getLanguages().length + " languages --");
        for (Language language : this.contest.getLanguages()) {
            printWriter.println("  '" + language + "' id=" + language.getElementId());
        }
    }

    private void printProblems(PrintWriter printWriter) {
        printWriter.println();
        if (this.contest.getGeneralProblem() == null) {
            printWriter.println(" General Problem: (not defined) ");
        } else {
            printWriter.println(" General Problem: " + this.contest.getGeneralProblem().getElementId());
        }
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblems().length + " problems --");
        for (Problem problem : this.contest.getProblems()) {
            printWriter.println("  '" + problem + "' id=" + problem.getElementId());
        }
    }

    private void printLogins(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Logins -- ");
        for (ClientType.Type ctype : ClientType.Type.values()) {
            ClientId[] clientIds = this.contest.getAllLoggedInClients(ctype);
            if (clientIds.length <= 0) continue;
            printWriter.println("Logged in " + ctype.toString());
            for (ClientId clientId : clientIds) {
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                printWriter.println("   " + clientId + " on " + connectionHandlerID);
            }
        }
    }

    private void printSites(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getSites().length + " Sites --");
        Site[] sites = this.contest.getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        for (Site site1 : sites) {
            String hostName = site1.getConnectionInfo().getProperty("IP_KEY");
            String portStr = site1.getConnectionInfo().getProperty("PORT_KEY");
            printWriter.println("Site " + site1.getSiteNumber() + " " + hostName + ":" + portStr + " '" + site1.getDisplayName() + "' " + " password='" + site1.getPassword() + "' id=" + site1.getElementId());
        }
    }

    private void printJudgements(PrintWriter printWriter) {
        printWriter.println();
        Judgement[] judgements = this.contest.getJudgements();
        printWriter.println("-- " + judgements.length + " Judgements --");
        printWriter.println("     Active Judgements");
        for (Judgement judgement : judgements) {
            if (!judgement.isActive()) continue;
            printWriter.print("  '" + judgement);
            printWriter.println("' id=" + judgement.getElementId());
        }
        printWriter.println("     All Judgements");
        for (Judgement judgement : judgements) {
            String hiddenText = "";
            if (!judgement.isActive()) {
                hiddenText = "[HIDDEN] ";
            }
            printWriter.print("  '" + judgement);
            printWriter.println("' " + hiddenText + "id=" + judgement.getElementId());
        }
    }

    public void printConnections(PrintWriter printWriter) {
        printWriter.println();
        ConnectionHandlerID[] connectionHandlerIDs = this.contest.getConnectionHandleIDs();
        printWriter.println("-- " + connectionHandlerIDs.length + " Connections --");
        for (ConnectionHandlerID connectionHandlerID : connectionHandlerIDs) {
            ClientId clientId = this.contest.getLoginClientId(connectionHandlerID);
            printWriter.print("  ");
            if (clientId != null) {
                printWriter.print(" [" + clientId.getTripletKey() + "] ");
            }
            printWriter.println(connectionHandlerID);
        }
    }

    public void printHeader(PrintWriter printWriter) {
        VersionInfo versionInfo = new VersionInfo();
        printWriter.println(versionInfo.getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(versionInfo.getSystemVersionInfo());
        printWriter.println("Build " + versionInfo.getBuildNumber());
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        if (inFilter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        this.filter = inFilter;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
        printWriter.close();
        printWriter = null;
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Internal Dump";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Internal Dump Report";
    }

    private void printRuns(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        int count = this.filter.countRuns(runs);
        printWriter.print("-- " + count + " runs --" + this.getFilterText());
        printWriter.println();
        if (count > 0) {
            for (Run run : runs) {
                if (!this.filter.matches(run)) continue;
                printWriter.println("  " + run);
            }
        }
    }

    private void printClarifications(PrintWriter printWriter) {
        printWriter.println();
        Clarification[] clarifications = this.contest.getClarifications();
        Arrays.sort(clarifications, new ClarificationComparator());
        int count = this.filter.countClarifications(clarifications);
        printWriter.print("-- " + count + " clarifications -- " + this.getFilterText());
        printWriter.println();
        for (Clarification clarification : clarifications) {
            if (!this.filter.matches(clarification)) continue;
            printWriter.println("  " + clarification);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int countClientSettings(ClientSettings[] clientSettings) {
        int count = 0;
        for (ClientSettings clientSettings2 : clientSettings) {
            if (!this.filter.matches(clientSettings2.getClientId())) continue;
            ++count;
        }
        return count;
    }
}

