/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.IScoringAlgorithm;
import edu.csus.ecs.pc2.core.util.XSLTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class HTMLReport
implements IReport {
    private static final long serialVersionUID = 808321237990590312L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();
    private String styleSheetDirectoryName = null;
    private IScoringAlgorithm scoringAlgorithm = new DefaultScoringAlgorithm();
    private String reportDirectory = "reports";

    private String getDefaultSyleSheetDirectoryName() {
        String xslDir = "data" + File.separator + "xsl";
        File xslDirFile = new File(xslDir);
        if (!xslDirFile.canRead() || !xslDirFile.isDirectory()) {
            VersionInfo versionInfo = new VersionInfo();
            xslDir = versionInfo.locateHome() + File.separator + xslDir;
        }
        return xslDir;
    }

    public String getStyleSheetDirectoryName() {
        if (this.styleSheetDirectoryName == null) {
            this.styleSheetDirectoryName = this.getDefaultSyleSheetDirectoryName();
        }
        return this.styleSheetDirectoryName;
    }

    private String createHTML(String xmlString, String xsltFileName) throws Exception {
        XSLTransformer xslTransformer = new XSLTransformer();
        File xslFile = new File(xsltFileName);
        String htmlString = xslTransformer.transformToString(xslFile, xmlString);
        return htmlString;
    }

    protected Properties getScoringProperties() {
        String[] keys;
        Properties properties = this.getContest().getContestInformation().getScoringProperties();
        if (properties == null) {
            properties = new Properties();
        }
        Properties defProperties = DefaultScoringAlgorithm.getDefaultProperties();
        for (String key : keys = defProperties.keySet().toArray(new String[defProperties.keySet().size()])) {
            if (properties.containsKey(key)) continue;
            properties.put(key, defProperties.get(key));
        }
        return properties;
    }

    public void writeReport(PrintWriter printWriter) throws Exception {
        File file;
        String xslDir = this.getStyleSheetDirectoryName();
        File inputDir = new File(xslDir);
        if (!inputDir.isDirectory()) {
            throw new Exception("Unable to find XSLT source directory " + xslDir);
        }
        String outputDirectory = this.reportDirectory;
        if (this.isServer()) {
            outputDirectory = this.getContest().getProfile().getProfilePath() + File.separator + this.reportDirectory;
        }
        if (!(file = new File(outputDirectory)).isDirectory()) {
            file.mkdirs();
        }
        String[] inputFiles = inputDir.list();
        for (int i = 0; i < inputFiles.length; ++i) {
            String filename = inputFiles[i];
            if (!filename.endsWith(".xsl")) continue;
            String xsltFileName = inputDir.getCanonicalPath() + File.separator + filename;
            try {
                Properties scoringProperties = this.getScoringProperties();
                String scoreboardXML = this.scoringAlgorithm.getStandings(this.getContest(), scoringProperties, this.log);
                String html = this.createHTML(scoreboardXML, xsltFileName);
                String name = filename.replaceAll(".xsl$", "");
                String outputFilename = this.getReportFilename(this, name, "html");
                String htmlFilename = outputDirectory + File.separator + outputFilename;
                this.writeString(htmlFilename, html);
                printWriter.println("Wrote file " + htmlFilename);
                printWriter.println("  based on " + filename);
                printWriter.println();
                continue;
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
        }
    }

    private void writeString(String filename, String html) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        printWriter.print(html);
        printWriter.close();
        printWriter = null;
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
        printWriter.println();
        GregorianCalendar resumeTime = this.contest.getContestTime().getResumeTime();
        if (resumeTime == null) {
            printWriter.println("Contest date/time: never started");
        } else {
            printWriter.println("Contest date/time: " + resumeTime.getTime());
        }
    }

    public String getReportFilename(IReport selectedReport, String extraPart, String extension) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        if (extraPart != null) {
            if (!extraPart.startsWith(".")) {
                extraPart = "." + extraPart;
            }
            reportName = reportName + extraPart;
        }
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + "." + extension;
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
                printWriter.close();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Standings Web Pages";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Standings Web Pages generator";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    private boolean isServer() {
        return this.contest.getClientId() != null && this.isServer(this.contest.getClientId());
    }

    private boolean isServer(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.SERVER);
    }
}

