/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.PermissionByDescriptionComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;

public class FilterReport
implements IReport {
    private static final long serialVersionUID = -1515524938023295459L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) {
        this.writeReportDetailed(printWriter, this.filter);
    }

    /*
     * WARNING - void declaration
     */
    public void writeReportDetailed(PrintWriter printWriter, Filter inFilter) {
        void var11_31;
        this.filter = null;
        printWriter.println("              Filter: " + inFilter);
        printWriter.println("           Filter On: " + inFilter.isFilterOn());
        printWriter.println("        Filter sites: " + inFilter.isFilteringSites());
        printWriter.println("     Filter problems: " + inFilter.isFilteringProblems());
        printWriter.println("      Filter clients: " + inFilter.isFilteringAccounts());
        printWriter.println("      Filter on time: " + inFilter.isFilteringElapsedTime());
        printWriter.println("    Filter languages: " + inFilter.isFilteringLanguages());
        printWriter.println("   Filter judgements: " + inFilter.isFilteringJudgements());
        printWriter.println("   Filter run states: " + inFilter.isFilteringRunStates());
        printWriter.println("  Filter clar states: " + inFilter.isFilteringClarificationStates());
        printWriter.println();
        if (inFilter.isFilteringElapsedTime()) {
            printWriter.println("-- Filtering on submitted time --");
            if (inFilter.getStartElapsedTime() == -1L) {
                printWriter.println("   Filtering up to and including " + inFilter.getEndElapsedTime() + " minutes");
            } else if (inFilter.getEndElapsedTime() == -1L) {
                printWriter.println("   Filtering starting " + inFilter.getStartElapsedTime() + " minutes (inclusive)");
            } else {
                printWriter.println("   Filtering " + inFilter.getStartElapsedTime() + " through " + inFilter.getEndElapsedTime() + " minutes");
            }
        } else {
            printWriter.println("-- Not filtering on submitted time --");
        }
        printWriter.println();
        ElementId[] elementIds = null;
        elementIds = inFilter.getProblemIdList();
        printWriter.println("-- " + elementIds.length + " Problems filtered --");
        for (ElementId elementId : elementIds) {
            Problem problem = this.contest.getProblem(elementId);
            if (problem == null) {
                printWriter.println("   Not displayed " + problem);
                continue;
            }
            printWriter.println("   " + problem);
        }
        printWriter.println();
        Integer[] integerIds = null;
        integerIds = inFilter.getSiteIdList();
        printWriter.println("-- " + integerIds.length + " Sites filtered --");
        for (Integer n : integerIds) {
            Site site = this.contest.getSite(n);
            if (site == null) {
                printWriter.println("   Not displayed " + site);
                continue;
            }
            printWriter.println("   " + site.getSiteNumber() + " " + site.getDisplayName());
        }
        printWriter.println();
        elementIds = inFilter.getLanguageIdList();
        printWriter.println("-- " + elementIds.length + " Languages filtered --");
        for (Serializable serializable : elementIds) {
            Language language = this.contest.getLanguage((ElementId)serializable);
            if (language == null) {
                printWriter.println("   Not displayed " + language);
                continue;
            }
            printWriter.println("   " + language);
        }
        printWriter.println();
        Permission.Type[] permissionsList = inFilter.getPermissionsList();
        Arrays.sort(permissionsList, new PermissionByDescriptionComparator());
        printWriter.println("-- " + elementIds.length + " permissions filtered --");
        Permission permission = new Permission();
        for (Permission.Type type : permissionsList) {
            printWriter.println("   " + permission.getDescription(type) + " (" + (Object)((Object)type) + ")");
        }
        printWriter.println();
        ClientType.Type[] types = inFilter.getClientTypes();
        printWriter.println("-- " + types.length + " client types filtered --");
        for (ClientType.Type type : types) {
            printWriter.println("   " + (Object)((Object)type));
        }
        printWriter.println();
        elementIds = inFilter.getJudgementIdList();
        printWriter.println("-- " + elementIds.length + " Judgements filtered --");
        for (ElementId elementId : elementIds) {
            Judgement judgement = this.contest.getJudgement(elementId);
            if (judgement == null) {
                printWriter.println("   Not displayed " + judgement);
                continue;
            }
            printWriter.println("   " + judgement);
        }
        printWriter.println();
        ClientId[] clientIdArray = inFilter.getAccountList();
        printWriter.println("-- " + clientIdArray.length + " Accounts filtered --");
        ClientId[] arr$ = clientIdArray;
        int len$ = arr$.length;
        boolean bl = false;
        while (var11_31 < len$) {
            ClientId clientId = arr$[var11_31];
            Account account = this.contest.getAccount(clientId);
            if (account == null) {
                printWriter.println("   Not displayed " + account);
            } else {
                printWriter.println("   " + clientId + " " + account.getDisplayName());
            }
            ++var11_31;
        }
        printWriter.println();
        Run.RunStates[] runStatesList = inFilter.getRunStates();
        printWriter.println("-- " + runStatesList.length + " Run states filtered --");
        for (Run.RunStates runStates : runStatesList) {
            printWriter.println("   " + (Object)((Object)runStates));
        }
        printWriter.println();
        Clarification.ClarificationStates[] clarificationStatesList = inFilter.getClarificationStatesList();
        printWriter.println("-- " + clarificationStatesList.length + " Clarirification states filtered --");
        for (Clarification.ClarificationStates clarificationStates : clarificationStatesList) {
            printWriter.println("   " + (Object)((Object)clarificationStates));
        }
        printWriter.println();
    }

    public void writeReport(PrintWriter printWriter, Filter inFilter) {
        printWriter.println();
        printWriter.println("  '" + inFilter + " " + inFilter);
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Filters";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Filters Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

