/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunCompartorByElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class FastestSolvedSummaryReport
implements IReport {
    private static final long serialVersionUID = 3878379207856922664L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    /*
     * WARNING - void declaration
     */
    public void writeReport(PrintWriter printWriter) {
        void var11_21;
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Vector<Run> fastestRuns = new Vector<Run>();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        Problem[] problems = this.contest.getProblems();
        if (problems == null || problems.length == 0) {
            printWriter.println("No problems defined, nothing to report");
            return;
        }
        int totalSolved = 0;
        for (Run run : runs) {
            if (run.isDeleted() || !run.isSolved()) continue;
            ++totalSolved;
        }
        if (totalSolved < 1) {
            printWriter.println("No runs have been solved, nothing to report");
            return;
        }
        int solved = 0;
        printWriter.println();
        printWriter.println(" ** Summarized by team");
        printWriter.println();
        printWriter.println("   At Team                                Problem");
        printWriter.println("  --- ----------------------------------- ------------------");
        block5: for (Problem problem : problems) {
            Run[] runList = this.filterForProblem(runs, problem);
            Arrays.sort(runList, new RunCompartorByElapsed());
            for (Run run : runList) {
                if (run.isDeleted() || !run.isSolved() || !this.filter.matches(run)) continue;
                fastestRuns.add(run);
                ++solved;
                continue block5;
            }
        }
        runs = fastestRuns.toArray(new Run[fastestRuns.size()]);
        Arrays.sort(runs, new RunCompartorByElapsed());
        for (IElementObject iElementObject : runs) {
            try {
                Account account = this.contest.getAccount(((ISubmission)iElementObject).getSubmitter());
                String accountName = ((ISubmission)iElementObject).getSubmitter().getName() + " (site " + ((ISubmission)iElementObject).getSiteNumber() + ")";
                if (account != null) {
                    accountName = account.getDisplayName();
                }
                Problem problem = this.contest.getProblem(((ISubmission)iElementObject).getProblemId());
                printWriter.format("%5d %-35s %s", ((ISubmission)iElementObject).getElapsedMins(), accountName, problem.getDisplayName());
                printWriter.println();
            }
            catch (Exception e) {
                printWriter.println("Run " + iElementObject + " Exception " + e.getMessage());
                e.printStackTrace(printWriter);
            }
        }
        printWriter.println("  --- ----------------------------------- ------------------");
        printWriter.println();
        printWriter.println();
        printWriter.println(" ** Summarized by problem");
        printWriter.println();
        printWriter.println("   At Problem                             Team");
        printWriter.println("  --- ----------------------------------- ---------------------------------");
        Vector<Problem> unsolvedProblems = new Vector<Problem>();
        Problem[] arr$ = problems;
        int len$ = arr$.length;
        boolean bl = false;
        while (var11_21 < len$) {
            Problem problem = arr$[var11_21];
            boolean foundRun = false;
            String hiddenText = "";
            if (!problem.isActive()) {
                hiddenText = " [HIDDEN] ";
            }
            for (Run run : runs) {
                try {
                    if (!run.getProblemId().equals(problem.getElementId())) continue;
                    Account account = this.contest.getAccount(run.getSubmitter());
                    String accountName = run.getSubmitter().getName() + " (site " + run.getSiteNumber() + ")";
                    if (account != null) {
                        accountName = account.getDisplayName();
                    }
                    printWriter.format("%5d %-35s %s", run.getElapsedMins(), hiddenText + problem.getDisplayName(), accountName);
                    printWriter.println();
                    foundRun = true;
                }
                catch (Exception e) {
                    printWriter.println("Run " + run + " Exception " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
            }
            if (!foundRun) {
                printWriter.format("      %-35s %s", hiddenText + problem.getDisplayName(), "(Not Solved)");
                printWriter.println();
                unsolvedProblems.add(problem);
            }
            ++var11_21;
        }
        printWriter.println("  --- ----------------------------------- ---------------------------------");
        printWriter.println();
        int notsolved = problems.length - solved;
        if (notsolved > 0) {
            Problem[] problemList;
            printWriter.println("  ** " + notsolved + " problems were not solved");
            for (Problem problem : problemList = unsolvedProblems.toArray(new Problem[unsolvedProblems.size()])) {
                String hiddenText = "";
                if (!problem.isActive()) {
                    hiddenText = " [HIDDEN] ";
                }
                printWriter.println("     " + hiddenText + problem.getDisplayName());
            }
            printWriter.println();
        }
        if (problems.length == solved) {
            printWriter.println("ALL problems solved");
        } else if (solved == 0) {
            printWriter.println("NO problems solved");
        } else {
            printWriter.println("There were " + solved + " of " + problems.length + " problems solved.");
        }
    }

    private Run[] filterForProblem(Run[] runs, Problem problem) {
        Vector<Run> runVector = new Vector<Run>();
        for (Run run : runs) {
            if (!run.getProblemId().equals(problem.getElementId())) continue;
            runVector.addElement(run);
        }
        return runVector.toArray(new Run[runVector.size()]);
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Fastest Solutions Summary";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Fastest Solutions Summary Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

