/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunCompartorByElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class FastestSolvedReport
implements IReport {
    private static final long serialVersionUID = 3878379207856922664L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        Problem[] problems = this.contest.getProblems();
        if (problems == null || problems.length == 0) {
            printWriter.println("No problems defined, no summary");
            return;
        }
        int numDeleted = 0;
        for (Problem problem : problems) {
            Run[] runList = this.filterForProblem(runs, problem);
            Arrays.sort(runList, new RunCompartorByElapsed());
            printWriter.println("Problem " + problem);
            printWriter.println();
            printWriter.println("Rank Elap Run# Team");
            int numberSolved = 0;
            int rank = 0;
            int tieRank = 0;
            long lastElapsed = -1L;
            for (Run run : runList) {
                if (!run.isDeleted() && run.isSolved() && this.filter.matches(run)) {
                    ++numberSolved;
                    long elapsed = run.getElapsedMins();
                    String teamName = run.getSubmitter().toString();
                    Account account = this.contest.getAccount(run.getSubmitter());
                    if (account != null) {
                        teamName = account.getDisplayName();
                    }
                    teamName = teamName + " (Site " + run.getSubmitter().getSiteNumber() + ")";
                    if (elapsed != lastElapsed) {
                        tieRank = ++rank;
                        printWriter.format(" %3d %4d %4d ", tieRank, elapsed, run.getNumber());
                        printWriter.println(teamName);
                        lastElapsed = elapsed;
                        continue;
                    }
                    ++rank;
                    printWriter.format(" %3d %4d %4d ", tieRank, elapsed, run.getNumber());
                    printWriter.println(teamName);
                    continue;
                }
                if (!run.isDeleted() || !this.filter.matches(run)) continue;
                ++numDeleted;
            }
            printWriter.println();
            if (numberSolved > 0) {
                printWriter.println("There are " + numberSolved + " runs solving " + problem);
            } else {
                printWriter.println("No solutions for problem " + problem);
            }
            printWriter.println();
        }
        if (numDeleted > 0) {
            printWriter.println("There are " + numDeleted + " runs marked deleted");
        }
    }

    private Run[] filterForProblem(Run[] runs, Problem problem) {
        Vector<Run> runVector = new Vector<Run>();
        for (Run run : runs) {
            if (!run.getProblemId().equals(problem.getElementId())) continue;
            runVector.addElement(run);
        }
        return runVector.toArray(new Run[runVector.size()]);
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Fastest Solutions Per Problem";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Fastest Solutions Per Problem Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

