/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.PlaybackEvent;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class ExtractPlaybackLoadFilesReport
implements IReport {
    private static final long serialVersionUID = 977130815676827828L;
    private static final String DELIMITER = "|";
    private IInternalContest contest;
    private IInternalController controller;
    private String extractDirectory;
    private String reportFilename;
    private Log log;
    private Filter filter;
    private String reportDirectory = "reports";
    private String universalFileSeparator = "/";

    private void writeRow(PrintWriter printWriter, Run run) throws Exception {
        JudgementRecord[] records;
        RunFiles runFiles = this.contest.getRunFiles(run);
        SerializedFile mainfile = runFiles.getMainFile();
        String mainFileName = mainfile.getName();
        String targetDirectory = this.extractDirectory + this.universalFileSeparator + "site" + run.getSiteNumber() + "run" + run.getNumber();
        if (!new File(targetDirectory).isDirectory()) {
            new File(targetDirectory).mkdirs();
        }
        String outputFileName = targetDirectory + this.universalFileSeparator + mainFileName;
        mainfile.writeFile(outputFileName);
        outputFileName = this.removeUpTo(targetDirectory, File.separator).substring(1) + this.universalFileSeparator + mainFileName;
        this.writeValues(printWriter, "action", PlaybackEvent.Action.RUN_SUBMIT.toString());
        this.writeValues(printWriter, "id", run.getNumber());
        this.writeValues(printWriter, "elapsed", run.getElapsedMins());
        this.writeValues(printWriter, "language", this.contest.getLanguage(run.getLanguageId()).getDisplayName());
        this.writeValues(printWriter, "problem", this.contest.getProblem(run.getProblemId()).getDisplayName());
        this.writeValues(printWriter, "site", run.getSiteNumber());
        this.writeValues(printWriter, "submitclient", run.getSubmitter().getName());
        this.writeValues(printWriter, "mainfile", outputFileName);
        printWriter.println();
        for (JudgementRecord judgementRecord : records = run.getAllJudgementRecords()) {
            this.writeJudgementRecord(printWriter, run, judgementRecord);
        }
    }

    private void writeJudgementRecord(PrintWriter printWriter, Run run, JudgementRecord judgementRecord) {
        this.writeValues(printWriter, "action", PlaybackEvent.Action.RUN_JUDGEMENT.toString());
        this.writeValues(printWriter, "id", run.getNumber());
        this.writeValues(printWriter, "site", run.getSiteNumber());
        this.writeValues(printWriter, "solved", judgementRecord.isSolved());
        this.writeValues(printWriter, "preliminary", judgementRecord.isPreliminaryJudgement());
        this.writeValues(printWriter, "judgeclient", judgementRecord.getJudgerClientId().getName());
        this.writeValues(printWriter, "judgeclientsite", judgementRecord.getJudgerClientId().getSiteNumber());
        this.writeValues(printWriter, "judged_elapsed_time", judgementRecord.getWhenJudgedTime());
        this.writeValues(printWriter, "computer_judged", judgementRecord.isComputerJudgement());
        this.writeValues(printWriter, "judgement", this.contest.getJudgement(judgementRecord.getJudgementId()).getDisplayName());
        this.writeValues(printWriter, "senttoteams", judgementRecord.isSendToTeam());
        printWriter.println();
    }

    private void writeValues(PrintWriter printWriter, String key, long number) {
        printWriter.print(key + "=" + number + DELIMITER + " ");
    }

    private void writeValues(PrintWriter printWriter, String key, String value) {
        printWriter.print(key + "=" + value + DELIMITER + " ");
    }

    private void writeValues(PrintWriter printWriter, String key, boolean value) {
        printWriter.print(key + "=" + value + DELIMITER + " ");
    }

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        if (this.reportFilename == null) {
            throw new IllegalArgumentException("reportFilename is null");
        }
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        printWriter.println("# ------------------------------------------------------------");
        printWriter.println();
        printWriter.println("# " + this.getReportTitle());
        printWriter.println("# Created on " + new Date());
        printWriter.println("# Created by: " + new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        Vector<String> failedRunExtract = new Vector<String>();
        this.extractDirectory = this.removeUpTo(this.reportFilename, this.reportDirectory + File.separator) + ".files";
        int nonExtractedRuns = 0;
        for (Run run : runs) {
            try {
                this.writeRow(printWriter, run);
            }
            catch (Exception e) {
                failedRunExtract.add("Failed run: " + run);
                ++nonExtractedRuns;
                printWriter.println("# error extracting run " + run + " " + e.getMessage());
            }
        }
        String[] list = failedRunExtract.toArray(new String[failedRunExtract.size()]);
        printWriter.println();
        if (nonExtractedRuns > 0) {
            printWriter.println("# " + nonExtractedRuns + " extracting runs NOT extracted");
            for (String s : list) {
                printWriter.println("# " + s);
            }
        } else {
            printWriter.println("# All " + list.length + " runs extracted");
        }
        printWriter.println();
        printWriter.println("# EOF " + this.getReportTitle());
        printWriter.println("# ------------------------------------------------------------");
    }

    protected String removeUpTo(String source, String targetString) {
        int index = source.indexOf(targetString);
        if (index > 0) {
            String debug2 = source.substring(index);
            return debug2;
        }
        return source;
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println("# " + this.getReportTitle() + " Report");
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("# end ");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        this.reportFilename = filename;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.reportFilename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Extract Replay Runs";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Extract Replay Runs";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setReportFilename(String reportFilename) {
        this.reportFilename = reportFilename;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }
}

