/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.XMLUtilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.BalloonDeliveryComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.GroupComparator;
import edu.csus.ecs.pc2.core.list.ProblemComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class EventFeedXML {
    public static final String CONTEST_TAG = "contest";
    public static final String INFO_TAG = "info";
    public static final String REGION_TAG = "region";
    public static final String PROBLEM_TAG = "problem";
    public static final String LANGUAGE_TAG = "language";
    public static final String TEAM_TAG = "team";
    public static final String CLARIFICATION_TAG = "clarification";
    public static final String RUN_TAG = "run";
    public static final String JUDGEMENT_TAG = "judgement";
    public static final String FINALIZE_TAG = "finalize";
    public static final String JUDGEMENT_RECORD_TAG = "judgement_record";
    public static final String BALLOON_TAG = "balloon";
    public static final String BALLOON_LIST_TAG = "balloons";
    public static final String NOTIFICATION_TAG = "notification";
    private RunComparator runComparator = new RunComparator();

    public String toXML(IInternalContest contest) throws IOException {
        return this.toXML(contest, new Filter());
    }

    public String toXML(IInternalContest contest, Filter filter) throws IOException {
        Problem[] problems;
        Judgement[] judgements;
        XMLMemento mementoRoot = XMLMemento.createWriteRoot(CONTEST_TAG);
        IMemento memento = mementoRoot.createChild(INFO_TAG);
        this.addInfoMemento(memento, contest, filter);
        Group[] groups = contest.getGroups();
        Arrays.sort(groups, new GroupComparator());
        for (Group group : groups) {
            memento = mementoRoot.createChild(REGION_TAG);
            this.addMemento(memento, contest, group);
        }
        for (Judgement judgement : judgements = contest.getJudgements()) {
            memento = mementoRoot.createChild(JUDGEMENT_TAG);
            this.addMemento(memento, contest, judgement);
        }
        Language[] languages = contest.getLanguages();
        int num = 1;
        for (Language language : languages) {
            if (filter.matches(language)) {
                memento = mementoRoot.createChild(LANGUAGE_TAG);
                this.addMemento(memento, contest, language, num);
            }
            ++num;
        }
        num = 1;
        for (Problem problem : problems = contest.getProblems()) {
            if (filter.matches(problem)) {
                memento = mementoRoot.createChild(PROBLEM_TAG);
                this.addMemento(memento, contest, problem, num);
            }
            ++num;
        }
        Vector<Account> teams = contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = teams.toArray(new Account[teams.size()]);
        Arrays.sort(accounts, new AccountComparator());
        for (Account account : accounts) {
            if (!filter.matches(account)) continue;
            memento = mementoRoot.createChild(TEAM_TAG);
            this.addMemento(memento, contest, account);
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        for (Run run : runs) {
            if (!filter.matches(run)) continue;
            memento = mementoRoot.createChild(RUN_TAG);
            this.addMemento(memento, contest, run);
        }
        Clarification[] clarifications = contest.getClarifications();
        Arrays.sort(clarifications, new ClarificationComparator());
        for (Clarification clarification : clarifications) {
            if (!filter.matches(clarification)) continue;
            memento = mementoRoot.createChild(CLARIFICATION_TAG);
            this.addMemento(memento, contest, clarification);
        }
        BalloonDeliveryInfo[] deliveries = this.getBalloonDeliveries(contest);
        Arrays.sort(deliveries, new BalloonDeliveryComparator(contest));
        int notificationSequenceNumber = 1;
        for (BalloonDeliveryInfo balloonDeliveryInfo : deliveries) {
            Run run = this.getFirstSolvedRun(contest, balloonDeliveryInfo.getClientId(), balloonDeliveryInfo.getProblemId());
            memento = mementoRoot.createChild(NOTIFICATION_TAG);
            this.addMemento(memento, contest, run, notificationSequenceNumber);
            ++notificationSequenceNumber;
        }
        return mementoRoot.saveToString();
    }

    public Run getFirstSolvedRun(IInternalContest contest, ClientId clientId, ElementId problemId) {
        Filter filter = new Filter();
        filter.addAccount(clientId);
        filter.addProblem(contest.getProblem(problemId));
        Run[] runs = filter.getRuns(contest.getRuns());
        Arrays.sort(runs, this.runComparator);
        if (runs.length > 0) {
            return runs[0];
        }
        return null;
    }

    public BalloonDeliveryInfo[] getBalloonDeliveries(IInternalContest contest) {
        BalloonDeliveryInfo[] deliveries = new BalloonDeliveryInfo[]{};
        BalloonSettings balloonSettings = contest.getBalloonSettings(contest.getSiteNumber());
        if (balloonSettings == null) {
            return deliveries;
        }
        ClientSettings settings = new ClientSettings(balloonSettings.getBalloonClient());
        Hashtable<String, BalloonDeliveryInfo> deliveryHash = settings.getBalloonList();
        ArrayList<BalloonDeliveryInfo> balloonDeliveryArray = Collections.list(deliveryHash.elements());
        BalloonDeliveryInfo[] balloonDeliveryInfos = balloonDeliveryArray.toArray(new BalloonDeliveryInfo[balloonDeliveryArray.size()]);
        return balloonDeliveryInfos;
    }

    public XMLMemento createInfoElement(IInternalContest contest, Filter filter) throws IOException {
        XMLMemento memento = XMLMemento.createWriteRoot(INFO_TAG);
        this.addInfoMemento(memento, contest, filter);
        return memento;
    }

    public IMemento addInfoMemento(IMemento memento, IInternalContest contest, Filter filter) throws IOException {
        ContestTime time = contest.getContestTime();
        XMLUtilities.addChild(memento, "title", contest.getContestInformation().getContestTitle());
        String contestLengthString = "0:0:0";
        boolean running = false;
        String formattedSeconds = "0.0";
        if (time != null) {
            contestLengthString = time.getContestLengthStr();
            running = time.isContestRunning();
            if (time.getContestStartTime() != null) {
                formattedSeconds = XMLUtilities.formatSeconds(time.getContestStartTime().getTimeInMillis());
            }
        }
        XMLUtilities.addChild(memento, "length", contestLengthString);
        XMLUtilities.addChild(memento, "penalty", DefaultScoringAlgorithm.getDefaultProperties().getProperty("Points per No"));
        XMLUtilities.addChild(memento, "started", running);
        XMLUtilities.addChild(memento, "starttime", formattedSeconds);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Filter filter) throws IOException {
        XMLMemento memento = XMLMemento.createWriteRoot(LANGUAGE_TAG);
        this.addInfoMemento(memento, contest, filter);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Language language, int id) {
        XMLMemento memento = XMLMemento.createWriteRoot(LANGUAGE_TAG);
        this.addMemento((IMemento)memento, contest, language, id);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Language language, int id) {
        memento.putInteger("id", id);
        XMLUtilities.addChild(memento, "name", language.toString());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Problem problem, int id) {
        XMLMemento memento = XMLMemento.createWriteRoot(PROBLEM_TAG);
        this.addMemento((IMemento)memento, contest, problem, id);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Problem problem, int id) {
        memento.putInteger("id", id);
        memento.putBoolean("enabled", problem.isActive());
        String problemLetter = this.getProblemLetter(id);
        memento.createChildNode("label", problemLetter);
        memento.createChildNode("name", problem.toString());
        BalloonSettings settings = contest.getBalloonSettings(contest.getSiteNumber());
        String color = settings.getColor(problem);
        IMemento balloonColor = memento.createChildNode("balloon-color", color);
        balloonColor.putString("rgb", settings.getColorRGB(problem));
        return memento;
    }

    protected String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    public boolean isValidJudgement(Run run, boolean sendNotificationsForPreliminary) {
        boolean result = false;
        if (run.getStatus().equals((Object)Run.RunStates.JUDGED)) {
            result = true;
        } else if (run.isJudged()) {
            if (run.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                if (sendNotificationsForPreliminary) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public boolean isValidRun(IInternalContest contest, Run run) {
        ContestInformation contestInformation = contest.getContestInformation();
        boolean sendNotification = contestInformation.isPreliminaryJudgementsTriggerNotifications();
        if (run.isJudged() && run.isSolved() && !run.isDeleted() && this.isValidJudgement(run, sendNotification)) {
            return run.isSendToTeams() || !contest.isAllowed(Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        }
        return false;
    }

    protected Problem[] getSolvedRuns(IInternalContest contest, ClientId id) {
        Filter filter = new Filter();
        filter.addAccount(id);
        Run[] runs = filter.getRuns(contest.getRuns());
        Vector<Problem> probVector = new Vector<Problem>();
        for (int i = 0; i < runs.length; ++i) {
            Run run = runs[i];
            Problem problem = contest.getProblem(run.getProblemId());
            if (!this.isValidRun(contest, run) || probVector.contains(problem)) continue;
            probVector.add(problem);
        }
        Problem[] problems = probVector.toArray(new Problem[probVector.size()]);
        Arrays.sort(problems, new ProblemComparator(contest));
        return problems;
    }

    public IMemento addBalloonMemento(IMemento memento, IInternalContest contest, Problem problem) {
        int problemIndex = this.getProblemIndex(contest, problem);
        memento.putInteger("problem-id", problemIndex);
        XMLUtilities.addChild(memento, "label", this.getProblemLetter(problemIndex));
        XMLUtilities.addChild(memento, "name", contest.getProblem(problem.getElementId()).getDisplayName());
        IMemento colorMemento = XMLUtilities.addChild(memento, "color", this.getProblemBalloonColor(contest, problem));
        colorMemento.putString("rgb", this.getProblemRGB(contest, problem));
        return memento;
    }

    private String getProblemRGB(IInternalContest contest, Problem problem) {
        BalloonSettings settings = contest.getBalloonSettings(contest.getSiteNumber());
        return settings.getColorRGB(problem);
    }

    private String getProblemBalloonColor(IInternalContest contest, Problem problem) {
        BalloonSettings settings = contest.getBalloonSettings(contest.getSiteNumber());
        return settings.getColor(problem);
    }

    public XMLMemento createBalloonElement(IInternalContest contest, Problem problem) {
        XMLMemento memento = XMLMemento.createWriteRoot(BALLOON_TAG);
        this.addBalloonMemento(memento, contest, problem);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Run run, int notificationSequenceNumber) {
        ClientId clientId = run.getSubmitter();
        memento.putInteger("id", notificationSequenceNumber);
        memento.putInteger("team-id", clientId.getClientNumber());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(run.getElapsedMins() * 1000L));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        XMLUtilities.addChild(memento, TEAM_TAG, contest.getAccount(clientId).getDisplayName());
        Problem[] problems = this.getSolvedRuns(contest, clientId);
        boolean firstSolvedByteam = problems.length == 1;
        XMLUtilities.addChild(memento, "first-by-team", firstSolvedByteam);
        Problem solvedProblem = contest.getProblem(run.getProblemId());
        IMemento singleBalloon = memento.createChild(BALLOON_TAG);
        this.addBalloonMemento(singleBalloon, contest, solvedProblem);
        IMemento balloonsRoot = memento.createChild(BALLOON_LIST_TAG);
        for (Problem problem : problems) {
            memento = balloonsRoot.createChild(BALLOON_TAG);
            this.addBalloonMemento(memento, contest, problem);
        }
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Account account) {
        XMLMemento memento = XMLMemento.createWriteRoot(TEAM_TAG);
        this.addMemento((IMemento)memento, contest, account);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Account account) {
        memento.putInteger("id", account.getClientId().getClientNumber());
        memento.putString("external-id", account.getExternalId());
        XMLUtilities.addChild(memento, "name", account.getDisplayName());
        XMLUtilities.addChild(memento, "nationality", account.getCountryCode());
        XMLUtilities.addChild(memento, "university", account.getLongSchoolName());
        String regionName = "";
        if (account.getGroupId() != null) {
            Group group = contest.getGroup(account.getGroupId());
            regionName = group.getDisplayName();
        }
        XMLUtilities.addChild(memento, REGION_TAG, regionName);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Clarification clarification) {
        XMLMemento memento = XMLMemento.createWriteRoot(CLARIFICATION_TAG);
        this.addMemento((IMemento)memento, contest, clarification);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Clarification clarification) {
        memento.putInteger("id", clarification.getNumber());
        memento.putInteger("team-id", clarification.getNumber());
        Problem problem = contest.getProblem(clarification.getProblemId());
        memento.putInteger("problem-id", this.getProblemIndex(contest, problem));
        String answer = clarification.getAnswer();
        if (answer == null) {
            answer = "";
        }
        XMLUtilities.addChild(memento, "answer", answer);
        XMLUtilities.addChild(memento, "question", clarification.getQuestion());
        XMLUtilities.addChild(memento, "to-all", clarification.isSendToAll());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(clarification.getElapsedMins() * 1000L));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    private int getProblemIndex(IInternalContest contest, Problem inProblem) {
        int idx = 0;
        for (Problem problem : contest.getProblems()) {
            if (problem.getElementId().equals(inProblem.getElementId())) {
                return idx + 1;
            }
            ++idx;
        }
        return -1;
    }

    public XMLMemento createElement(IInternalContest contest, Run run) {
        XMLMemento memento = XMLMemento.createWriteRoot(RUN_TAG);
        this.addMemento((IMemento)memento, contest, run);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Run run) {
        memento.putInteger("id", run.getNumber());
        memento.putInteger("team-id", run.getSubmitter().getClientNumber());
        Problem problem = contest.getProblem(run.getProblemId());
        int problemIndex = this.getProblemIndex(contest, problem);
        memento.putInteger("problem-id", problemIndex);
        XMLUtilities.addChild(memento, "judged", run.isJudged());
        Language language = contest.getLanguage(run.getLanguageId());
        XMLUtilities.addChild(memento, LANGUAGE_TAG, language.getDisplayName());
        XMLUtilities.addChild(memento, "penalty", "TODO");
        String judgement = contest.getJudgement(run.getJudgementRecord().getJudgementId()).getAcronym();
        XMLUtilities.addChild(memento, JUDGEMENT_TAG, judgement.toUpperCase().substring(0, 2));
        XMLUtilities.addChild(memento, TEAM_TAG, run.getSubmitter().getClientNumber());
        XMLUtilities.addChild(memento, "elapsed-Mins", run.getElapsedMins());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    private String toXML(XMLMemento mementoRoot) throws IOException {
        return mementoRoot.saveToString(true);
    }

    /*
     * WARNING - void declaration
     */
    public String createStartupXML(IInternalContest contest) {
        void var7_16;
        Clarification[] clarifications;
        StringBuffer sb = new StringBuffer("<contest>");
        try {
            sb.append(this.toXML(this.createInfoElement(contest, null)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int idx = 1;
        for (Language language : contest.getLanguages()) {
            try {
                sb.append(this.toXML(this.createElement(contest, language, idx)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++idx;
        }
        idx = 0;
        for (IElementObject iElementObject : contest.getProblems()) {
            try {
                sb.append(this.toXML(this.createElement(contest, (Problem)iElementObject, idx)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++idx;
        }
        for (IElementObject iElementObject : contest.getJudgements()) {
            try {
                sb.append(this.toXML(this.createElement(contest, (Judgement)iElementObject)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Clarification[] arr$ = clarifications = contest.getClarifications();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_16 < len$) {
            Clarification clarification = arr$[var7_16];
            try {
                sb.append(this.toXML(this.createElement(contest, clarification)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++var7_16;
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        for (Run run : runs) {
            try {
                sb.append(this.toXML(this.createElement(contest, run)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String createFinalizeXML(IInternalContest contest) {
        StringBuffer sb = new StringBuffer();
        XMLMemento memento = XMLMemento.createWriteRoot(FINALIZE_TAG);
        FinalizeData finalData = this.createSampFinalData();
        this.addMemento(memento, contest, finalData);
        try {
            sb.append(this.toXML(memento));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sb.append("</");
        sb.append(CONTEST_TAG);
        sb.append(">");
        return sb.toString();
    }

    private FinalizeData createSampFinalData() {
        FinalizeData data = new FinalizeData();
        int rank = 1;
        data.setGoldRank(rank += 8);
        data.setSilverRank(rank += 5);
        data.setBronzeRank(rank += 10);
        data.setComment("Finalized by Director of Operations");
        return data;
    }

    private void addMemento(XMLMemento memento, IInternalContest contest, FinalizeData data) {
        XMLUtilities.addChild((IMemento)memento, "last-gold", data.getGoldRank());
        XMLUtilities.addChild((IMemento)memento, "last-silver", data.getSilverRank());
        XMLUtilities.addChild((IMemento)memento, "last-bronze", data.getBronzeRank());
        XMLUtilities.addChild((IMemento)memento, "comment", data.getComment());
        XMLUtilities.addChild((IMemento)memento, "timestamp", XMLUtilities.getTimeStamp());
    }

    public XMLMemento createElement(IInternalContest contest, Group group) {
        XMLMemento memento = XMLMemento.createWriteRoot(REGION_TAG);
        this.addMemento((IMemento)memento, contest, group);
        return memento;
    }

    public void addMemento(IMemento memento, IInternalContest contest, Group group) {
        memento.putInteger("id", group.getGroupId());
        XMLUtilities.addChild(memento, "name", group.getDisplayName());
    }

    public XMLMemento createElement(IInternalContest contest, Judgement judgement) {
        XMLMemento memento = XMLMemento.createWriteRoot(JUDGEMENT_TAG);
        this.addMemento((IMemento)memento, contest, judgement);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Judgement judgement) {
        String name = judgement.getDisplayName();
        XMLUtilities.addChild(memento, "acronym", judgement.getAcronym());
        XMLUtilities.addChild(memento, "name", name);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, JudgementRecord judgementRecord) {
        XMLMemento memento = XMLMemento.createWriteRoot(JUDGEMENT_RECORD_TAG);
        Judgement judgement = contest.getJudgement(judgementRecord.getJudgementId());
        XMLUtilities.addChild((IMemento)memento, "acronym", judgement.getAcronym());
        XMLUtilities.addChild((IMemento)memento, "name", judgement.getDisplayName());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, BalloonDeliveryInfo balloonDeliveryInfo, int notificationSequenceNumber) {
        XMLMemento memento = XMLMemento.createWriteRoot(NOTIFICATION_TAG);
        Run run = this.getFirstSolvedRun(contest, balloonDeliveryInfo.getClientId(), balloonDeliveryInfo.getProblemId());
        this.addMemento((IMemento)memento, contest, run, notificationSequenceNumber);
        return memento;
    }
}

