/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class ContestSettingsReport
implements IReport {
    private static final long serialVersionUID = 8596231586054536246L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void printContestInformation(PrintWriter printWriter) {
        ContestInformation contestInformation = this.contest.getContestInformation();
        printWriter.println();
        printWriter.println("-- Contest Information --");
        printWriter.println("  Title : '" + contestInformation.getContestTitle() + "'");
        printWriter.println("  URL   : '" + contestInformation.getContestURL() + "'");
        printWriter.println();
        printWriter.println("  Include Preliminary Judgements in Scoring Algorithm : " + Utilities.yesNoString(contestInformation.isPreliminaryJudgementsUsedByBoard()));
        printWriter.println("  Send Notifications for Preliminary Judgements       : " + Utilities.yesNoString(contestInformation.isPreliminaryJudgementsTriggerNotifications()));
        printWriter.println("  Send Additional Run Status Information              : " + Utilities.yesNoString(contestInformation.isSendAdditionalRunStatusInformation()));
        printWriter.println();
        printWriter.println("  Judges' Default Answer: '" + contestInformation.getJudgesDefaultAnswer() + "'");
        if (contestInformation.getTeamDisplayMode() != null) {
            printWriter.println("  Judges see: " + (Object)((Object)contestInformation.getTeamDisplayMode()));
        } else {
            printWriter.println("  Judges see: " + (Object)((Object)ContestInformation.TeamDisplayMask.LOGIN_NAME_ONLY));
        }
        printWriter.println();
        Properties properties = contestInformation.getScoringProperties();
        if (properties == null || properties.isEmpty()) {
            printWriter.println("  Note: Scoring Properties are null, using default");
            properties = DefaultScoringAlgorithm.getDefaultProperties();
        }
        Set<Object> set = properties.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        printWriter.println("  Scoring Properties, there are " + keys.length + " keys");
        for (Object key : keys) {
            printWriter.println("     " + (String)key + "='" + properties.get(key) + "'");
        }
    }

    public void writeReport(PrintWriter printWriter) {
        this.printContestInformation(printWriter);
    }

    public void printHeader(PrintWriter printWriter) {
        VersionInfo versionInfo = new VersionInfo();
        printWriter.println(versionInfo.getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(versionInfo.getSystemVersionInfo());
        printWriter.println("Build " + versionInfo.getBuildNumber());
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        if (inFilter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        this.filter = inFilter;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
        printWriter.close();
        printWriter = null;
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Contest Settings";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Contest Settings Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int countClientSettings(ClientSettings[] clientSettings) {
        int count = 0;
        for (ClientSettings clientSettings2 : clientSettings) {
            if (!this.filter.matches(clientSettings2.getClientId())) continue;
            ++count;
        }
        return count;
    }
}

