/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunCompartorByTeamProblemElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class ContestAnalysisReport
implements IReport {
    private static final long serialVersionUID = 8827529273455158045L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) throws IOException {
        printWriter.println();
        printWriter.println("Contest Title: " + this.contest.getContestInformation().getContestTitle());
        printWriter.println();
        printWriter.println(this.contest.getSites().length + " sites.");
        this.printRunsClarsBySite(printWriter);
    }

    protected void printRunsFromDisabledTeams(PrintWriter printWriter) {
        printWriter.println("Runs submitted by Teams not shown on scoreboard/standings");
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunCompartorByTeamProblemElapsed());
        for (Run run : runs) {
            ClientId clientId;
            if (!this.filter.matches(run) || this.contest.getAccount(clientId = run.getSubmitter()).isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD)) continue;
            printWriter.format("#%3d %3d %-10.10s ", run.getNumber(), run.getElapsedMins(), this.getJudgementName(run));
            printWriter.print(clientId + " '" + this.contest.getAccount(clientId).getDisplayName() + "'");
            printWriter.println();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void printRunsClarsBySite(PrintWriter printWriter) {
        void var15_20;
        int siteNum;
        int numSites = this.contest.getSites().length;
        int[] numRuns = new int[numSites];
        int[] numRunsDeleted = new int[numSites];
        int[] numClars = new int[numSites];
        int[] numClarsDeleted = new int[numSites];
        int[] numClarsForAll = new int[numSites];
        int[] numUnjudgedRuns = new int[numSites];
        int totalUnjudgedRuns = 0;
        int[] numClarsUnAnswered = new int[numSites];
        int totalUnanswered = 0;
        for (Run run : this.contest.getRuns()) {
            if (!this.filter.matches(run)) continue;
            int n = siteNum = run.getSiteNumber() - 1;
            numRuns[n] = numRuns[n] + 1;
            if (run.isDeleted()) {
                int n2 = siteNum;
                numRunsDeleted[n2] = numRunsDeleted[n2] + 1;
            }
            if (run.isJudged()) continue;
            int n3 = siteNum;
            numUnjudgedRuns[n3] = numUnjudgedRuns[n3] + 1;
            ++totalUnjudgedRuns;
        }
        for (ISubmission iSubmission : this.contest.getClarifications()) {
            if (!this.filter.matches((Clarification)iSubmission)) continue;
            int n = siteNum = iSubmission.getSiteNumber() - 1;
            numClars[n] = numClars[n] + 1;
            if (((Clarification)iSubmission).isSendToAll()) {
                int n4 = siteNum;
                numClarsForAll[n4] = numClarsForAll[n4] + 1;
            }
            if (!((Clarification)iSubmission).isAnswered()) {
                int n5 = siteNum;
                numClarsUnAnswered[n5] = numClarsUnAnswered[n5] + 1;
                ++totalUnanswered;
            }
            if (!((Clarification)iSubmission).isDeleted()) continue;
            int n6 = siteNum;
            numClarsDeleted[n6] = numClarsDeleted[n6] + 1;
        }
        int totalRunsDeleted = 0;
        int totalClars = 0;
        int totalRuns = 0;
        boolean bl = false;
        int totalClarsToAll = 0;
        for (int i = 0; i < numSites; ++i) {
            int siteNum2 = i + 1;
            if (!this.filter.matches(this.contest.getSite(siteNum2))) continue;
            printWriter.format("%2d %-15s ", siteNum2, this.contest.getSite(siteNum2).getDisplayName());
            printWriter.format("%4d runs (%2d unjudged, %2d deleted)", numRuns[i], numUnjudgedRuns[i], numRunsDeleted[i]);
            printWriter.format("%4d clars, %d to All (%2d unanswered, %2d deleted)", numClars[i], numClarsForAll[i], numClarsUnAnswered[i], numClarsDeleted[i]);
            totalRunsDeleted += numRunsDeleted[i];
            totalClars += numClars[i];
            totalRuns += numRuns[i];
            var15_20 += numClarsDeleted[i];
            totalClarsToAll += numClarsForAll[i];
            printWriter.println();
        }
        printWriter.format("   %-15s ", "Total");
        printWriter.format("%4d runs (%2d unjudged, %2d deleted)", totalRuns, totalUnjudgedRuns, totalRunsDeleted);
        printWriter.format("%4d clars, %d to All (%2d unanswered, %2d deleted)", totalClars, totalClarsToAll, totalUnanswered, (int)var15_20);
        printWriter.println();
        printWriter.println();
        if (totalUnanswered == 0) {
            printWriter.println("There are NO unanswered clars");
        } else {
            printWriter.println("Note: " + totalUnanswered + " unanswered clars");
        }
        if (totalUnjudgedRuns == 0) {
            printWriter.println("There are NO unjudged runs");
        } else {
            printWriter.println("Note: " + totalUnjudgedRuns + " unjudged runs");
        }
        printWriter.println();
        printWriter.println("Runs after first Yes ");
        Run solvedRun = null;
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunCompartorByTeamProblemElapsed());
        ElementId lastProblemId = null;
        ClientId lastClientId = null;
        int numYesAfterYes = 0;
        int numNoAfterYes = 0;
        for (Run run : runs) {
            if (!this.filter.matches(run) || run.isDeleted()) continue;
            if (lastClientId == null) {
                lastProblemId = run.getProblemId();
                lastClientId = run.getSubmitter();
                if (!run.isSolved()) continue;
                solvedRun = run;
                continue;
            }
            if (lastClientId.equals(run.getSubmitter()) && run.getProblemId().equals(lastProblemId) && solvedRun != null) {
                if (run.isSolved()) {
                    ++numYesAfterYes;
                } else {
                    ++numNoAfterYes;
                }
                printWriter.print("Found   ");
                printWriter.format("#%3d %3d %-10.10s ", run.getNumber(), run.getElapsedMins(), this.getJudgementName(run));
                printWriter.print(lastClientId + " '" + this.contest.getAccount(lastClientId).getDisplayName() + "'");
                printWriter.println();
                printWriter.print("  After ");
                printWriter.format("#%3d %3d %-10.10s ", solvedRun.getNumber(), solvedRun.getElapsedMins(), this.getJudgementName(solvedRun));
                printWriter.print(this.contest.getProblem(run.getProblemId()));
                printWriter.println();
                printWriter.println();
            }
            solvedRun = run.isSolved() ? run : null;
            lastProblemId = run.getProblemId();
            lastClientId = run.getSubmitter();
        }
        if (numYesAfterYes > 0) {
            printWriter.println("Total Yes judgements after earlier Yes judgement: " + numYesAfterYes);
        } else {
            printWriter.println("There are NO 'Yes' judgements after earlier Yes judgements");
        }
        if (numNoAfterYes > 0) {
            printWriter.println("Total No judgements after earlier Yes judgement: " + numNoAfterYes);
        } else {
            printWriter.println("There are NO 'No' judgements after earlier Yes judgements");
        }
        printWriter.println();
        this.printRunsFromDisabledTeams(printWriter);
        printWriter.println();
    }

    private String getJudgementName(Run run) {
        if (run.isJudged()) {
            JudgementRecord judgementRecord = run.getJudgementRecord();
            if (judgementRecord != null) {
                ElementId judgementId = judgementRecord.getJudgementId();
                Judgement judgement = this.contest.getJudgement(judgementId);
                return judgement.toString();
            }
            if (run.isSolved()) {
                return "yes";
            }
            return "no";
        }
        return run.getStatus().toString();
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Contest Analysis";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Contest Analysis Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

