/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.BalloonSettingsComparatorbySite;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class BalloonSettingsReport
implements IReport {
    private static final long serialVersionUID = -3705067685117724687L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        BalloonSettings[] balloonSettings = this.contest.getBalloonSettings();
        Problem[] problems = this.contest.getProblems();
        Arrays.sort(balloonSettings, new BalloonSettingsComparatorbySite());
        printWriter.println("-- " + balloonSettings.length + " BalloonSettings--");
        for (BalloonSettings balloonSetting : balloonSettings) {
            try {
                printWriter.println("Site '" + balloonSetting.getSiteNumber() + "' id=" + balloonSetting.getElementId());
                printWriter.println("      Balloon Client     : " + balloonSetting.getBalloonClient());
                printWriter.println("      Print balloons     : " + balloonSetting.isPrintBalloons());
                printWriter.println("      Print device       : " + balloonSetting.getPrintDevice());
                printWriter.println("      Postscript capable : " + balloonSetting.isPostscriptCapable());
                printWriter.println();
                printWriter.println("      email Balloons     : " + balloonSetting.isEmailBalloons());
                printWriter.println("      email to           : " + balloonSetting.getEmailContact());
                printWriter.println("      SMTP  server       : " + balloonSetting.getMailServer());
                printWriter.println("      Lines Per Page     : " + balloonSetting.getLinesPerPage());
                printWriter.println("      send No judgements : " + balloonSetting.isIncludeNos());
                Properties mailProperties = balloonSetting.getMailProperties();
                Set<Object> set = mailProperties.keySet();
                Object[] keys = set.toArray(new String[set.size()]);
                Arrays.sort(keys);
                printWriter.println("      Mail Properties :");
                for (Object key : keys) {
                    String value = (String)mailProperties.get(key);
                    printWriter.printf("            %-25s : %s\n", key, value);
                }
                printWriter.println();
                int counter = 1;
                for (Problem problem : problems) {
                    printWriter.println("      [" + counter + "] " + problem.getDisplayName() + " '" + balloonSetting.getColor(problem) + "'" + " rgb='" + balloonSetting.getColorRGB(problem) + "'");
                    ++counter;
                }
                printWriter.println();
            }
            catch (Exception e) {
                e.printStackTrace(printWriter);
            }
        }
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Notification Settings";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Notification Settings Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

