/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class AccountsReport
implements IReport {
    private static final long serialVersionUID = -8628612595677727400L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter accountFilter = new Filter();
    private Filter filter;

    private void writeSummaryRow(PrintWriter printWriter, int site) {
        ClientType.Type[] types;
        int total = 0;
        for (ClientType.Type type : types = ClientType.Type.values()) {
            Vector<Account> vector = this.contest.getAccounts(type, site);
            total += vector.size();
            String countString = vector.size() + "";
            if (vector.size() == 0) {
                countString = "-";
            }
            printWriter.format("%7s", countString);
        }
        printWriter.format("%7s", total);
        printWriter.println();
    }

    private void printAccountSummaryBySite(PrintWriter printWriter) {
        Site[] sites = this.contest.getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        printWriter.println();
        ClientType.Type[] types = ClientType.Type.values();
        printWriter.print("Site # ");
        for (ClientType.Type type : types) {
            int truncIndex = Math.min(type.toString().length(), 5);
            printWriter.format("%7s", type.toString().substring(0, truncIndex).toLowerCase());
        }
        printWriter.format("%7s", "total");
        printWriter.println();
        for (Site site : sites) {
            printWriter.print("Site " + site.getSiteNumber());
            this.writeSummaryRow(printWriter, site.getSiteNumber());
        }
    }

    public void writeReport(PrintWriter printWriter) {
        this.printAccountSummaryBySite(printWriter);
        this.printAccountsByGroup(printWriter);
    }

    private void printAccountsByGroup(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Accounts --");
        for (ClientType.Type ctype : ClientType.Type.values()) {
            Vector<Account> accounts = this.accountFilter.isThisSiteOnly() ? this.contest.getAccounts(ctype, this.accountFilter.getSiteNumber()) : this.contest.getAccounts(ctype);
            if (accounts.size() <= 0) continue;
            printWriter.println();
            printWriter.print("Accounts " + ctype.toString() + " there are " + accounts.size());
            if (this.accountFilter.isThisSiteOnly()) {
                printWriter.print(" for site " + this.accountFilter.getSiteNumber());
            }
            printWriter.println();
            Account[] sortedAccounts = accounts.toArray(new Account[accounts.size()]);
            Arrays.sort(sortedAccounts, new AccountComparator());
            for (Account account : sortedAccounts) {
                Permission.Type type;
                printWriter.print("   Site " + account.getSiteNumber());
                printWriter.format(" %-15s", account.getClientId().getName());
                printWriter.println(" id=" + account.getElementId());
                printWriter.format("%22s", " ");
                printWriter.print("'" + account.getDisplayName() + "' ");
                if (this.contest.isAllowed(Permission.Type.VIEW_PASSWORDS)) {
                    printWriter.print("password '" + account.getPassword() + "' ");
                }
                if (account.isAllowed(type = Permission.Type.LOGIN)) {
                    printWriter.print((Object)((Object)type) + " ");
                }
                if (account.isAllowed(type = Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                    printWriter.print((Object)((Object)type) + " ");
                }
                printWriter.println();
                printWriter.format("%22s", " ");
                printWriter.print("alias '" + account.getAliasName() + "' ");
                ElementId groupId = account.getGroupId();
                if (groupId != null) {
                    Group group = this.contest.getGroup(groupId);
                    if (group != null) {
                        printWriter.print("group '" + group + "' (" + groupId + ")");
                    } else {
                        printWriter.print("group invalid (" + groupId + ")");
                    }
                } else {
                    printWriter.print("group ''");
                }
                printWriter.println();
            }
        }
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(this.getReportTitle() + " Report");
    }

    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Accounts";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Accounts Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

