/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.EventStatus;
import edu.csus.ecs.pc2.core.model.playback.PlaybackEvent;
import edu.csus.ecs.pc2.core.model.playback.PlaybackParseException;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaybackManager {
    public static final String ACTION_KEY = "action";
    public static final String ID_KEY = "id";
    public static final String SITE_KEY = "site";
    public static final String PROBLEM_KEY = "problem";
    public static final String LANGUAGE_KEY = "language";
    public static final String MAINFILE_KEY = "mainfile";
    public static final String SUBMIT_CLIENT_KEY = "submitclient";
    public static final String ELAPSED_KEY = "elapsed";
    private static final String DELIMITER = "";
    public static final String IS_SOLVED = "solved";
    public static final String IS_PRELIMINARY = "preliminary";
    public static final String JUDGED_ELAPSED_TIME = "judged_elapsed_time";
    public static final String IS_COMPUTER_JUDGED = "computer_judged";
    public static final String JUDGEMENT_TEXT = "judgement";
    public static final String JUDGE_CLIENT_KEY = "judgeclient";
    public static final String JUDGE_CLIENT_SITE = "judgeclientsite";
    public static final String IS_SEND_TO_TEAMS = "senttoteams";
    private int sequenceNumber = 1;

    public PlaybackEvent[] loadPlayback(String filename, IInternalContest contest) throws Exception {
        Vector<PlaybackEvent> events = new Vector<PlaybackEvent>();
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String[] lines = Utilities.loadFile(filename);
        String sourceDirectory = Utilities.dirname(filename);
        int invalidLines = 0;
        int lineNumber = 0;
        Exception savedException = null;
        for (String s : lines) {
            try {
                ++lineNumber;
                if (s.trim().length() == 0 || s.trim().startsWith("#")) continue;
                PlaybackEvent playbackEvent = this.createPlayBackEvent(lineNumber, contest, s, "[|]", sourceDirectory, events);
                if (playbackEvent != null) {
                    events.add(playbackEvent);
                    continue;
                }
                ++invalidLines;
                System.out.println("Line " + lineNumber + ": unable to parse line: " + s);
            }
            catch (Exception e) {
                if (++invalidLines == 1) {
                    savedException = e;
                }
                System.out.println("Line " + lineNumber + " : " + s);
                System.out.println("Line " + lineNumber + " : Exception = " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (savedException != null) {
            System.out.println("Errors on " + invalidLines + " lines, loading " + filename);
            throw savedException;
        }
        return events.toArray(new PlaybackEvent[events.size()]);
    }

    private static int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected PlaybackEvent createPlayBackEvent(int lineNumber, IInternalContest contest, String s, String delimit, String sourceDir, Vector<PlaybackEvent> events) throws PlaybackParseException {
        String[] fields = s.split(delimit);
        if (fields.length < 3) {
            throw new PlaybackParseException("line must have 3 or more fields");
        }
        PlaybackEvent playbackEvent = null;
        Properties properties = this.mapFieldsNameValuePairs(fields);
        String command = this.getAndCheckValue(properties, ACTION_KEY, "action name/value", lineNumber);
        PlaybackEvent.Action action = PlaybackEvent.Action.UNDEFINED;
        if (command.equalsIgnoreCase(PlaybackEvent.Action.RUN_SUBMIT.toString())) {
            action = PlaybackEvent.Action.RUN_SUBMIT;
            String problemName = this.getAndCheckValue(properties, PROBLEM_KEY, "Problem name", lineNumber);
            String languageName = this.getAndCheckValue(properties, LANGUAGE_KEY, "Language name", lineNumber);
            String mainfileName = this.getAndCheckValue(properties, MAINFILE_KEY, "Main filename", lineNumber);
            String siteId = this.getAndCheckValue(properties, SITE_KEY, "Site number", lineNumber);
            String submitClientName = this.getAndCheckValue(properties, SUBMIT_CLIENT_KEY, "Client id", lineNumber);
            String elapsedTimeStr = this.getAndCheckValue(properties, ELAPSED_KEY, "Elapsed time", false, lineNumber);
            Language language = this.findLanguage(contest, languageName);
            Problem problem = this.findProblem(contest, problemName);
            ClientId clientId = this.findClient(contest, siteId, submitClientName);
            Run run = new Run(clientId, language, problem);
            SerializedFile[] files = new SerializedFile[1];
            try {
                SerializedFile file = new SerializedFile(sourceDir + File.separator + mainfileName);
                if (file == null || file.getBuffer() == null) {
                    throw new PlaybackParseException(lineNumber, "Could not read/find " + mainfileName);
                }
                if (file.getBuffer().length == 0) {
                    throw new PlaybackParseException(lineNumber, "No bytes for file " + mainfileName);
                }
                files[0] = file;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PlaybackParseException(e);
            }
            String idStr = this.getAndCheckValue(properties, ID_KEY, "run/clar number", lineNumber);
            int number = Integer.parseInt(idStr);
            if (number < 1) {
                throw new PlaybackParseException(lineNumber, "invalid run/clar number: " + idStr);
            }
            run.setSiteNumber(contest.getSiteNumber());
            if (siteId != null) {
                int siteNumber = PlaybackManager.getIntegerValue(siteId);
                run.setSiteNumber(siteNumber);
            }
            run.setElapsedMins(PlaybackManager.getIntegerValue(elapsedTimeStr));
            run.setNumber(number);
            playbackEvent = new PlaybackEvent(action, clientId, run);
            playbackEvent.setClientId(clientId);
            playbackEvent.setFiles(files);
        } else if (command.equalsIgnoreCase(PlaybackEvent.Action.RUN_JUDGEMENT.toString())) {
            String judgementText;
            action = PlaybackEvent.Action.RUN_JUDGEMENT;
            String siteId = this.getAndCheckValue(properties, SITE_KEY, "Site number", lineNumber);
            String idStr = this.getAndCheckValue(properties, ID_KEY, "run/clar number", lineNumber);
            int number = Integer.parseInt(idStr);
            if (number < 1) {
                throw new PlaybackParseException(lineNumber, "invalid run/clar number: " + idStr);
            }
            String judgeSiteString = this.getAndCheckValue(properties, JUDGE_CLIENT_SITE, "run/clar number", lineNumber);
            String judgeClientName = this.getAndCheckValue(properties, JUDGE_CLIENT_KEY, "Judge Client id", lineNumber);
            ClientId clientId = this.findClient(contest, judgeSiteString, judgeClientName);
            Run run = this.findRun(contest, siteId, number, events);
            if (run == null) {
                throw new PlaybackParseException("Could not find submitted run for judgement run site " + siteId + " run number " + number);
            }
            ClientId judgeClientId = this.findClient(contest, siteId, judgeClientName);
            String solvedString = this.getAndCheckValue(properties, IS_SOLVED, "Solved flag", false, lineNumber);
            boolean solved = solvedString.equalsIgnoreCase("true");
            ElementId judgementElementId = this.findJudgementId(contest, solved, judgementText = this.getAndCheckValue(properties, JUDGEMENT_TEXT, "Judgement", true, lineNumber));
            if (judgementElementId == null) {
                throw new PlaybackParseException("Could not find judgement " + judgementText);
            }
            String computerJudgedString = this.getAndCheckValue(properties, IS_COMPUTER_JUDGED, "Conputer Judged flag", false, lineNumber);
            boolean computerJudged = computerJudgedString.equalsIgnoreCase("true");
            String prelimJudgedString = this.getAndCheckValue(properties, IS_PRELIMINARY, "Preliminary Judged", false, lineNumber);
            boolean preliminaryJudged = prelimJudgedString.equalsIgnoreCase("true");
            String sendToTeamString = this.getAndCheckValue(properties, IS_SEND_TO_TEAMS, "Send to teams", false, lineNumber);
            boolean sendToTeam = sendToTeamString.equalsIgnoreCase("true");
            boolean usedValidator = false;
            JudgementRecord judgementRecord = new JudgementRecord(judgementElementId, judgeClientId, solved, usedValidator, computerJudged);
            judgementRecord.setPreliminaryJudgement(preliminaryJudged);
            judgementRecord.setSendToTeam(sendToTeam);
            playbackEvent = new PlaybackEvent(action, judgeClientId, run, judgementRecord);
            playbackEvent.setClientId(clientId);
        } else {
            throw new PlaybackParseException(lineNumber, "Unknown event: " + command);
        }
        return playbackEvent;
    }

    private ElementId findJudgementId(IInternalContest contest, boolean solved, String judgementText) {
        Judgement[] judgements = contest.getJudgements();
        if (solved) {
            return judgements[0].getElementId();
        }
        for (Judgement judgement : judgements) {
            if (!judgementText.trim().equalsIgnoreCase(judgement.getDisplayName().trim())) continue;
            return judgement.getElementId();
        }
        return null;
    }

    private Run findRun(IInternalContest contest, String siteIdString, int number, Vector<PlaybackEvent> events) {
        if (events == null) {
            return null;
        }
        int siteId = PlaybackManager.getIntegerValue(siteIdString);
        for (PlaybackEvent event : events) {
            Run run;
            if (!event.getAction().equals((Object)PlaybackEvent.Action.RUN_SUBMIT) || (run = event.getRun()).getNumber() != number || run.getSiteNumber() != siteId) continue;
            return run;
        }
        return null;
    }

    private ClientId findClient(IInternalContest contest, String siteId, String loginName) throws PlaybackParseException {
        int siteNumber = PlaybackManager.getIntegerValue(siteId);
        if (loginName.startsWith("team") && loginName.length() > 4) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(4));
            return new ClientId(siteNumber, ClientType.Type.TEAM, number);
        }
        if (loginName.startsWith("t") && loginName.length() > 1) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(1));
            return new ClientId(siteNumber, ClientType.Type.TEAM, number);
        }
        if (loginName.startsWith("judge") && loginName.length() > 5) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(5));
            return new ClientId(siteNumber, ClientType.Type.JUDGE, number);
        }
        throw new PlaybackParseException("Could not find/match client: " + loginName);
    }

    private Problem findProblem(IInternalContest contest, String problemName) throws PlaybackParseException {
        for (Problem problem : contest.getProblems()) {
            if (!problem.getDisplayName().trim().equalsIgnoreCase(problemName.trim())) continue;
            return problem;
        }
        throw new PlaybackParseException("Could not find/match problem: " + problemName);
    }

    private Language findLanguage(IInternalContest contest, String languageName) throws PlaybackParseException {
        for (Language language : contest.getLanguages()) {
            if (!language.getDisplayName().trim().equalsIgnoreCase(languageName.trim())) continue;
            return language;
        }
        throw new PlaybackParseException("Could not find/match language: " + languageName);
    }

    private String getAndCheckValue(Properties properties, String key, String message, int lineNumber) throws PlaybackParseException {
        return this.getAndCheckValue(properties, key, message, true, lineNumber);
    }

    private String getAndCheckValue(Properties properties, String key, String message, boolean requiredOption, int lineNumber) throws PlaybackParseException {
        String value = properties.getProperty(key);
        if (value == null && requiredOption) {
            throw new PlaybackParseException(lineNumber, message + " value missing (key = " + key + ")");
        }
        return value;
    }

    private Properties mapFieldsNameValuePairs(String[] fields) throws PlaybackParseException {
        Properties properties = new Properties();
        int fieldNumber = 0;
        for (String field : fields) {
            ++fieldNumber;
            if (field.trim().length() == 0) continue;
            int index = field.indexOf("=");
            if (index == -1) {
                throw new PlaybackParseException("Missing = in name/value pair, field " + fieldNumber + ": " + field);
            }
            String key = field.substring(0, index).trim().toLowerCase();
            String value = field.substring(index + 1);
            properties.put(key, value);
        }
        return properties;
    }

    public void sendToJudgesAndOthers(IInternalController controller, Packet packet, boolean sendToServers) {
        controller.sendToAdministrators(packet);
        controller.sendToJudges(packet);
        controller.sendToScoreboards(packet);
        if (sendToServers) {
            controller.sendToServers(packet);
        }
    }

    private void writeValues(String key, long number) {
        System.out.print(key + "=" + number + DELIMITER + " ");
    }

    private void writeValues(String key, String value) {
        System.out.print(key + "=" + value + DELIMITER + " ");
    }

    private void dump(String message, PlaybackEvent playbackEvent) {
        Run run = playbackEvent.getRun();
        System.out.println(message);
        this.writeValues(ACTION_KEY, playbackEvent.getAction().toString());
        this.writeValues(ID_KEY, run.getNumber());
        this.writeValues(ELAPSED_KEY, run.getElapsedMins());
        this.writeValues(LANGUAGE_KEY, run.getLanguageId().toString());
        this.writeValues(PROBLEM_KEY, run.getProblemId().toString());
        this.writeValues(SITE_KEY, run.getSiteNumber());
        this.writeValues(SUBMIT_CLIENT_KEY, run.getSubmitter().getName());
        this.writeValues("File size", playbackEvent.getFiles()[0].getBuffer().length);
        System.out.println();
    }

    public void executeEvent(PlaybackEvent playbackEvent, IInternalContest contest, IInternalController controller) throws Exception {
        if (Utilities.isDebugMode()) {
            this.dump("in executeEvent", playbackEvent);
        }
        switch (playbackEvent.getAction()) {
            case RUN_SUBMIT: {
                SerializedFile file = playbackEvent.getFiles()[0];
                SerializedFile[] files = new SerializedFile[]{file};
                RunFiles runFiles = new RunFiles(playbackEvent.getRun(), file, new SerializedFile[0]);
                Run theRun = playbackEvent.getRun();
                long savedElapsed = theRun.getElapsedMS();
                Run newRun = contest.acceptRun(theRun, runFiles);
                if (savedElapsed > 0L) {
                    newRun.setElapsedMS(savedElapsed);
                }
                ++this.sequenceNumber;
                playbackEvent.setEventStatus(EventStatus.COMPLETED);
                ClientId fromId = contest.getClientId();
                Packet confirmPacket = PacketFactory.createRunSubmissionConfirm(contest.getClientId(), fromId, newRun);
                controller.sendToClient(confirmPacket);
                this.sendToJudgesAndOthers(controller, confirmPacket, true);
                break;
            }
            case RUN_JUDGEMENT: {
                Run run = playbackEvent.getRun();
                this.sendStatusMessge(contest, controller, run, RunExecutionStatus.COMPILING);
                this.sendStatusMessge(contest, controller, run, RunExecutionStatus.EXECUTING);
                this.sendStatusMessge(contest, controller, run, RunExecutionStatus.VALIDATING);
                JudgementRecord judgement = playbackEvent.getJudgementRecord();
                Run runToUpdate = contest.getRun(run.getElementId());
                runToUpdate.addJudgement(judgement);
                ClientId whoChangedRun = judgement.getJudgerClientId();
                runToUpdate.setStatus(Run.RunStates.JUDGED);
                contest.updateRun(runToUpdate, whoChangedRun);
                Run updatedRun = contest.getRun(run.getElementId());
                Packet runUpdatedPacket = PacketFactory.createRunUpdateNotification(contest.getClientId(), PacketFactory.ALL_SERVERS, updatedRun, whoChangedRun);
                this.sendToJudgesAndOthers(controller, runUpdatedPacket, true);
                if (updatedRun.isJudged() && updatedRun.getJudgementRecord().isSendToTeam()) {
                    Packet notifyPacket = PacketFactory.clonePacket(contest.getClientId(), run.getSubmitter(), runUpdatedPacket);
                    this.sendJudgementToTeam(controller, contest, notifyPacket, updatedRun);
                }
                ++this.sequenceNumber;
                playbackEvent.setEventStatus(EventStatus.COMPLETED);
                break;
            }
            default: {
                throw new Exception(playbackEvent.getAction().toString());
            }
        }
    }

    private void sendStatusMessge(IInternalContest contest, IInternalController controller, Run run, RunExecutionStatus status) {
        if (contest.isSendAdditionalRunStatusMessages()) {
            Packet sendPacket = PacketFactory.createRunStatusPacket(contest.getClientId(), contest.getClientId(), run, contest.getClientId(), status);
            this.sendToSpectatorsAndSites(controller, sendPacket, true);
        }
    }

    public void sendToSpectatorsAndSites(IInternalController controller, Packet packet, boolean sendToServers) {
        controller.sendToSpectators(packet);
        if (sendToServers) {
            controller.sendToServers(packet);
        }
    }

    private void sendJudgementToTeam(IInternalController controller, IInternalContest contest, Packet judgementPacket, Run run) {
        if (run.isJudged() && run.getJudgementRecord().isSendToTeam()) {
            JudgementNotificationsList judgementNotificationsList = contest.getContestInformation().getJudgementNotificationsList();
            if (!RunUtilities.supppressJudgement(judgementNotificationsList, run, contest.getContestTime())) {
                controller.sendToClient(judgementPacket);
            } else {
                controller.getLog().info("Notification not sent to " + run.getSubmitter() + " for run " + run);
            }
        } else {
            controller.getLog().warning("Attempted to send back unjudged run to team " + run);
        }
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

