/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.EventStatus;

public class PlaybackEvent
implements IElementObject {
    private ElementId elementId = null;
    private Action action = Action.UNDEFINED;
    private int sequenceId = 0;
    private Run run = null;
    private ISubmission submission = null;
    private ClientId submitterId;
    private ClientId clientId;
    private long eventTime;
    private EventStatus eventStatus = EventStatus.INVALID;
    private SerializedFile[] files = new SerializedFile[0];
    private JudgementRecord judgementRecord;
    private static final long serialVersionUID = -8414973988906358491L;

    public JudgementRecord getJudgementRecord() {
        return this.judgementRecord;
    }

    public void setJudgementRecord(JudgementRecord judgementRecord) {
        this.judgementRecord = judgementRecord;
    }

    public SerializedFile[] getFiles() {
        return this.files;
    }

    public void setFiles(SerializedFile[] files) {
        this.files = files;
    }

    public PlaybackEvent(Action action, ClientId clientId) {
        this.action = action;
        this.clientId = clientId;
    }

    public PlaybackEvent(Action action, ClientId clientId, Run run) {
        this.action = action;
        this.run = run;
        this.submission = run;
        this.clientId = clientId;
        this.submitterId = run.getSubmitter();
        this.eventStatus = EventStatus.PENDING;
        this.eventTime = run.getElapsedMins();
    }

    public PlaybackEvent(Action action, ClientId clientId, Run run, JudgementRecord judgementRecord) {
        this(action, clientId, run);
        this.judgementRecord = judgementRecord;
    }

    public long etElapsedMins() {
        return this.submission.getElapsedMins();
    }

    public Action getAction() {
        return this.action;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public Run getRun() {
        return this.run;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public ClientId getSubmitterId() {
        return this.submitterId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public void setSiteNumber(int siteNumber) {
    }

    public void setSubmitterId(ClientId submitterId) {
        this.submitterId = submitterId;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public int getId() {
        if (this.run != null) {
            return this.run.getNumber();
        }
        return 0;
    }

    public EventStatus getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        UNDEFINED,
        RUN_SUBMIT,
        RUN_JUDGEMENT;

    }
}

