/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.io.Serializable;

public class RunResultFiles
implements Serializable {
    private static final long serialVersionUID = -4739592801158369138L;
    private ElementId runId = null;
    private ElementId problemId = null;
    private ElementId judgementId = null;
    private ExecutionData executionData = null;

    public RunResultFiles(Run run, ElementId problemId, JudgementRecord judgementRecord, ExecutionData executionData) {
        this.runId = run.getElementId();
        this.problemId = problemId;
        if (judgementRecord != null) {
            this.judgementId = judgementRecord.getJudgementId();
        }
        this.executionData = executionData;
    }

    public SerializedFile getCompilerStderrFile() {
        if (this.executionData == null) {
            return null;
        }
        return this.executionData.getCompileStderr();
    }

    public void setCompilerStderrFile(SerializedFile compilerStderrFile) {
        if (this.executionData != null) {
            this.executionData.setCompileStderr(compilerStderrFile);
        }
    }

    public SerializedFile getCompilerStdoutFile() {
        if (this.executionData == null) {
            return null;
        }
        return this.executionData.getCompileStdout();
    }

    public void setCompilerStdoutFile(SerializedFile compilerStdoutFile) {
        if (this.executionData != null) {
            this.executionData.setCompileStderr(compilerStdoutFile);
        }
    }

    public SerializedFile getExecuteStderrFile() {
        if (this.executionData == null) {
            return null;
        }
        return this.executionData.getExecuteStderr();
    }

    public void setExecuteStderrFile(SerializedFile executeStderrFile) {
        if (this.executionData != null) {
            this.executionData.setExecuteStderr(executeStderrFile);
        }
    }

    public SerializedFile getExecuteStdoutFile() {
        if (this.executionData == null) {
            return null;
        }
        return this.executionData.getExecuteProgramOutput();
    }

    public void setExecuteStdoutFile(SerializedFile executeStdoutFile) {
        if (this.executionData != null) {
            this.executionData.setExecuteProgramOutput(executeStdoutFile);
        }
    }

    public ElementId getProblemId() {
        return this.problemId;
    }

    public void setProblemId(ElementId problemId) {
        this.problemId = problemId;
    }

    public ElementId getRunId() {
        return this.runId;
    }

    public void setRunId(ElementId runId) {
        this.runId = runId;
    }

    public SerializedFile getValidatorStderrFile() {
        if (this.executionData == null) {
            return null;
        }
        return this.executionData.getValidationStderr();
    }

    public void setValidatorStderrFile(SerializedFile validatorStderrFile) {
        if (this.executionData != null) {
            this.executionData.setValidationStderr(validatorStderrFile);
        }
    }

    public SerializedFile getValidatorStdoutFile() {
        if (this.executionData == null) {
            return null;
        }
        return this.executionData.getValidationStdout();
    }

    public void setValidatorStdoutFile(SerializedFile validatorStdoutFile) {
        if (this.executionData != null) {
            this.executionData.setValidationStdout(validatorStdoutFile);
        }
    }

    public boolean failedInCompile() {
        if (this.executionData == null) {
            return false;
        }
        return !this.executionData.isCompileSuccess();
    }

    public void setFailedInCompile(boolean failed) {
        if (this.executionData == null) {
            this.executionData.setCompileSuccess(!failed);
        }
    }

    public boolean failedInExecute() {
        if (this.executionData == null) {
            return false;
        }
        return !this.executionData.isExecuteSucess();
    }

    public void setFailedInExecute(boolean failed) {
        if (this.executionData == null) {
            this.executionData.setExecuteSucess(!failed);
        }
    }

    public boolean failedInValidating() {
        if (this.executionData == null) {
            return false;
        }
        return !this.executionData.isValidationSuccess();
    }

    public void setFailedInValidating(boolean failed) {
        if (this.executionData == null) {
            this.executionData.setValidationSuccess(!failed);
        }
    }

    public long getCompileTimeMS() {
        if (this.executionData == null) {
            return 0L;
        }
        return this.executionData.getCompileTimeMS();
    }

    public void setCompileTimeMS(long compileTimeMS) {
        if (this.executionData != null) {
            this.executionData.setCompileTimeMS(compileTimeMS);
        }
    }

    public long getExecuteTimeMS() {
        if (this.executionData == null) {
            return 0L;
        }
        return this.executionData.getExecuteTimeMS();
    }

    public void setExecuteTimeMS(long executeTimeMS) {
        if (this.executionData != null) {
            this.executionData.setExecuteTimeMS(executeTimeMS);
        }
    }

    public long getValidateTimeMS() {
        if (this.executionData == null) {
            return 0L;
        }
        return this.executionData.getvalidateTimeMS();
    }

    public void setValidateTimeMS(long validateTimeMS) {
        if (this.executionData != null) {
            this.executionData.setvalidateTimeMS(validateTimeMS);
        }
    }

    public ElementId getJudgementId() {
        return this.judgementId;
    }

    public long getCompileResultCode() {
        if (this.executionData == null) {
            return 0L;
        }
        return this.executionData.getCompileResultCode();
    }

    public long getExecutionResultCode() {
        if (this.executionData == null) {
            return 0L;
        }
        return this.executionData.getExecuteExitValue();
    }

    public long getValidationResultCode() {
        if (this.executionData == null) {
            return 0L;
        }
        return this.executionData.getValidationReturnCode();
    }

    public String getValidationResults() {
        if (this.executionData == null) {
            return "";
        }
        return this.executionData.getValidationResults();
    }
}

