/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.SerializedFile;

public class ProblemDataFiles
implements IElementObject {
    private static final long serialVersionUID = -3590638930073985058L;
    public static final String SVN_ID = "$Id: ProblemDataFiles.java 2092 2010-06-25 17:17:56Z laned $";
    private ElementId elementId = new ElementId("ProblemDF");
    private ElementId problemId = null;
    private SerializedFile validatorFile;
    private SerializedFile[] judgesDataFiles = new SerializedFile[0];
    private SerializedFile[] judgesAnswerFiles = new SerializedFile[0];

    public ProblemDataFiles(Problem problem) {
        this.problemId = problem.getElementId();
    }

    public ProblemDataFiles copy(Problem problem) throws CloneNotSupportedException {
        ProblemDataFiles clone = new ProblemDataFiles(problem);
        clone.setSiteNumber(this.getSiteNumber());
        clone.setValidatorFile(this.cloneSerializedFile(this.getValidatorFile()));
        clone.setJudgesAnswerFiles(this.cloneSFArray(this.getJudgesAnswerFiles()));
        clone.setJudgesDataFiles(this.cloneSFArray(this.getJudgesDataFiles()));
        return clone;
    }

    private SerializedFile[] cloneSFArray(SerializedFile[] fileArray) throws CloneNotSupportedException {
        SerializedFile[] clone;
        if (fileArray != null) {
            clone = new SerializedFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                clone[i] = this.cloneSerializedFile(fileArray[i]);
            }
        } else {
            clone = null;
        }
        return clone;
    }

    private SerializedFile cloneSerializedFile(SerializedFile file) throws CloneNotSupportedException {
        SerializedFile clone = null;
        if (file != null) {
            clone = (SerializedFile)file.clone();
        }
        return clone;
    }

    public SerializedFile[] getJudgesAnswerFiles() {
        return this.judgesAnswerFiles;
    }

    public SerializedFile[] getJudgesDataFiles() {
        return this.judgesDataFiles;
    }

    public void setJudgesAnswerFiles(SerializedFile[] judgesAnswerFiles) {
        this.judgesAnswerFiles = judgesAnswerFiles;
    }

    public void setJudgesAnswerFile(SerializedFile judgesAnswerFile) {
        SerializedFile[] files = new SerializedFile[]{judgesAnswerFile};
        this.setJudgesAnswerFiles(files);
    }

    public void setJudgesDataFiles(SerializedFile[] judgesDataFiles) {
        this.judgesDataFiles = judgesDataFiles;
    }

    public void setJudgesDataFile(SerializedFile judgesDataFile) {
        SerializedFile[] files = new SerializedFile[]{judgesDataFile};
        this.setJudgesDataFiles(files);
    }

    public SerializedFile getJudgesDataFile() {
        SerializedFile[] files = this.getJudgesDataFiles();
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public SerializedFile getJudgesAnswerFile() {
        SerializedFile[] files = this.getJudgesAnswerFiles();
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public ElementId getProblemId() {
        return this.problemId;
    }

    protected void setProblemId(ElementId problemId) {
        this.problemId = problemId;
    }

    public SerializedFile getValidatorFile() {
        return this.validatorFile;
    }

    public void setValidatorFile(SerializedFile validatorFile) {
        this.validatorFile = validatorFile;
    }

    private boolean compareSerializedFiles(SerializedFile oldFile, SerializedFile newFile) {
        if (oldFile == null) {
            return newFile == null;
        }
        if (newFile == null) {
            return false;
        }
        if (!oldFile.getSHA1sum().equals(newFile.getSHA1sum())) {
            return false;
        }
        if (!oldFile.getAbsolutePath().equals(newFile.getAbsolutePath())) {
            return false;
        }
        byte[] oldBuffer = oldFile.getBuffer();
        byte[] newBuffer = newFile.getBuffer();
        if (oldBuffer == null ? newBuffer != null : newBuffer == null) {
            return false;
        }
        if (oldBuffer.length != newBuffer.length) {
            return false;
        }
        for (int i = 0; i < newBuffer.length; ++i) {
            if (newBuffer[i] == oldBuffer[i]) continue;
            return false;
        }
        return true;
    }

    private boolean compareSerializedFileArrays(SerializedFile[] oldList, SerializedFile[] newList) {
        if (oldList == null) {
            return newList == null;
        }
        if (newList == null) {
            return false;
        }
        if (oldList.length != newList.length) {
            return false;
        }
        for (int i = 0; i < oldList.length; ++i) {
            if (this.compareSerializedFiles(oldList[i], newList[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isSameAs(ProblemDataFiles newProblemDataFiles) {
        try {
            if (newProblemDataFiles == null) {
                return false;
            }
            if (!this.compareSerializedFileArrays(this.judgesAnswerFiles, newProblemDataFiles.getJudgesAnswerFiles())) {
                return false;
            }
            if (!this.compareSerializedFileArrays(this.judgesDataFiles, newProblemDataFiles.getJudgesDataFiles())) {
                return false;
            }
            return this.compareSerializedFiles(this.validatorFile, newProblemDataFiles.getValidatorFile());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

