/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class Problem
implements IElementObject {
    public static final String INTERNAL_VALIDATOR_NAME = "pc2.jar edu.csus.ecs.pc2.validator.Validator";
    private static final long serialVersionUID = 1708763261096488240L;
    private String displayName = null;
    private ElementId elementId = null;
    private int number;
    private String dataFileName = null;
    private String answerFileName = null;
    private boolean active = true;
    private boolean readInputDataFromSTDIN = false;
    private int timeOutInSeconds;
    private boolean validatedProblem = false;
    private boolean usingPC2Validator = false;
    private int whichPC2Validator = 0;
    private String validatorCommandLine;
    private String validatorProgramName;
    private boolean internationalJudgementReadMethod = true;
    private boolean ignoreSpacesOnValidation = false;
    private boolean showValidationToJudges = false;
    private boolean hideOutputWindow = false;
    private boolean showCompareWindow = false;
    private boolean computerJudged = false;
    private boolean manualReview = false;
    private boolean prelimaryNotification = false;

    public Problem(String displayName) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
    }

    private String cloneString(String s) {
        String result = null;
        if (s != null) {
            result = new String(s);
        }
        return result;
    }

    public Problem copy(String newDisplayName) {
        Problem clone = new Problem(newDisplayName);
        clone.setSiteNumber(this.getSiteNumber());
        clone.setDisplayName(newDisplayName);
        clone.setNumber(this.getNumber());
        clone.setDataFileName(this.cloneString(this.dataFileName));
        clone.setAnswerFileName(this.cloneString(this.answerFileName));
        clone.setActive(this.isActive());
        clone.setReadInputDataFromSTDIN(this.isReadInputDataFromSTDIN());
        clone.setTimeOutInSeconds(this.getTimeOutInSeconds());
        clone.setValidatedProblem(this.isValidatedProblem());
        clone.setUsingPC2Validator(this.isUsingPC2Validator());
        clone.setWhichPC2Validator(this.getWhichPC2Validator());
        clone.setValidatorCommandLine(this.cloneString(this.validatorCommandLine));
        clone.setValidatorProgramName(this.cloneString(this.validatorProgramName));
        clone.setInternationalJudgementReadMethod(this.isInternationalJudgementReadMethod());
        clone.setIgnoreSpacesOnValidation(this.isIgnoreSpacesOnValidation());
        clone.setShowValidationToJudges(this.isShowValidationToJudges());
        clone.setHideOutputWindow(this.isHideOutputWindow());
        clone.setShowCompareWindow(this.isShowCompareWindow());
        clone.setComputerJudged(this.isComputerJudged());
        clone.setManualReview(this.isManualReview());
        clone.setPrelimaryNotification(this.isPrelimaryNotification());
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Problem) {
            Problem otherProblem = (Problem)obj;
            return this.elementId.equals(otherProblem.elementId);
        }
        throw new ClassCastException("expected a Problem found: " + obj.getClass().getName());
    }

    public String toString() {
        return this.displayName;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getAnswerFileName() {
        return this.answerFileName;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public boolean isIgnoreSpacesOnValidation() {
        return this.ignoreSpacesOnValidation;
    }

    public boolean isInternationalJudgementReadMethod() {
        return this.internationalJudgementReadMethod;
    }

    public boolean isReadInputDataFromSTDIN() {
        return this.readInputDataFromSTDIN;
    }

    public boolean isShowValidationToJudges() {
        return this.showValidationToJudges;
    }

    public int getTimeOutInSeconds() {
        return this.timeOutInSeconds;
    }

    public boolean isUsingPC2Validator() {
        return this.usingPC2Validator;
    }

    public boolean isValidatedProblem() {
        return this.validatedProblem;
    }

    public String getValidatorCommandLine() {
        return this.validatorCommandLine;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAnswerFileName(String answerFileName) {
        this.answerFileName = answerFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public void setElementId(ElementId elementId) {
        this.elementId = elementId;
    }

    public void setIgnoreSpacesOnValidation(boolean ignoreSpacesOnValidation) {
        this.ignoreSpacesOnValidation = ignoreSpacesOnValidation;
    }

    public void setInternationalJudgementReadMethod(boolean internationalJudgementReadMethod) {
        this.internationalJudgementReadMethod = internationalJudgementReadMethod;
    }

    public void setReadInputDataFromSTDIN(boolean readInputDataFromSTDIN) {
        this.readInputDataFromSTDIN = readInputDataFromSTDIN;
    }

    public void setShowValidationToJudges(boolean showValidationToJudges) {
        this.showValidationToJudges = showValidationToJudges;
    }

    public void setTimeOutInSeconds(int timeOutInSeconds) {
        this.timeOutInSeconds = timeOutInSeconds;
    }

    public void setUsingPC2Validator(boolean usingPC2Validator) {
        this.usingPC2Validator = usingPC2Validator;
    }

    public void setValidatedProblem(boolean validated) {
        this.validatedProblem = validated;
    }

    public void setValidatorCommandLine(String validatorCommandLine) {
        this.validatorCommandLine = validatorCommandLine;
    }

    public boolean isHideOutputWindow() {
        return this.hideOutputWindow;
    }

    public void setHideOutputWindow(boolean hideOutputWindow) {
        this.hideOutputWindow = hideOutputWindow;
    }

    public String getValidatorProgramName() {
        return this.validatorProgramName;
    }

    public void setValidatorProgramName(String validatorProgramName) {
        this.validatorProgramName = validatorProgramName;
    }

    protected int getNumber() {
        return this.number;
    }

    protected void setNumber(int number) {
        this.number = number;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public int getWhichPC2Validator() {
        return this.whichPC2Validator;
    }

    public void setWhichPC2Validator(int whichPC2Validator) {
        this.whichPC2Validator = whichPC2Validator;
    }

    public int hashCode() {
        return this.getElementId().toString().hashCode();
    }

    private boolean stringSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public boolean isSameAs(Problem problem) {
        try {
            if (problem == null) {
                return false;
            }
            if (!this.stringSame(this.displayName, problem.getDisplayName())) {
                return false;
            }
            if (this.isActive() != problem.isActive()) {
                return false;
            }
            if (this.timeOutInSeconds != problem.getTimeOutInSeconds()) {
                return false;
            }
            if (!this.stringSame(this.dataFileName, problem.getDataFileName())) {
                return false;
            }
            if (!this.stringSame(this.answerFileName, problem.getAnswerFileName())) {
                return false;
            }
            if (!this.readInputDataFromSTDIN == problem.isReadInputDataFromSTDIN()) {
                return false;
            }
            if (this.validatedProblem != problem.isValidatedProblem()) {
                return false;
            }
            if (this.usingPC2Validator != problem.isUsingPC2Validator()) {
                return false;
            }
            if (this.whichPC2Validator != problem.getWhichPC2Validator()) {
                return false;
            }
            if (!this.stringSame(this.validatorProgramName, problem.getValidatorProgramName())) {
                return false;
            }
            if (!this.stringSame(this.validatorCommandLine, problem.getValidatorCommandLine())) {
                return false;
            }
            if (this.ignoreSpacesOnValidation != problem.isIgnoreSpacesOnValidation()) {
                return false;
            }
            if (this.showValidationToJudges != problem.isShowValidationToJudges()) {
                return false;
            }
            if (this.hideOutputWindow != problem.isHideOutputWindow()) {
                return false;
            }
            if (this.showCompareWindow != problem.isShowCompareWindow()) {
                return false;
            }
            if (this.computerJudged != problem.isComputerJudged()) {
                return false;
            }
            if (this.manualReview != problem.isManualReview()) {
                return false;
            }
            if (this.prelimaryNotification != problem.isPrelimaryNotification()) {
                return false;
            }
            return this.getSiteNumber() == problem.getSiteNumber();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isShowCompareWindow() {
        return this.showCompareWindow;
    }

    public void setShowCompareWindow(boolean showCompareWindow) {
        this.showCompareWindow = showCompareWindow;
    }

    public boolean isComputerJudged() {
        return this.computerJudged;
    }

    public void setComputerJudged(boolean computerJudged) {
        this.computerJudged = computerJudged;
    }

    public boolean isManualReview() {
        return this.manualReview;
    }

    public void setManualReview(boolean manualReview) {
        this.manualReview = manualReview;
    }

    public boolean isPrelimaryNotification() {
        return this.prelimaryNotification;
    }

    public void setPrelimaryNotification(boolean prelimaryNotification) {
        this.prelimaryNotification = prelimaryNotification;
    }
}

