/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class Language
implements IElementObject {
    private static final long serialVersionUID = 7782777481422759344L;
    private String displayName = null;
    private ElementId elementId = null;
    private boolean active = true;
    private String compileCommandLine;
    private String executableIdentifierMask;
    private String programExecuteCommandLine;

    public Language(String displayName) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCompileCommandLine() {
        return this.compileCommandLine;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getProgramExecuteCommandLine() {
        return this.programExecuteCommandLine;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCompileCommandLine(String compileCommandLine) {
        this.compileCommandLine = compileCommandLine;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setProgramExecuteCommandLine(String programExecuteCommandLine) {
        this.programExecuteCommandLine = programExecuteCommandLine;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Language) {
            Language otherLanguage = (Language)obj;
            return this.elementId.equals(otherLanguage.elementId);
        }
        throw new ClassCastException("expected an Language found: " + obj.getClass().getName());
    }

    public String toString() {
        return this.displayName;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public boolean isSameAs(Language language) {
        try {
            if (!this.displayName.equals(language.getDisplayName())) {
                return false;
            }
            if (this.isActive() != language.isActive()) {
                return false;
            }
            if (!this.compileCommandLine.equals(language.getCompileCommandLine())) {
                return false;
            }
            return this.programExecuteCommandLine.equals(language.getProgramExecuteCommandLine());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    public String getExecutableIdentifierMask() {
        return this.executableIdentifierMask;
    }

    public void setExecutableIdentifierMask(String executableIdentifierMask) {
        this.executableIdentifierMask = executableIdentifierMask;
    }
}

