/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.JudgeComment;
import java.io.Serializable;

public class JudgementRecord
implements Serializable {
    private static final long serialVersionUID = -2043715842465711645L;
    private ElementId judgementId = null;
    public static final String JUDGEMENT_RECORD_ID = "JudgementRecord";
    private ElementId elementId = new ElementId("JudgementRecord");
    private ClientId judgerClientId;
    private boolean usedValidator = false;
    private boolean acceptButtonHit = false;
    private boolean active = true;
    private long judgedSeconds = 0L;
    private long executeSeconds = 0L;
    private JudgeComment commentForTeam = null;
    private JudgeComment commentForJudge = null;
    private long whenJudgedTime;
    private long howLongToJudgeInSeconds;
    private boolean solved = false;
    private boolean sendToTeam = true;
    private String validatorResultString = null;
    private ElementId runResultsElementId = null;
    private boolean computerJudgement = false;
    private ElementId previousComputerJudgementId = null;
    private boolean preliminaryJudgement = false;

    public JudgementRecord(ElementId judgementId, ClientId judgerClientId, boolean solved, boolean usedValidator) {
        this.judgementId = judgementId;
        this.judgerClientId = judgerClientId;
        this.usedValidator = usedValidator;
        this.solved = solved;
    }

    public JudgementRecord(ElementId judgementId, ClientId judgerClientId, boolean solved, boolean usedValidator, boolean computerJudgement) {
        this(judgementId, judgerClientId, solved, usedValidator);
        this.computerJudgement = computerJudgement;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getJudgedSeconds() {
        return this.judgedSeconds;
    }

    public void setJudgedSeconds(long judgedSeconds) {
        this.judgedSeconds = judgedSeconds;
    }

    public long getJudgedMinutes() {
        return this.getJudgedSeconds() / 60L;
    }

    public ElementId getJudgementId() {
        return this.judgementId;
    }

    public void setJudgementId(ElementId judgementId) {
        this.judgementId = judgementId;
    }

    public ClientId getJudgerClientId() {
        return this.judgerClientId;
    }

    public JudgeComment getCommentForJudge() {
        return this.commentForJudge;
    }

    public void setCommentForJudge(JudgeComment commentForJudge) {
        this.commentForJudge = commentForJudge;
    }

    public JudgeComment getCommentForTeam() {
        return this.commentForTeam;
    }

    public void setCommentForTeam(JudgeComment commentForTeam) {
        this.commentForTeam = commentForTeam;
    }

    public long getWhenJudgedTime() {
        return this.whenJudgedTime;
    }

    public void setWhenJudgedTime(long whenJudgedTime) {
        this.whenJudgedTime = whenJudgedTime;
    }

    public boolean isSolved() {
        return this.solved;
    }

    public void setSolved(boolean solved) {
        this.solved = solved;
    }

    public boolean isSendToTeam() {
        return this.sendToTeam;
    }

    public void setSendToTeam(boolean sendToTeams) {
        this.sendToTeam = sendToTeams;
    }

    public void setJudgerClientId(ClientId judgerClientId) {
        this.judgerClientId = judgerClientId;
    }

    public long getHowLongToJudgeInSeconds() {
        return this.howLongToJudgeInSeconds;
    }

    public void setHowLongToJudgeInSeconds(long howLongToJudgeInSeconds) {
        this.howLongToJudgeInSeconds = howLongToJudgeInSeconds;
    }

    public boolean isUsedValidator() {
        return this.usedValidator;
    }

    public void setUsedValidator(boolean usedValidator) {
        this.usedValidator = usedValidator;
    }

    public long getExecuteSeconds() {
        return this.executeSeconds;
    }

    public void setExecuteSeconds(long executeSections) {
        this.executeSeconds = executeSections;
    }

    public String toString() {
        String infoString = "No";
        if (this.isSolved()) {
            infoString = "Yes";
        }
        return infoString + " by " + this.judgerClientId + " judgement " + this.judgementId + " id " + this.getElementId();
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public String getValidatorResultString() {
        return this.validatorResultString;
    }

    public void setValidatorResultString(String validatorResultString) {
        this.validatorResultString = validatorResultString;
    }

    public boolean isAcceptButtonHit() {
        return this.acceptButtonHit;
    }

    public void setAcceptButtonHit(boolean acceptButtonHit) {
        this.acceptButtonHit = acceptButtonHit;
    }

    public ElementId getRunResultsElementId() {
        return this.runResultsElementId;
    }

    public void setRunResultsElementId(ElementId runResultsElementId) {
        this.runResultsElementId = runResultsElementId;
    }

    public boolean isComputerJudgement() {
        return this.computerJudgement;
    }

    public void setPreviousComputerJudgementId(ElementId previousComputerJudgementId) {
        this.previousComputerJudgementId = previousComputerJudgementId;
    }

    public ElementId getPreviousComputerJudgementId() {
        return this.previousComputerJudgementId;
    }

    public boolean isPreliminaryJudgement() {
        return this.preliminaryJudgement;
    }

    public void setPreliminaryJudgement(boolean preliminaryJudgement) {
        this.preliminaryJudgement = preliminaryJudgement;
    }
}

