/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;

public class InternalDump {
    private String editorNameFullPath = "/windows/vi.bat";
    private IInternalContest contest;

    public InternalDump(IInternalContest contest) {
        this.contest = contest;
    }

    protected void viewFile(String dumpFileName) {
        String editorName = this.editorNameFullPath;
        File f = new File(editorName);
        if (!f.exists()) {
            Log log = new Log("viewFile");
            MultipleFileViewer multipleFileViewer = new MultipleFileViewer(log);
            multipleFileViewer.addFilePane("Internal Dump", dumpFileName);
            FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
            multipleFileViewer.setVisible(true);
        } else {
            String command = editorName + " " + dumpFileName;
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Unable to run command " + command + " " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void viewContestData() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String filename = "dump" + simpleDateFormat.format(new Date()) + ".log";
        if (this.generateReportFile(filename) != null) {
            this.viewFile(filename);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String generateReportFile(String filename) {
        try {
            void var12_37;
            void var9_23;
            PrintWriter log = new PrintWriter(new FileOutputStream(filename, false), true);
            log.println(new VersionInfo().getSystemName());
            log.println("Date: " + new Date());
            log.println(new VersionInfo().getSystemVersionInfo());
            Vector<Account> allAccounts = new Vector<Account>();
            log.println();
            log.println("-- Accounts --");
            for (ClientType.Type ctype : ClientType.Type.values()) {
                if (this.contest.getAccounts(ctype).size() <= 0) continue;
                log.println("Accounts " + ctype.toString() + " there are " + this.contest.getAccounts(ctype).size());
                Vector<Account> accounts = this.contest.getAccounts(ctype);
                allAccounts.addAll(accounts);
                for (int i = 0; i < accounts.size(); ++i) {
                    Account account = accounts.elementAt(i);
                    log.println("   " + account + " Site " + account.getClientId().getSiteNumber() + " id=" + account.getElementId());
                }
            }
            Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
            Arrays.sort(accountList, new AccountComparator());
            log.println();
            log.println("-- " + accountList.length + " Accounts --");
            for (int i = 0; i < accountList.length; ++i) {
                Account account = accountList[i];
                log.println("   " + account + " Site " + account.getClientId().getSiteNumber() + " id=" + account.getElementId());
            }
            log.println();
            log.println("-- " + this.contest.getSites().length + " sites --");
            Site[] sites = this.contest.getSites();
            Arrays.sort(sites, new SiteComparatorBySiteNumber());
            for (Site site : sites) {
                String hostName = site.getConnectionInfo().getProperty("IP_KEY");
                String portStr = site.getConnectionInfo().getProperty("PORT_KEY");
                log.println("Site " + site.getSiteNumber() + " " + hostName + ":" + portStr + " " + site.getDisplayName() + "/" + site.getPassword() + " id=" + site.getElementId());
            }
            log.println();
            log.println("-- " + this.contest.getProblems().length + " problems --");
            for (IElementObject iElementObject : this.contest.getProblems()) {
                log.println("  Problem " + iElementObject + " id=" + ((Problem)iElementObject).getElementId());
            }
            log.println();
            log.println("-- " + this.contest.getLanguages().length + " languages --");
            for (IElementObject iElementObject : this.contest.getLanguages()) {
                log.println("  Language " + iElementObject + " id=" + ((Language)iElementObject).getElementId());
            }
            log.println();
            Run[] runs = this.contest.getRuns();
            Arrays.sort(runs, new RunComparator());
            log.println("-- " + runs.length + " runs --");
            Run[] arr$ = runs;
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_23 < len$) {
                Run run = arr$[var9_23];
                log.println("  Run " + run);
                ++var9_23;
            }
            log.println();
            Clarification[] clarifications = this.contest.getClarifications();
            Arrays.sort(clarifications, new ClarificationComparator());
            log.println("-- " + clarifications.length + " clarifications --");
            for (Clarification clarification : clarifications) {
                log.println("  " + clarification);
            }
            log.println();
            ContestTime[] contestTimes = this.contest.getContestTimes();
            Arrays.sort(contestTimes, new ContestTimeComparator());
            log.println("-- " + contestTimes.length + " Contest Times --");
            for (ContestTime contestTime : contestTimes) {
                if (this.contest.getSiteNumber() == contestTime.getSiteNumber()) {
                    log.print("  * ");
                } else {
                    log.print("    ");
                }
                String state = "STOPPED";
                if (contestTime.isContestRunning()) {
                    state = "STARTED";
                }
                log.println("  Site " + contestTime.getSiteNumber() + " " + state + " " + contestTime.getElapsedTimeStr() + " " + contestTime.getRemainingTimeStr() + " " + contestTime.getContestLengthStr());
            }
            log.println();
            log.println("-- Logins -- ");
            for (ClientType.Type type : ClientType.Type.values()) {
                ClientId[] clientIds = this.contest.getAllLoggedInClients(type);
                if (clientIds.length <= 0) continue;
                log.println("Logged in " + type.toString());
                for (ClientId clientId : clientIds) {
                    ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                    log.println("   " + clientId + " on " + connectionHandlerID);
                }
            }
            log.println();
            ConnectionHandlerID[] connectionHandlerIDArray = this.contest.getConnectionHandleIDs();
            log.println("-- " + connectionHandlerIDArray.length + " Connections --");
            ConnectionHandlerID[] arr$2 = connectionHandlerIDArray;
            int len$2 = arr$2.length;
            boolean bl2 = false;
            while (var12_37 < len$2) {
                ConnectionHandlerID connectionHandlerID = arr$2[var12_37];
                log.println("  " + connectionHandlerID);
                ++var12_37;
            }
            log.println();
            log.println("*end*");
            log.close();
            log = null;
            return filename;
        }
        catch (Exception e) {
            StaticLog.log("Exception logged ", e);
            e.printStackTrace();
            return null;
        }
    }

    public String getEditorNameFullPath() {
        return this.editorNameFullPath;
    }

    public void setEditorNameFullPath(String editorNameFullPath) {
        this.editorNameFullPath = editorNameFullPath;
    }
}

