/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.exception.ClarificationUnavailableException;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.exception.ProfileCloneException;
import edu.csus.ecs.pc2.core.exception.RunUnavailableException;
import edu.csus.ecs.pc2.core.exception.UnableToUncheckoutRunException;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IChangePasswordListener;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IClientSettingsListener;
import edu.csus.ecs.pc2.core.model.IConnectionListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IMessageListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileChangeStatus;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.ISecurityMessageListener;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IInternalContest {
    public String getContestPassword();

    public void setContestPassword(String var1);

    public void addLanguage(Language var1);

    public void deleteLanguage(Language var1);

    public void addProblem(Problem var1);

    public void addProblem(Problem var1, ProblemDataFiles var2);

    public void deleteProblem(Problem var1);

    public void addContestTime(ContestTime var1);

    public void addJudgement(Judgement var1);

    public void addGroup(Group var1);

    public void setJudgementList(Judgement[] var1);

    public void removeJudgement(Judgement var1);

    public void removeGroup(Group var1);

    public void addSite(Site var1);

    public void connectionEstablished(ConnectionHandlerID var1);

    public void connectionEstablished(ConnectionHandlerID var1, Date var2);

    public void connectionDropped(ConnectionHandlerID var1);

    public void updateSite(Site var1);

    public void updateSiteStatus(Site var1, Profile var2, ProfileChangeStatus.Status var3);

    public void updateLanguage(Language var1);

    public void updateProblem(Problem var1);

    public void updateProblem(Problem var1, ProblemDataFiles var2);

    public void updateBalloonSettings(BalloonSettings var1);

    public ProblemDataFiles getProblemDataFile(Problem var1);

    public ProblemDataFiles[] getProblemDataFiles();

    public void updateContestTime(ContestTime var1, int var2);

    public void addAccount(Account var1);

    public void addBalloonSettings(BalloonSettings var1);

    public void updateContestTime(ContestTime var1);

    public void updateJudgement(Judgement var1);

    public void updateGroup(Group var1);

    public void changeSite(Site var1);

    public void updateAccount(Account var1);

    public void startContest(int var1);

    public void stopContest(int var1);

    public Run acceptRun(Run var1, RunFiles var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addRun(Run var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addRun(Run var1, RunFiles var2, ClientId var3) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addRun(Run var1, RunFiles var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public Vector<Account> generateNewAccounts(String var1, int var2, boolean var3);

    public Vector<Account> generateNewAccounts(String var1, int var2, int var3, boolean var4);

    public void generateNewSites(int var1, boolean var2);

    public void addAccountListener(IAccountListener var1);

    public void removeAccountListener(IAccountListener var1);

    public void removeBalloonSettingsListener(IBalloonSettingsListener var1);

    public Group[] getGroups();

    public Problem[] getProblems();

    public Judgement[] getJudgements();

    public Site[] getSites();

    public Language[] getLanguages();

    public String getTitle();

    public ClientId getClientId();

    public void addRunListener(IRunListener var1);

    public void removeRunListener(IRunListener var1);

    public void addClarificationListener(IClarificationListener var1);

    public void removeClarificationListener(IClarificationListener var1);

    public void addProblemListener(IProblemListener var1);

    public void removeProblemListener(IProblemListener var1);

    public void addLanguageListener(ILanguageListener var1);

    public void removeLanguageListener(ILanguageListener var1);

    public void addChangePasswordListener(IChangePasswordListener var1);

    public void removeChangePasswordListener(IChangePasswordListener var1);

    public void addLoginListener(ILoginListener var1);

    public void removeLoginListener(ILoginListener var1);

    public void addContestTimeListener(IContestTimeListener var1);

    public void removeContestTimeListener(IContestTimeListener var1);

    public void addJudgementListener(IJudgementListener var1);

    public void removeJudgementListener(IJudgementListener var1);

    public void addMessageListener(IMessageListener var1);

    public void removeMessageListener(IMessageListener var1);

    public void addSiteListener(ISiteListener var1);

    public void removeSiteListener(ISiteListener var1);

    public void addConnectionListener(IConnectionListener var1);

    public void removeConnectionListener(IConnectionListener var1);

    public void addGroupListener(IGroupListener var1);

    public void removeGroupListener(IGroupListener var1);

    public void addProfileListener(IProfileListener var1);

    public void removeProfileListener(IProfileListener var1);

    public Run getRun(ElementId var1);

    public Account[] getAccounts();

    public Vector<Account> getAccounts(ClientType.Type var1, int var2);

    public Vector<Account> getAccounts(ClientType.Type var1);

    public BalloonSettings getBalloonSettings(int var1);

    public Site getSite(int var1);

    public boolean isValidLoginAndPassword(ClientId var1, String var2);

    public void addLogin(ClientId var1, ConnectionHandlerID var2);

    public void addLocalLogin(ClientId var1, ConnectionHandlerID var2);

    public void addRemoteLogin(ClientId var1, ConnectionHandlerID var2);

    public ClientId getLoginClientId(ConnectionHandlerID var1);

    public boolean isLocalLoggedIn(ClientId var1);

    public Date getLocalLoggedInDate(ClientId var1);

    public boolean isRemoteLoggedIn(ClientId var1);

    public boolean isLoggedIn();

    public ConnectionHandlerID getConnectionHandleID(ClientId var1);

    public ClientId getClientId(ConnectionHandlerID var1);

    public boolean isConnected(ConnectionHandlerID var1);

    public boolean isConnectedToRemoteSite(ConnectionHandlerID var1);

    public void removeLogin(ClientId var1);

    public void removeRemoteLogin(ClientId var1);

    public ConnectionHandlerID[] getConnectionHandlerIDs();

    public int getSiteNumber();

    public ContestTime getContestTime();

    public ContestTime getContestTime(int var1);

    public void setClientId(ClientId var1);

    public void setSiteNumber(int var1);

    public boolean isAllowed(Permission.Type var1);

    public boolean isAllowed(ClientId var1, Permission.Type var2);

    public ClientId[] getAllLoggedInClients(ClientType.Type var1);

    public ClientId[] getLocalLoggedInClients(ClientType.Type var1);

    public ClientId[] getRemoteLoggedInClients(ClientType.Type var1);

    public void loginDenied(ClientId var1, ConnectionHandlerID var2, String var3);

    public void initializeStartupData(int var1);

    public void initializeSubmissions(int var1);

    public Run[] getRuns();

    public void runUpdated(Run var1, JudgementRecord var2, RunResultFiles var3, ClientId var4) throws IOException, ClassNotFoundException, FileSecurityException;

    public void updateRunStatus(Run var1, RunExecutionStatus var2, ClientId var3);

    public void runNotAvailable(Run var1);

    public Run checkoutRun(Run var1, ClientId var2, boolean var3, boolean var4) throws RunUnavailableException, IOException, ClassNotFoundException, FileSecurityException;

    public void updateRun(Run var1, ClientId var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public void updateRun(Run var1, RunFiles var2, ClientId var3, RunResultFiles[] var4) throws IOException, ClassNotFoundException, FileSecurityException;

    public RunFiles getRunFiles(Run var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public RunResultFiles[] getRunResultFiles(Run var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addRunJudgement(Run var1, JudgementRecord var2, RunResultFiles var3, ClientId var4) throws IOException, ClassNotFoundException, FileSecurityException;

    public void cancelRunCheckOut(Run var1, ClientId var2) throws UnableToUncheckoutRunException, IOException, ClassNotFoundException, FileSecurityException;

    public ClientId getRunCheckedOutBy(Run var1);

    public ElementId[] getRunIdsCheckedOutBy(ClientId var1);

    public void availableRun(Run var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public Clarification getClarification(ElementId var1);

    public Clarification[] getClarifications();

    public void addClarification(Clarification var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addClarification(Clarification var1, ClientId var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public Clarification acceptClarification(Clarification var1);

    public void answerClarification(Clarification var1, String var2, ClientId var3, boolean var4);

    public void updateClarification(Clarification var1, ClientId var2);

    public void removeClarification(Clarification var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public void changeClarification(Clarification var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public Clarification checkoutClarification(Clarification var1, ClientId var2) throws ClarificationUnavailableException, IOException, ClassNotFoundException, FileSecurityException;

    public void clarificationNotAvailable(Clarification var1);

    public Language getLanguage(ElementId var1);

    public Problem getProblem(ElementId var1);

    public Judgement getJudgement(ElementId var1);

    public Account getAccount(ClientId var1);

    public Group getGroup(ElementId var1);

    public ContestTime[] getContestTimes();

    public ConnectionHandlerID[] getConnectionHandleIDs();

    public ContestTime getContestTime(ElementId var1);

    public Clarification[] getClarifications(ClientId var1);

    public Run[] getRuns(ClientId var1);

    public void cancelClarificationCheckOut(Clarification var1, ClientId var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addClientSettings(ClientSettings var1);

    public void updateClientSettings(ClientSettings var1);

    public void addClientSettingsListener(IClientSettingsListener var1);

    public void removeClientSettingsListener(IClientSettingsListener var1);

    public void addContestInformation(ContestInformation var1);

    public void updateContestInformation(ContestInformation var1);

    public void addContestInformationListener(IContestInformationListener var1);

    public void removeContestInformationListener(IContestInformationListener var1);

    public ContestInformation getContestInformation();

    public ClientSettings getClientSettings();

    public ClientSettings getClientSettings(ClientId var1);

    public ClientSettings[] getClientSettingsList();

    public int getMaxRetryMSecs();

    public int getMaxConnectionRetries();

    public BalloonSettings[] getBalloonSettings();

    public BalloonSettings getBalloonSettings(ElementId var1);

    public void addBalloonSettingsListener(IBalloonSettingsListener var1);

    public void setGeneralProblem(Problem var1);

    public Problem getGeneralProblem();

    public void addAccounts(Account[] var1);

    public void updateAccounts(Account[] var1);

    public Log getSecurityAlertLog();

    public void newSecurityMessage(ClientId var1, String var2, String var3, ContestSecurityException var4);

    public void addSecurityMessageListener(ISecurityMessageListener var1);

    public void removeSecurityMessageListener(ISecurityMessageListener var1);

    public void passwordChanged(boolean var1, ClientId var2, String var3);

    public void resetSubmissionData();

    public void resetConfigurationData();

    public boolean isSendAdditionalRunStatusMessages();

    public boolean contestIdMatches(String var1);

    public String getContestIdentifier();

    public void setContestIdentifier(String var1);

    public void setProfile(Profile var1);

    public Profile getProfile();

    public Profile getProfile(ElementId var1);

    public Profile[] getProfiles();

    public Profile addProfile(Profile var1);

    public Profile updateProfile(Profile var1);

    public void deleteProfile(Profile var1);

    public boolean storeConfiguration(Log var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public void setStorage(IStorage var1);

    public IStorage getStorage();

    public boolean readConfiguration(int var1, Log var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public IInternalContest clone(IInternalContest var1, Profile var2, ProfileCloneSettings var3) throws ProfileCloneException;

    public ProfileCloneSettings getProfileCloneSettings();

    public ProfileCloneSettings setProfileCloneSettings(ProfileCloneSettings var1);

    public void cloneClarifications(IInternalContest var1, Profile var2) throws ProfileCloneException;

    public void cloneRunsAndRunFiles(IInternalContest var1, Profile var2) throws ProfileCloneException;

    public void removeAllListeners();

    public void fireAllRefreshEvents();

    public void cloneAllLoginAndConnections(IInternalContest var1);

    public boolean isRunFilesPresent(Run var1) throws IOException, ClassNotFoundException, FileSecurityException;

    public void addMessage(MessageEvent.Area var1, ClientId var2, ClientId var3, String var4);

    public void updateRunFiles(Run var1, RunFiles var2) throws IOException, ClassNotFoundException, FileSecurityException;

    public FinalizeData getFinalizeData();

    public void setFinalizeData(FinalizeData var1);
}

