/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class Group
implements IElementObject {
    private static final long serialVersionUID = -9039235537777735642L;
    public static final String SVN_ID = "$Id: Group.java 2049 2010-03-17 15:37:45Z laned $";
    private ElementId elementId;
    private int groupId;
    private String displayName;
    private ElementId site;
    private boolean displayOnScoreboard = true;

    public ElementId getElementId() {
        return this.elementId;
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String groupTitle) {
        this.displayName = groupTitle;
    }

    public ElementId getSite() {
        return this.site;
    }

    public void setSite(ElementId site) {
        this.site = site;
    }

    public String toString() {
        return this.displayName;
    }

    public Group(String displayName) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    public boolean isDisplayOnScoreboard() {
        return this.displayOnScoreboard;
    }

    public void setDisplayOnScoreboard(boolean displayOnScoreboard) {
        this.displayOnScoreboard = displayOnScoreboard;
    }

    private boolean stringSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public boolean isSameAs(Group newGroup) {
        try {
            if (newGroup == null) {
                return false;
            }
            if (!this.stringSame(this.displayName, newGroup.getDisplayName())) {
                return false;
            }
            if (this.getSiteNumber() != newGroup.getSiteNumber()) {
                return false;
            }
            if (this.groupId != newGroup.getGroupId()) {
                return false;
            }
            if (this.isDisplayOnScoreboard() != newGroup.isDisplayOnScoreboard()) {
                return false;
            }
            return !(this.site != null && newGroup.getSite() != null ? !newGroup.getSite().equals(this.site) : newGroup.getSite() != null || this.site != null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

