/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Filter
implements Serializable {
    private static final long serialVersionUID = -8373119928926075959L;
    private Hashtable<Run.RunStates, Date> runStateHash = new Hashtable();
    private boolean filteringRunStates = false;
    private boolean filteringElapsedTime = false;
    private long startElapsedTime = -1L;
    private long endElapsedTime = -1L;
    private Hashtable<Clarification.ClarificationStates, Date> clarificationStateHash = new Hashtable();
    private boolean filteringClarificationStates = false;
    private Hashtable<ElementId, Date> problemIdHash = new Hashtable();
    private boolean filteringProblems = false;
    private Hashtable<Permission.Type, Date> permissionsHash = new Hashtable();
    private boolean filteringPermissions = false;
    private Hashtable<ElementId, Date> languageIdHash = new Hashtable();
    private Hashtable<Integer, Date> siteIdHash = new Hashtable();
    private boolean filteringLanguages = false;
    private boolean filteringSites = false;
    private Hashtable<ElementId, Date> judgementIdHash = new Hashtable();
    private boolean filteringJudgements = false;
    private Hashtable<ClientId, Date> clientIdHash = new Hashtable();
    private Hashtable<ClientType.Type, Date> clientTypeHash = new Hashtable();
    private boolean filteringAccounts = false;
    private boolean thisSiteOnly;
    private int filterSiteNumber = 0;
    private boolean filterEnabled = true;

    private ElementId getJudgementId(Run run) {
        JudgementRecord judgementRecord = run.getJudgementRecord();
        if (judgementRecord != null) {
            return judgementRecord.getJudgementId();
        }
        return null;
    }

    public boolean matches(Run run) {
        if (this.filterEnabled) {
            ElementId judgementElementId = this.getJudgementId(run);
            return this.matchesSites(run) && this.matchesAccount(run.getSubmitter()) && this.matchesRunState(run.getStatus()) && this.matchesProblem(run.getProblemId()) && this.matchesLanguage(run.getLanguageId()) && this.matchesJudgement(judgementElementId) && this.matchesElapsedTimeSubmission(run);
        }
        return true;
    }

    public boolean matches(Clarification clarification) {
        if (this.filterEnabled) {
            return this.matchesSites(clarification) && this.matchesAccount(clarification.getSubmitter()) && this.matchesClarificationState(clarification.getState()) && this.matchesProblem(clarification.getProblemId()) && this.matchesLanguage(clarification.getLanguageId()) && this.matchesElapsedTimeSubmission(clarification);
        }
        return true;
    }

    public boolean matches(ClientId clientId) {
        if (this.filterEnabled) {
            return this.matchesSites(clientId) && this.matchesAccount(clientId);
        }
        return true;
    }

    public boolean matchesSites(ClientId clientId) {
        return this.matchesSites(clientId.getSiteNumber());
    }

    public boolean isThisSiteOnly() {
        return this.thisSiteOnly;
    }

    public void setThisSiteOnly(boolean thisSiteOnly) {
        this.thisSiteOnly = thisSiteOnly;
    }

    public void setSiteNumber(int siteNumber) {
        this.filterSiteNumber = siteNumber;
    }

    public int getSiteNumber() {
        return this.filterSiteNumber;
    }

    public void setUsingJudgementFilter(boolean turnOn) {
        this.filteringJudgements = turnOn;
    }

    public boolean isFilteringJudgements() {
        return this.filteringJudgements;
    }

    public void addJudgement(Judgement judgement) {
        this.addJudgement(judgement.getElementId());
    }

    private void addJudgement(ElementId elementId) {
        this.filteringJudgements = true;
        this.judgementIdHash.put(elementId, new Date());
    }

    public boolean matches(Judgement judgement) {
        return this.matchesJudgement(judgement.getElementId());
    }

    public boolean matchesJudgement(Judgement judgement) {
        return this.matchesJudgement(judgement.getElementId());
    }

    public boolean matchesJudgement(ElementId judgementId) {
        if (this.filteringJudgements) {
            if (judgementId == null) {
                return false;
            }
            return this.judgementIdHash.containsKey(judgementId);
        }
        return true;
    }

    public void setUsingProblemFilter(boolean turnOn) {
        this.filteringProblems = turnOn;
    }

    public boolean isFilteringProblems() {
        return this.filteringProblems;
    }

    public void addProblem(Problem problem) {
        this.addProblem(problem.getElementId());
    }

    private void addProblem(ElementId elementId) {
        this.problemIdHash.put(elementId, new Date());
        this.filteringProblems = true;
    }

    public void addPermission(Permission.Type type) {
        this.permissionsHash.put(type, new Date());
        this.filteringPermissions = true;
    }

    public boolean matchesProblem(Problem problem) {
        return this.matches(problem);
    }

    public boolean matches(Problem problem) {
        return this.matchesProblem(problem.getElementId());
    }

    public boolean matchesProblem(ElementId problemId) {
        if (this.filteringProblems) {
            return this.problemIdHash.containsKey(problemId);
        }
        return true;
    }

    public boolean matches(Permission.Type type) {
        if (this.filteringPermissions) {
            return this.permissionsHash.containsKey((Object)type);
        }
        return true;
    }

    public void setUsingPermissionFilter(boolean turnOn) {
        this.filteringPermissions = turnOn;
    }

    public void setUsingLanguageFilter(boolean turnOn) {
        this.filteringLanguages = turnOn;
    }

    public void setUsingSitesFilter(boolean turnOn) {
        this.filteringSites = turnOn;
    }

    public boolean isFilteringSites() {
        return this.filteringSites;
    }

    public boolean isFilteringPermissions() {
        return this.filteringPermissions;
    }

    public boolean isFilteringLanguages() {
        return this.filteringLanguages;
    }

    public void addLanguage(Language language) {
        this.addLanguage(language.getElementId());
    }

    private void addLanguage(ElementId elementId) {
        this.languageIdHash.put(elementId, new Date());
        this.filteringLanguages = true;
    }

    public boolean matchesLanguage(Language language) {
        return this.matchesLanguage(language.getElementId());
    }

    public boolean matches(Language language) {
        return this.matchesLanguage(language.getElementId());
    }

    public boolean matchesLanguage(ElementId languageId) {
        if (this.filteringLanguages) {
            return this.languageIdHash.containsKey(languageId);
        }
        return true;
    }

    public void addSite(Site site) {
        this.addSite(site.getSiteNumber());
    }

    public void addSite(int siteNumber) {
        this.siteIdHash.put(new Integer(siteNumber), new Date());
        this.filteringSites = true;
    }

    private boolean matchesSites(ISubmission submission) {
        return this.matchesSites(submission.getSiteNumber());
    }

    private boolean matchesSites(int siteNumber) {
        if (this.filteringSites) {
            return this.siteIdHash.containsKey(new Integer(siteNumber));
        }
        return true;
    }

    public boolean matchesSite(Site site) {
        return this.matches(site);
    }

    public boolean matches(Site site) {
        return this.matchesSites(site.getSiteNumber());
    }

    public boolean matchesAccount(Account account) {
        return this.matches(account);
    }

    public boolean matches(Account account) {
        ClientId clientId = account.getClientId();
        if (!this.matchesSites(clientId.getSiteNumber())) {
            return false;
        }
        if (!this.matchesPermission(account)) {
            return false;
        }
        if (this.filteringAccounts) {
            if (this.matches(clientId)) {
                return this.matches(clientId.getClientType());
            }
            return false;
        }
        return true;
    }

    public Permission.Type[] getPermissionsList() {
        Permission.Type[] permList = new Permission.Type[this.permissionsHash.size()];
        Enumeration<Permission.Type> enumeration = this.permissionsHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            Permission.Type element;
            permList[i] = element = enumeration.nextElement();
            ++i;
        }
        return permList;
    }

    private boolean matchesPermission(Account account) {
        if (this.filteringPermissions) {
            Enumeration<Permission.Type> enumeration = this.permissionsHash.keys();
            while (enumeration.hasMoreElements()) {
                Permission.Type type = enumeration.nextElement();
                if (account.isAllowed(type)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean matches(ClientType.Type type) {
        if (this.filteringAccounts) {
            if (this.clientTypeHash.size() == 0) {
                return true;
            }
            if (this.clientTypeHash.containsKey((Object)ClientType.Type.ALL)) {
                return true;
            }
            return this.clientTypeHash.containsKey((Object)type);
        }
        return false;
    }

    public boolean matchesAccount(ClientId clientId) {
        if (this.filteringAccounts) {
            if (this.matchesSites(clientId)) {
                if (this.clientIdHash.size() == 0) {
                    return true;
                }
                return this.clientIdHash.containsKey(clientId);
            }
            return false;
        }
        return this.matchesSites(clientId);
    }

    public void clearJudgementList() {
        this.filteringJudgements = false;
        this.judgementIdHash = new Hashtable();
    }

    public void clearAccountList() {
        this.filteringAccounts = false;
        this.clientIdHash = new Hashtable();
    }

    public void clearClientTypesList() {
        this.clientTypeHash = new Hashtable();
    }

    public void clearProblemList() {
        this.filteringProblems = false;
        this.problemIdHash = new Hashtable();
    }

    public void clearPermissionsList() {
        this.permissionsHash = new Hashtable();
    }

    public void clearLanguageList() {
        this.filteringLanguages = false;
        this.languageIdHash = new Hashtable();
    }

    public void clearSiteList() {
        this.filteringSites = false;
        this.siteIdHash = new Hashtable();
    }

    public void removeSite(Site site) {
        if (this.siteIdHash.containsKey(site.getElementId())) {
            this.siteIdHash.remove(site.getElementId());
        }
    }

    public void removeProblem(Problem problem) {
        if (this.problemIdHash.containsKey(problem.getElementId())) {
            this.problemIdHash.remove(problem.getElementId());
        }
    }

    public void removePermission(Permission.Type type) {
        if (this.permissionsHash.containsKey((Object)type)) {
            this.permissionsHash.remove((Object)type);
        }
    }

    public void removeLanguage(Language language) {
        if (this.languageIdHash.containsKey(language.getElementId())) {
            this.languageIdHash.remove(language.getElementId());
        }
    }

    public void removePermission(Permission type) {
        if (this.permissionsHash.containsKey(type)) {
            this.permissionsHash.remove(type);
        }
    }

    public ElementId[] getJudgementIdList() {
        ElementId[] elementIds = new ElementId[this.judgementIdHash.size()];
        Enumeration<ElementId> enumeration = this.judgementIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ElementId element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public ElementId[] getProblemIdList() {
        ElementId[] elementIds = new ElementId[this.problemIdHash.size()];
        Enumeration<ElementId> enumeration = this.problemIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ElementId element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public ElementId[] getLanguageIdList() {
        ElementId[] elementIds = new ElementId[this.languageIdHash.size()];
        Enumeration<ElementId> enumeration = this.languageIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ElementId element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public Integer[] getSiteIdList() {
        Integer[] elementIds = new Integer[this.siteIdHash.size()];
        Enumeration<Integer> enumeration = this.siteIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            Integer element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public ClientId[] getAccountList() {
        ClientId[] clientIds = new ClientId[this.clientIdHash.size()];
        Enumeration<ClientId> enumeration = this.clientIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ClientId element;
            clientIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return clientIds;
    }

    public ClientType.Type[] getClientTypes() {
        ClientType.Type[] types = new ClientType.Type[this.clientTypeHash.size()];
        Enumeration<ClientType.Type> enumeration = this.clientTypeHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ClientType.Type value;
            types[i] = value = enumeration.nextElement();
            ++i;
        }
        return types;
    }

    public void setUsingRunStatesFilter(boolean turnOn) {
        this.filteringRunStates = turnOn;
    }

    public boolean isFilteringRunStates() {
        return this.filteringRunStates;
    }

    public void addAccount(Account account) {
        this.addAccount(account.getClientId());
    }

    public void addAccount(ClientId clientId) {
        this.filteringAccounts = true;
        this.clientIdHash.put(clientId, new Date());
    }

    public void addAccounts(Account[] accounts) {
        for (Account account : accounts) {
            this.addAccount(account);
        }
    }

    public void removeAccount(Account account) {
        if (this.clientIdHash.get(account.getClientId()) != null) {
            this.clientIdHash.remove(account.getClientId());
        }
    }

    public void removeAccounts(Account[] accounts) {
        for (Account account : accounts) {
            this.removeAccount(account);
        }
    }

    public void addClientType(ClientType.Type type) {
        this.filteringAccounts = true;
        this.clientTypeHash.put(type, new Date());
    }

    public void addRunState(Run.RunStates runStates) {
        this.runStateHash.put(runStates, new Date());
        this.filteringRunStates = true;
    }

    public boolean matchesRunState(Run.RunStates runStates) {
        return this.matches(runStates);
    }

    public boolean matches(Run.RunStates runStates) {
        if (this.filteringRunStates) {
            return this.runStateHash.containsKey((Object)runStates);
        }
        return true;
    }

    public boolean matchesElapsedTime(Run run) {
        return this.matchesElapsedTimeSubmission(run);
    }

    public boolean matchesElapsedTime(Clarification clarification) {
        return this.matchesElapsedTimeSubmission(clarification);
    }

    protected boolean matchesElapsedTimeSubmission(ISubmission submission) {
        if (this.filteringElapsedTime) {
            long elapsedTime = submission.getElapsedMins();
            if (this.startElapsedTime != -1L && elapsedTime < this.startElapsedTime) {
                return false;
            }
            return this.endElapsedTime == -1L || elapsedTime <= this.endElapsedTime;
        }
        return true;
    }

    public void clearRunStatesList() {
        this.filteringRunStates = false;
        this.runStateHash = new Hashtable();
    }

    public void removeRunState(Run.RunStates runStates) {
        if (this.runStateHash.containsKey((Object)runStates)) {
            this.runStateHash.remove((Object)runStates);
        }
    }

    public void removeClarificationStates(Clarification.ClarificationStates clarificationStates) {
        if (this.clarificationStateHash.containsKey((Object)clarificationStates)) {
            this.clarificationStateHash.remove((Object)clarificationStates);
        }
    }

    public Clarification.ClarificationStates[] getClarificationStatesList() {
        Clarification.ClarificationStates[] clarificationStates = new Clarification.ClarificationStates[this.clarificationStateHash.size()];
        Enumeration<Clarification.ClarificationStates> enumeration = this.clarificationStateHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            clarificationStates[i] = enumeration.nextElement();
            ++i;
        }
        return clarificationStates;
    }

    public Run.RunStates[] getRunStates() {
        Run.RunStates[] runStates = new Run.RunStates[this.runStateHash.size()];
        Enumeration<Run.RunStates> enumeration = this.runStateHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            runStates[i] = enumeration.nextElement();
            ++i;
        }
        return runStates;
    }

    public boolean matchesClarificationState(Clarification.ClarificationStates clarificationStates) {
        return this.matches(clarificationStates);
    }

    public boolean matches(Clarification.ClarificationStates clarificationStates) {
        if (this.filteringClarificationStates) {
            return this.clarificationStateHash.containsKey((Object)clarificationStates);
        }
        return true;
    }

    public void addClarificationState(Clarification.ClarificationStates clarificationStates) {
        this.clarificationStateHash.put(clarificationStates, new Date());
        this.filteringClarificationStates = true;
    }

    public void clearClarificationStateList() {
        this.filteringClarificationStates = false;
        this.clarificationStateHash = new Hashtable();
    }

    public String toString() {
        if (this.filterEnabled) {
            String filterInfo = "Filter ON";
            if (this.thisSiteOnly || this.filteringSites) {
                filterInfo = filterInfo + " Site(s) ";
            }
            if (this.filteringProblems) {
                filterInfo = filterInfo + " problem(s) ";
            }
            if (this.filteringJudgements) {
                filterInfo = filterInfo + " judgement(s) ";
            }
            if (this.filteringLanguages) {
                filterInfo = filterInfo + " language(s) ";
            }
            if (this.filteringRunStates) {
                filterInfo = filterInfo + " run state(s)";
            }
            if (this.filteringClarificationStates) {
                filterInfo = filterInfo + " clar state(s)";
            }
            if (this.filteringAccounts) {
                filterInfo = filterInfo + " account(s))";
            }
            if (this.filteringPermissions) {
                filterInfo = filterInfo + " permissions(s))";
            }
            return filterInfo;
        }
        return "";
    }

    public long getStartElapsedTime() {
        return this.startElapsedTime;
    }

    public void setStartElapsedTime(long startElapsedTime) {
        this.filteringElapsedTime = true;
        this.startElapsedTime = startElapsedTime;
    }

    public long getEndElapsedTime() {
        return this.endElapsedTime;
    }

    public void setEndElapsedTime(long endElapsedTime) {
        this.filteringElapsedTime = true;
        this.endElapsedTime = endElapsedTime;
    }

    public boolean isFilteringElapsedTime() {
        return this.filteringElapsedTime;
    }

    public void setFilteringElapsedTime(boolean filteringElapsedTime) {
        this.filteringElapsedTime = filteringElapsedTime;
    }

    public boolean isFilteringAccounts() {
        return this.filteringAccounts;
    }

    public void setFilteringAccounts(boolean filteringAccounts) {
        this.filteringAccounts = filteringAccounts;
    }

    public void setFilterOff() {
        this.filterEnabled = false;
    }

    public void setFilter(boolean filterOn) {
        this.filterEnabled = filterOn;
    }

    public void setFilterOn() {
        this.filterEnabled = true;
    }

    public boolean isFilterOn() {
        if (this.filterEnabled) {
            return this.filteringSites || this.filteringAccounts || this.filteringClarificationStates || this.filteringProblems || this.filteringJudgements || this.filteringLanguages || this.filteringElapsedTime || this.filteringRunStates || this.filteringPermissions || this.thisSiteOnly;
        }
        return false;
    }

    public boolean isFilteringClarificationStates() {
        return this.filteringClarificationStates;
    }

    public void clearElapsedTime() {
        this.startElapsedTime = -1L;
        this.endElapsedTime = -1L;
        this.filteringElapsedTime = false;
    }

    public int countRuns(Run[] runs) {
        int count = 0;
        for (Run run : runs) {
            if (!this.matches(run)) continue;
            ++count;
        }
        return count;
    }

    public int countClarifications(Clarification[] clarifications) {
        int count = 0;
        for (Clarification clarification : clarifications) {
            if (!this.matches(clarification)) continue;
            ++count;
        }
        return count;
    }

    public int countAccounts(Account[] accounts) {
        int count = 0;
        for (Account account : accounts) {
            if (!this.matches(account)) continue;
            ++count;
        }
        return count;
    }

    public int countClientIds(ClientId[] clientIds) {
        int count = 0;
        for (ClientId clientId : clientIds) {
            if (!this.matchesAccount(clientId)) continue;
            ++count;
        }
        return count;
    }

    public Run[] getRuns(Run[] runs) {
        Vector<Run> listOfRuns = new Vector<Run>();
        for (Run run : runs) {
            if (!this.matches(run)) continue;
            listOfRuns.add(run);
        }
        return listOfRuns.toArray(new Run[listOfRuns.size()]);
    }

    public Clarification[] getClarifications(Clarification[] clarifications) {
        Vector<Clarification> list = new Vector<Clarification>();
        for (Clarification clarification : clarifications) {
            if (!this.matches(clarification)) continue;
            list.add(clarification);
        }
        return list.toArray(new Clarification[list.size()]);
    }
}

