/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class ElementId
implements Serializable {
    private static final long serialVersionUID = -4019714577379393756L;
    private int siteNumber = 0;
    private int versionNumber = 1;
    private static Random r;
    private static long counter;
    private long num = 0L;
    private long savedCounter = 0L;
    private char[] name = null;

    public ElementId(String name) {
        this.name = name.toCharArray();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        if (this.name == null) {
            this.name = "genericElement".toCharArray();
        }
        this.num = r.nextLong();
        char[] cArray = this.name;
        synchronized (this.name) {
            this.savedCounter = counter++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return new String(this.name) + "-" + this.num;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ElementId) {
            boolean eq;
            ElementId otherId = (ElementId)obj;
            boolean bl = eq = otherId.num == this.num && this.savedCounter == otherId.savedCounter;
            if (eq) {
                eq = Arrays.equals(this.name, otherId.name);
            }
            return eq;
        }
        return false;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }

    public void incrementVersionNumber() {
        ++this.versionNumber;
    }

    static {
        counter = 0L;
        r = new Random();
        r.setSeed(System.nanoTime());
    }
}

