/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.Serializable;

public class DisplayTeamName
implements Serializable,
UIPlugin {
    private static final long serialVersionUID = 1483822798361043778L;
    private IInternalContest contest;
    private IInternalController controller;
    private ContestInformation.TeamDisplayMask teamDisplayMask = ContestInformation.TeamDisplayMask.LOGIN_NAME_ONLY;

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    public String getDisplayName(ClientId clientId) {
        return this.getDisplayName(clientId, this.teamDisplayMask);
    }

    public String getDisplayName(ClientId clientId, ContestInformation.TeamDisplayMask inTeamDisplayMask) {
        if (clientId.getClientType().equals((Object)ClientType.Type.TEAM)) {
            Account account = null;
            switch (inTeamDisplayMask) {
                case NONE: {
                    return "***";
                }
                case DISPLAY_NAME_ONLY: {
                    account = this.contest.getAccount(clientId);
                    return account.toString();
                }
                case LOGIN_NAME_ONLY: {
                    return clientId.getName();
                }
                case ALIAS: {
                    account = this.contest.getAccount(clientId);
                    if (account.getAliasName() != null && account.getAliasName().trim().length() > 0) {
                        return account.getAliasName();
                    }
                    if (this.controller != null) {
                        this.controller.getLog().log(Log.WARNING, "Alias not created for " + clientId, new Exception("No alias for team " + clientId));
                    }
                    return account.getClientId().getName() + " (not aliased)";
                }
                case NUMBERS_AND_NAME: {
                    account = this.contest.getAccount(clientId);
                    return clientId.getClientNumber() + " " + account.toString();
                }
            }
            return clientId.getName();
        }
        return clientId.getName();
    }

    public String getPluginTitle() {
        return "DisplayTeamName";
    }

    public ContestInformation.TeamDisplayMask getTeamDisplayMask() {
        return this.teamDisplayMask;
    }

    public void setTeamDisplayMask(ContestInformation.TeamDisplayMask teamDisplayMask) {
        this.teamDisplayMask = teamDisplayMask;
    }
}

