/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import java.io.Serializable;
import java.util.Properties;

public class ContestInformation
implements Serializable {
    private static final long serialVersionUID = -7333255582657988200L;
    private String contestTitle = "Programming Contest";
    private String contestURL;
    private TeamDisplayMask teamDisplayMode = TeamDisplayMask.LOGIN_NAME_ONLY;
    private String judgesDefaultAnswer = "No response, read problem statement";
    private boolean preliminaryJudgementsUsedByBoard = false;
    private boolean preliminaryJudgementsTriggerNotifications = false;
    private boolean sendAdditionalRunStatusInformation = false;
    private long maxFileSize = 512000L;
    private JudgementNotificationsList judgementNotificationsList = new JudgementNotificationsList();
    private Properties scoringProperties = new Properties();

    public String getContestTitle() {
        return this.contestTitle;
    }

    public void setContestTitle(String contestTitle) {
        this.contestTitle = contestTitle;
    }

    public String getContestURL() {
        return this.contestURL;
    }

    public void setContestURL(String contestURL) {
        this.contestURL = contestURL;
    }

    public TeamDisplayMask getTeamDisplayMode() {
        return this.teamDisplayMode;
    }

    public void setTeamDisplayMode(TeamDisplayMask teamDisplayMask) {
        this.teamDisplayMode = teamDisplayMask;
    }

    public String getJudgesDefaultAnswer() {
        return this.judgesDefaultAnswer;
    }

    public void setJudgesDefaultAnswer(String judgesDefaultAnswer) {
        if (judgesDefaultAnswer != null && judgesDefaultAnswer.trim().length() > 0) {
            this.judgesDefaultAnswer = judgesDefaultAnswer.trim();
        }
    }

    public boolean isSameAs(ContestInformation contestInformation) {
        try {
            if (this.contestTitle == null ? contestInformation.getContestTitle() != null : !this.contestTitle.equals(contestInformation.getContestTitle())) {
                return false;
            }
            if (!this.judgesDefaultAnswer.equals(contestInformation.getJudgesDefaultAnswer())) {
                return false;
            }
            if (!this.teamDisplayMode.equals((Object)contestInformation.getTeamDisplayMode())) {
                return false;
            }
            if (this.preliminaryJudgementsTriggerNotifications != contestInformation.isPreliminaryJudgementsTriggerNotifications()) {
                return false;
            }
            if (this.preliminaryJudgementsUsedByBoard != contestInformation.isPreliminaryJudgementsUsedByBoard()) {
                return false;
            }
            if (this.sendAdditionalRunStatusInformation != contestInformation.isSendAdditionalRunStatusInformation()) {
                return false;
            }
            if (this.maxFileSize != contestInformation.getMaxFileSize()) {
                return false;
            }
            return this.scoringProperties.equals(contestInformation.getScoringProperties());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setPreliminaryJudgementsUsedByBoard(boolean preliminaryJudgementsUsedByBoard) {
        this.preliminaryJudgementsUsedByBoard = preliminaryJudgementsUsedByBoard;
    }

    public boolean isPreliminaryJudgementsUsedByBoard() {
        return this.preliminaryJudgementsUsedByBoard;
    }

    public void setPreliminaryJudgementsTriggerNotifications(boolean preliminaryJudgementsTriggerNotifications) {
        this.preliminaryJudgementsTriggerNotifications = preliminaryJudgementsTriggerNotifications;
    }

    public boolean isPreliminaryJudgementsTriggerNotifications() {
        return this.preliminaryJudgementsTriggerNotifications;
    }

    public boolean isSendAdditionalRunStatusInformation() {
        return this.sendAdditionalRunStatusInformation;
    }

    public void setSendAdditionalRunStatusInformation(boolean sendAdditionalRunStatusInformation) {
        this.sendAdditionalRunStatusInformation = sendAdditionalRunStatusInformation;
    }

    public JudgementNotificationsList getJudgementNotificationsList() {
        return this.judgementNotificationsList;
    }

    public void setJudgementNotificationsList(JudgementNotificationsList judgementNotificationsList) {
        this.judgementNotificationsList = judgementNotificationsList;
    }

    public void updateJudgementNotification(NotificationSetting notificationSetting) {
        this.judgementNotificationsList.update(notificationSetting);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Properties getScoringProperties() {
        return this.scoringProperties;
    }

    public void setScoringProperties(Properties scoringProperties) {
        this.scoringProperties = scoringProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TeamDisplayMask {
        NONE,
        LOGIN_NAME_ONLY,
        DISPLAY_NAME_ONLY,
        NUMBERS_AND_NAME,
        ALIAS;

    }
}

