/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import edu.csus.ecs.pc2.profile.ProfileManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class ConfigurationIO {
    private IStorage storage = null;

    public ConfigurationIO(IStorage storage) {
        this.storage = storage;
    }

    public boolean loadFromDisk(int siteNumber, IInternalContest contest, Log log) {
        Configuration configuration = new Configuration(this.storage);
        try {
            if (configuration.loadFromDisk(this.getFileName())) {
                ConfigKeys key = ConfigKeys.SITE_NUMBER;
                if (configuration.containsKey(key)) {
                    Integer diskSiteNumber = (Integer)configuration.get(key.toString());
                    if (diskSiteNumber != siteNumber) {
                        Exception exception = new Exception("FATAL ERROR Attempted to load site " + siteNumber + " from Site " + diskSiteNumber);
                        System.err.println(exception.getMessage());
                        log.log(Log.SEVERE, exception.getMessage(), exception);
                        System.exit(22);
                    }
                    contest.setSiteNumber(diskSiteNumber);
                    log.info("Loading site number " + diskSiteNumber);
                } else {
                    System.err.println("WARNING Attempted to load site " + siteNumber + " but key " + (Object)((Object)ConfigKeys.SITE_NUMBER) + " not found");
                    log.info("WARNING Attempted to load site " + siteNumber + " but key " + (Object)((Object)ConfigKeys.SITE_NUMBER) + " not found");
                }
                try {
                    key = ConfigKeys.LANGUAGES;
                    if (configuration.containsKey(key)) {
                        Language[] languages = (Language[])configuration.get(key.toString());
                        for (IElementObject iElementObject : languages) {
                            contest.addLanguage((Language)iElementObject);
                        }
                        log.info("Loaded " + languages.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading languages ", e);
                }
                try {
                    key = ConfigKeys.PROBLEMS;
                    if (configuration.containsKey(key)) {
                        Problem[] problems = (Problem[])configuration.get(key.toString());
                        for (IElementObject iElementObject : problems) {
                            contest.addProblem((Problem)iElementObject);
                        }
                        log.info("Loaded " + problems.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading problems ", e);
                }
                try {
                    key = ConfigKeys.CONTEST_TIME_LIST;
                    if (configuration.containsKey(key)) {
                        ContestTime[] contestTimes = (ContestTime[])configuration.get(key.toString());
                        for (IElementObject iElementObject : contestTimes) {
                            contest.addContestTime((ContestTime)iElementObject);
                        }
                        log.info("Loaded " + contestTimes.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading contest times ", e);
                }
                try {
                    key = ConfigKeys.ACCOUNTS;
                    if (configuration.containsKey(key)) {
                        Account[] accounts = (Account[])configuration.get(key.toString());
                        for (IElementObject iElementObject : accounts) {
                            contest.addAccount((Account)iElementObject);
                        }
                        log.info("Loaded " + accounts.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading accounts ", e);
                }
                try {
                    key = ConfigKeys.JUDGEMENTS;
                    if (configuration.containsKey(key)) {
                        Judgement[] judgements = (Judgement[])configuration.get(key.toString());
                        for (IElementObject iElementObject : judgements) {
                            contest.addJudgement((Judgement)iElementObject);
                        }
                        log.info("Loaded " + judgements.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading judgements ", e);
                }
                this.loadProblemDataFilesInfo(contest, configuration, log);
                this.loadSomeSettings(configuration, contest, log);
                return true;
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info("No configuration file exists " + this.getFileName());
            return false;
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Loading configuration from disk", e);
            return false;
        }
    }

    private void loadSomeSettings(Configuration configuration, IInternalContest contest, Logger log) {
        ConfigKeys key;
        try {
            key = ConfigKeys.BALLOON_SETTINGS_LIST;
            if (configuration.containsKey(key)) {
                BalloonSettings[] balloonSettings = (BalloonSettings[])configuration.get(key.toString());
                for (BalloonSettings balloonSettings2 : balloonSettings) {
                    contest.addBalloonSettings(balloonSettings2);
                }
                log.info("Loaded " + balloonSettings.length + " " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading balloon settings ", e);
        }
        try {
            key = ConfigKeys.CONTEST_TIME;
            if (configuration.containsKey(key)) {
                ContestTime contestTime = (ContestTime)configuration.get(key.toString());
                contest.updateContestTime(contestTime);
                log.info("Loaded " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading contest time ", e);
        }
        try {
            key = ConfigKeys.GENERAL_PROBLEM;
            if (configuration.containsKey(key)) {
                Problem genProblem = (Problem)configuration.get(key.toString());
                contest.setGeneralProblem(genProblem);
                log.info("Loaded " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading general problem ", e);
        }
        try {
            key = ConfigKeys.PROFILES;
            if (configuration.containsKey(key)) {
                Profile[] profiles = (Profile[])configuration.get(key.toString());
                for (IElementObject iElementObject : profiles) {
                    contest.addProfile((Profile)iElementObject);
                }
                log.info("Loaded " + profiles.length + " " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading profiles ", e);
        }
        try {
            key = ConfigKeys.FINALIZE_DATA;
            if (configuration.containsKey(key)) {
                FinalizeData finalizeData = (FinalizeData)configuration.get(key.toString());
                contest.setFinalizeData(finalizeData);
                log.info("Loaded " + finalizeData + " " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading Finalize Data ", e);
        }
        try {
            Profile profile;
            key = ConfigKeys.PROFILE;
            if (configuration.containsKey(key)) {
                profile = (Profile)configuration.get(key.toString());
                contest.setProfile(profile);
                log.info("Loaded " + key.toString().toLowerCase());
            } else {
                profile = ProfileManager.createNewProfile();
                contest.setProfile(profile);
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading current profile ", e);
        }
        try {
            key = ConfigKeys.PROFILE_CLONE_SETTINGS;
            if (configuration.containsKey(key)) {
                ProfileCloneSettings profileCloneSettings = (ProfileCloneSettings)configuration.get(key.toString());
                contest.setProfileCloneSettings(profileCloneSettings);
                log.info("Loaded " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading profile clone settings ", e);
        }
        try {
            key = ConfigKeys.SITES;
            if (configuration.containsKey(key)) {
                Site[] sites = (Site[])configuration.get(key.toString());
                for (IElementObject iElementObject : sites) {
                    contest.addSite((Site)iElementObject);
                }
                log.info("Loaded " + sites.length + " " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading sites ", e);
        }
        try {
            key = ConfigKeys.CONTEST_INFORMATION;
            if (configuration.containsKey(key)) {
                ContestInformation contestInformation = (ContestInformation)configuration.get(key.toString());
                contest.addContestInformation(contestInformation);
                log.info("Loaded Contest Information " + contestInformation.getContestTitle());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading contest information/title ", e);
        }
        try {
            key = ConfigKeys.CLIENT_SETTINGS_LIST;
            if (configuration.containsKey(key)) {
                ClientSettings[] clientSettingsList = (ClientSettings[])configuration.get(key.toString());
                for (IElementObject iElementObject : clientSettingsList) {
                    contest.addClientSettings((ClientSettings)iElementObject);
                }
                log.info("Loaded " + clientSettingsList.length + " " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while updating client settings ", e);
        }
        try {
            key = ConfigKeys.GROUPS;
            if (configuration.containsKey(key)) {
                Group[] groups = (Group[])configuration.get(key.toString());
                for (IElementObject iElementObject : groups) {
                    contest.addGroup((Group)iElementObject);
                }
                log.info("Loaded " + groups.length + " " + key.toString().toLowerCase());
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading groups ", e);
        }
    }

    private void loadProblemDataFilesInfo(IInternalContest contest, Configuration configuration, Logger log) {
        try {
            ConfigKeys key = ConfigKeys.PROBLEM_DATA_FILES;
            if (configuration.containsKey(key)) {
                ProblemDataFiles[] problemDataFiles = (ProblemDataFiles[])configuration.get(key.toString());
                int count = 0;
                for (ProblemDataFiles problemDataFiles2 : problemDataFiles) {
                    Problem problem = contest.getProblem(problemDataFiles2.getProblemId());
                    if (problem != null) {
                        contest.updateProblem(problem, problemDataFiles2);
                        ++count;
                    } else {
                        log.warning("Could not find problem for problemDataFiles problem id=" + problemDataFiles2.getProblemId());
                    }
                    log.info("Loaded " + count + " of " + problemDataFiles.length + " " + key.toString().toLowerCase());
                }
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception while loading problem data files ", e);
        }
    }

    private Account[] getAllAccounts(IInternalContest contest) {
        Vector<Account> allAccounts = new Vector<Account>();
        for (ClientType.Type ctype : ClientType.Type.values()) {
            if (contest.getAccounts(ctype).size() <= 0) continue;
            Vector<Account> accounts = contest.getAccounts(ctype);
            allAccounts.addAll(accounts);
        }
        Account[] accounts = allAccounts.toArray(new Account[allAccounts.size()]);
        return accounts;
    }

    public boolean store(IInternalContest contest, Log log) throws IOException, ClassNotFoundException, FileSecurityException {
        Configuration configuration = new Configuration(this.storage);
        configuration.add(ConfigKeys.SITE_NUMBER, new Integer(contest.getSiteNumber()));
        configuration.add(ConfigKeys.ACCOUNTS, (Serializable)this.getAllAccounts(contest));
        configuration.add(ConfigKeys.CONTEST_TIME, contest.getContestTime());
        configuration.add(ConfigKeys.CONTEST_TIME_LIST, (Serializable)contest.getContestTimes());
        configuration.add(ConfigKeys.BALLOON_SETTINGS_LIST, (Serializable)contest.getBalloonSettings());
        if (contest.getGeneralProblem() != null) {
            configuration.add(ConfigKeys.GENERAL_PROBLEM, contest.getGeneralProblem());
        }
        configuration.add(ConfigKeys.PROBLEM_DATA_FILES, (Serializable)contest.getProblemDataFiles());
        configuration.add(ConfigKeys.JUDGEMENTS, (Serializable)contest.getJudgements());
        configuration.add(ConfigKeys.LANGUAGES, (Serializable)contest.getLanguages());
        configuration.add(ConfigKeys.PROBLEMS, (Serializable)contest.getProblems());
        configuration.add(ConfigKeys.SITES, (Serializable)contest.getSites());
        configuration.add(ConfigKeys.CONTEST_INFORMATION, contest.getContestInformation());
        configuration.add(ConfigKeys.CLIENT_SETTINGS_LIST, (Serializable)contest.getClientSettingsList());
        configuration.add(ConfigKeys.GROUPS, (Serializable)contest.getGroups());
        configuration.add(ConfigKeys.PROFILES, (Serializable)contest.getProfiles());
        configuration.add(ConfigKeys.PROFILE, contest.getProfile());
        if (contest.getFinalizeData() != null) {
            configuration.add(ConfigKeys.FINALIZE_DATA, contest.getFinalizeData());
        }
        if (contest.getProfileCloneSettings() != null) {
            configuration.add(ConfigKeys.PROFILE_CLONE_SETTINGS, contest.getProfileCloneSettings());
        }
        configuration.writeToDisk(this.getFileName());
        configuration = null;
        return true;
    }

    public String getFileName() {
        return this.storage.getDirectoryName() + File.separator + "settings.dat";
    }

    private class Configuration {
        private Hashtable<String, Object> configItemHash = new Hashtable();
        private IStorage storage;

        public Configuration(IStorage storage) {
            this.storage = storage;
        }

        public boolean add(ConfigKeys key, Serializable object) {
            if (object == null) {
                return false;
            }
            this.configItemHash.put(key.toString(), object);
            return true;
        }

        public boolean containsKey(ConfigKeys key) {
            return this.configItemHash.containsKey(key.toString());
        }

        public Object get(String key) {
            return this.configItemHash.get(key);
        }

        public boolean writeToDisk(String fileName) throws IOException, ClassNotFoundException, FileSecurityException {
            return this.storage.store(ConfigurationIO.this.getFileName(), this.configItemHash);
        }

        public boolean loadFromDisk(String filename) throws IOException, ClassNotFoundException, FileSecurityException {
            Serializable readObject = this.storage.load(filename);
            if (readObject instanceof Hashtable) {
                this.configItemHash = (Hashtable)readObject;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigKeys {
        SITE_NUMBER,
        PROBLEMS,
        LANGUAGES,
        CONTEST_TIME,
        SITES,
        ACCOUNTS,
        JUDGEMENTS,
        PROBLEM_DATA_FILES,
        GENERAL_PROBLEM,
        CONTEST_TIME_LIST,
        CONTEST_INFORMATION,
        CLIENT_SETTINGS_LIST,
        BALLOON_SETTINGS_LIST,
        GROUPS,
        PROFILE,
        PROFILES,
        PROFILE_CLONE_SETTINGS,
        FINALIZE_DATA;

    }
}

