/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Problem;

public class Clarification
extends ISubmission {
    private static final long serialVersionUID = -6913818225948370496L;
    private boolean deleted = false;
    private ClientId whoJudgedItId = null;
    private ClientId whoCheckedItOutId = null;
    private String question = null;
    private String answer = null;
    private ClarificationStates state = ClarificationStates.NEW;
    private boolean sendToAll = false;

    public Clarification(ClientId submitter, Problem problemId, String question) {
        this.setSubmitter(submitter);
        this.setProblemId(problemId.getElementId());
        this.question = question;
        this.setElementId(new ElementId("Clarification"));
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
        this.state = ClarificationStates.ANSWERED;
    }

    public boolean isAnswered() {
        return this.state == ClarificationStates.ANSWERED;
    }

    public boolean isNew() {
        return this.state == ClarificationStates.NEW;
    }

    public String getQuestion() {
        return this.question;
    }

    public ClarificationStates getState() {
        return this.state;
    }

    public void setState(ClarificationStates state) {
        this.state = state;
    }

    public boolean isSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public String toString() {
        return "Clarification " + this.getNumber() + " " + (Object)((Object)this.getState()) + " from " + this.getSubmitter() + " at " + this.getElapsedMins() + " id=" + this.getElementId();
    }

    public ClientId getWhoJudgedItId() {
        return this.whoJudgedItId;
    }

    public void setWhoJudgedItId(ClientId whoJudgedItId) {
        this.whoJudgedItId = whoJudgedItId;
    }

    public boolean isSameAs(Clarification clarification) {
        try {
            if (this.deleted != clarification.isDeleted()) {
                return false;
            }
            if (!this.whoJudgedItId.equals(clarification.getWhoJudgedItId())) {
                return false;
            }
            if (!this.question.equals(clarification.getQuestion())) {
                return false;
            }
            if (!this.answer.equals(clarification.getAnswer())) {
                return false;
            }
            if (this.state != clarification.getState()) {
                return false;
            }
            return this.sendToAll == clarification.isSendToAll();
        }
        catch (Exception e) {
            return false;
        }
    }

    public ClientId getWhoCheckedItOutId() {
        return this.whoCheckedItOutId;
    }

    public void setWhoCheckedItOutId(ClientId whoCheckedItOut) {
        this.whoCheckedItOutId = whoCheckedItOut;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClarificationStates {
        NEW,
        BEING_ANSWERED,
        HOLD,
        ANSWERED;

    }
}

