/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;

public class Account
implements IElementObject {
    private static final long serialVersionUID = -1098364914694875689L;
    private ClientId clientId;
    private ElementId elementId;
    private String password;
    private String displayName;
    private String aliasName = "";
    private String externalId = "";
    private ElementId groupId;
    private PermissionList permissionList = new PermissionList();
    private String shortSchoolName = "";
    private String longSchoolName = "";
    private String externalName = "";
    private String countryCode = "";

    public Account(ClientId clientId, String password, int siteNumber) {
        this.elementId = new ElementId(clientId.toString());
        this.clientId = clientId;
        this.setPassword(password);
        this.elementId.setSiteNumber(siteNumber);
        this.displayName = clientId.getClientType().toString().toLowerCase() + clientId.getClientNumber();
    }

    public String toString() {
        return this.displayName;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPassword() {
        StringBuffer sb = new StringBuffer(this.password);
        String p = new String("");
        for (int i = 0; i < sb.length(); ++i) {
            p = p + (char)(sb.charAt(i) ^ 0xFAFA);
        }
        return p;
    }

    public void setPassword(String inPassword) {
        if (inPassword == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(inPassword);
        StringBuffer newStringBuffer = new StringBuffer();
        this.password = "";
        for (int i = 0; i < inPassword.length(); ++i) {
            newStringBuffer.append((char)(sb.charAt(i) ^ 0xFAFA));
        }
        this.password = new String(newStringBuffer);
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
    }

    public boolean isSameAs(Account account) {
        try {
            if (!this.displayName.equals(account.getDisplayName())) {
                return false;
            }
            if (!this.getPassword().equals(account.getPassword())) {
                return false;
            }
            if (this.getClientId().getClientNumber() != account.getClientId().getClientNumber()) {
                return false;
            }
            if (this.getClientId().getClientType() != account.getClientId().getClientType()) {
                return false;
            }
            if (!this.getClientId().equals(account.getClientId())) {
                return false;
            }
            if (this.groupId == null || account.getGroupId() == null ? this.groupId != null || account.getGroupId() != null : !this.groupId.equals(account.getGroupId())) {
                return false;
            }
            if (!this.aliasName.equals(account.getAliasName())) {
                return false;
            }
            if (!this.externalId.equals(account.getExternalId())) {
                return false;
            }
            if (!this.externalName.equals(account.getExternalName())) {
                return false;
            }
            if (!this.longSchoolName.equals(account.getLongSchoolName())) {
                return false;
            }
            return this.shortSchoolName.equals(account.getShortSchoolName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void clearListAndLoadPermissions(PermissionList newPermissionList) {
        this.permissionList.clearAndLoadPermissions(newPermissionList);
    }

    public void addPermission(Permission.Type type) {
        this.permissionList.addPermission(type);
    }

    public void removePermission(Permission.Type type) {
        this.permissionList.removePermission(type);
    }

    public boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    public PermissionList getPermissionList() {
        return this.permissionList;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ElementId getGroupId() {
        return this.groupId;
    }

    public void setGroupId(ElementId groupId) {
        this.groupId = groupId;
    }

    public void setShortSchoolName(String shortSchoolName) {
        this.shortSchoolName = shortSchoolName;
    }

    public void setLongSchoolName(String longSchoolName) {
        this.longSchoolName = longSchoolName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getLongSchoolName() {
        return this.longSchoolName;
    }

    public String getShortSchoolName() {
        return this.shortSchoolName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }
}

