/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import edu.csus.ecs.pc2.core.log.IStreamListener;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class LogStreamHandler
extends StreamHandler {
    private Vector<IStreamListener> streamListenerList = new Vector();

    public LogStreamHandler() {
        this.setupStream();
    }

    public LogStreamHandler(OutputStream out, Formatter formatter) {
        super(out, formatter);
        this.setupStream();
    }

    public void addStreamListener(IStreamListener streamListener) {
        this.streamListenerList.addElement(streamListener);
    }

    public void removeStreamListener(IStreamListener streamListener) {
        this.streamListenerList.remove(streamListener);
    }

    private void fireStreamListener(String inString) {
        for (int i = 0; i < this.streamListenerList.size(); ++i) {
            this.streamListenerList.elementAt(i).messageAdded(inString);
        }
    }

    public synchronized void publish(LogRecord arg0) {
        super.publish(arg0);
        super.flush();
    }

    public void setupStream() {
        this.setOutputStream(new OutputStream(){

            public void write(int b) {
            }

            public void write(byte[] b, int off, int len) {
                String inString = new String(b, off, len);
                LogStreamHandler.this.fireStreamListener(inString);
            }
        });
    }
}

