/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import edu.csus.ecs.pc2.core.log.LogFormatter;
import edu.csus.ecs.pc2.core.log.LogStreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log
extends Logger {
    public static final String SVN_ID = "$Id: Log.java 2044 2010-03-12 07:15:09Z laned $";
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level CONFIG = Level.CONFIG;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level DEBUG = Level.FINEST;
    public static final Level FINEST = Level.FINEST;
    public static final String LOG_DIRECTORY_NAME = "logs";
    private LogStreamHandler streamHandler = null;

    public Log(String logFileName) {
        this("edu.ecs.csus.pc2", null, LOG_DIRECTORY_NAME, logFileName);
    }

    public Log(String directoryName, String logFileName) {
        this("edu.ecs.csus.pc2", null, directoryName, logFileName);
    }

    public Log(String name, String resourceBundleName, String logDirectory, String logFilename) {
        super(name, resourceBundleName);
        this.setLevel(Level.ALL);
        this.setFileHandlers(logDirectory, logFilename);
    }

    public void setFileHandlers(String logDirBase, String baseFileName) {
        if (baseFileName.endsWith(".log")) {
            baseFileName = baseFileName.substring(0, baseFileName.length() - 4);
        }
        Handler[] existingHandlers = this.getHandlers();
        FileHandler fh = null;
        try {
            File file = new File(logDirBase);
            if (!file.exists()) {
                file.mkdir();
            }
            fh = new FileHandler(logDirBase + File.separator + baseFileName + "-%u.log", true);
            fh.setLevel(Level.ALL);
            fh.setFormatter(new LogFormatter(true));
            this.addHandler(fh);
            if (this.streamHandler == null) {
                this.streamHandler = new LogStreamHandler();
                this.streamHandler.setFormatter(new LogFormatter(false));
                this.streamHandler.setLevel(Level.ALL);
                this.addHandler(this.streamHandler);
            }
        }
        catch (Exception e) {
            System.err.println("exception in setFileHandlers");
            e.printStackTrace();
        }
        for (Handler handler : existingHandlers) {
            if (!(handler instanceof FileHandler)) continue;
            handler.close();
            this.removeHandler(handler);
        }
        String location = logDirBase;
        try {
            location = new File(logDirBase).getCanonicalPath();
        }
        catch (IOException e) {
            this.info("Unable to getCanonicalPath of " + logDirBase + ":" + e.getMessage());
        }
        this.config("Now logging to " + location + " directory.");
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws Throwable {
        Handler[] handlers = this.getHandlers();
        this.closeHandlers(handlers);
    }

    private void closeHandlers(Handler[] existingHandlers) {
        if (existingHandlers != null) {
            for (int i = 0; i < existingHandlers.length; ++i) {
                if (existingHandlers[i] == null) continue;
                this.removeHandler(existingHandlers[i]);
                existingHandlers[i].close();
            }
        }
    }

    public LogStreamHandler getStreamHandler() {
        return this.streamHandler;
    }
}

