/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import edu.csus.ecs.pc2.core.log.LogEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class EventLogger {
    private String outputLogFilename;
    private String inputLogFilename;
    private ObjectOutputStream objectOutputStream = null;
    private FileOutputStream fileOutputStream = null;
    private ObjectInputStream objectInputStream = null;
    private FileInputStream fileInputStream = null;

    public void writeEvent(LogEvent logEvent) throws Exception {
        this.appendObjectToLog(logEvent);
    }

    private boolean appendObjectToLog(Serializable serializable) throws Exception {
        if (this.objectOutputStream == null) {
            throw new Exception("EventLog is not open for writing");
        }
        this.objectOutputStream.writeObject(serializable);
        this.objectOutputStream.flush();
        return true;
    }

    public void openLogFile(String filename, boolean forInput) throws Exception {
        if (forInput) {
            this.openLogFileForInput(filename);
        } else {
            this.openLogFile(filename);
        }
    }

    private void openLogFileForInput(String filename) throws Exception {
        if (this.objectInputStream != null) {
            this.objectInputStream.close();
            this.objectInputStream = null;
            this.fileInputStream = null;
        }
        if (!new File(filename).exists()) {
            throw new Exception("File " + filename + " does not exist ");
        }
        this.fileInputStream = new FileInputStream(filename);
        this.objectInputStream = new ObjectInputStream(this.fileInputStream);
        this.inputLogFilename = filename;
    }

    public void openLogFile(String filename) throws IOException {
        if (this.objectOutputStream != null) {
            this.objectOutputStream.close();
            this.objectOutputStream = null;
        }
        if (new File(filename).exists()) {
            this.fileOutputStream = new FileOutputStream(filename, true);
            this.objectOutputStream = new ObjectOutputStream(this.fileOutputStream);
            this.outputLogFilename = filename;
        } else {
            this.fileOutputStream = new FileOutputStream(filename);
            this.objectOutputStream = new ObjectOutputStream(this.fileOutputStream);
            this.outputLogFilename = filename;
        }
    }

    public String getInputLogFilename() {
        return this.inputLogFilename;
    }

    public String getOutputLogFilename() {
        return this.outputLogFilename;
    }

    public LogEvent[] readLogEvents(long minNumberToRead) throws Exception {
        if (this.objectInputStream == null) {
            throw new Exception("Log not opened for input, must open log for input before attempting to read");
        }
        Vector<LogEvent> events = new Vector<LogEvent>();
        long numRead = 0L;
        if (minNumberToRead < 1L) {
            minNumberToRead = Long.MAX_VALUE;
        }
        Object object = null;
        do {
            try {
                object = this.objectInputStream.readObject();
            }
            catch (EOFException eof) {
                object = null;
            }
            if (object != null && object instanceof LogEvent) {
                events.addElement((LogEvent)object);
                continue;
            }
            if (object == null) continue;
            throw new Exception("Found object " + object.getClass().getName() + " expecting LogEvent in file " + this.inputLogFilename);
        } while (object != null && ++numRead < minNumberToRead);
        return events.toArray(new LogEvent[events.size()]);
    }

    public void closeAll() throws IOException {
        if (this.objectInputStream != null) {
            this.objectInputStream.close();
            this.objectInputStream = null;
            this.fileInputStream = null;
        }
        if (this.objectOutputStream != null) {
            this.objectOutputStream.flush();
            this.objectOutputStream.close();
            this.objectOutputStream = null;
            this.fileOutputStream = null;
        }
    }
}

