/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunList
implements Serializable {
    private static final long serialVersionUID = 1446963022315687590L;
    public static final String SVN_ID = "$Id: RunList.java 2151 2010-10-05 22:07:43Z laned $";
    private Hashtable<String, Run> runHash = new Hashtable(200);
    private boolean saveToDisk = false;
    private int nextRunNumber = 1;
    private IStorage storage;

    public RunList() {
        this.saveToDisk = false;
    }

    public RunList(IStorage storage) {
        this.storage = storage;
        this.saveToDisk = true;
    }

    public Run addNewRun(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        run.setNumber(this.nextRunNumber++);
        this.add(run);
        return run;
    }

    public void add(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        this.runHash.put(this.getRunKey(run), run);
        if (this.saveToDisk) {
            this.writeToDisk();
        }
    }

    private Run get(String key) {
        return this.runHash.get(key);
    }

    public Run get(ElementId id) {
        return this.runHash.get(id.toString());
    }

    public Run get(Run run) {
        return this.get(this.getRunKey(run));
    }

    public String getRunKey(Run run) {
        return run.getElementId().toString();
    }

    public boolean delete(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        Run fetchedRun = this.get(this.getRunKey(run));
        if (fetchedRun != null) {
            fetchedRun.setDeleted(true);
            this.writeToDisk();
            return true;
        }
        return false;
    }

    public void clear() throws IOException, ClassNotFoundException, FileSecurityException {
        this.runHash = new Hashtable(200);
        this.nextRunNumber = 1;
        this.writeToDisk();
    }

    public void updateRunStatus(Run run, Run.RunStates newState) throws IOException, ClassNotFoundException, FileSecurityException {
        Run theRun = this.runHash.get(this.getRunKey(run));
        theRun.getElementId().incrementVersionNumber();
        theRun.setStatus(newState);
        this.writeToDisk();
    }

    public void updateRun(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        run.getElementId().incrementVersionNumber();
        this.runHash.put(this.getRunKey(run), run);
        this.writeToDisk();
    }

    public void updateRun(Run run, JudgementRecord judgement, boolean manualReview) throws IOException, ClassNotFoundException, FileSecurityException {
        Run theRun = this.runHash.get(this.getRunKey(run));
        theRun.getElementId().incrementVersionNumber();
        if (theRun.getStatus().equals((Object)Run.RunStates.BEING_JUDGED)) {
            if (manualReview && judgement.isComputerJudgement()) {
                judgement.setPreliminaryJudgement(true);
                theRun.setStatus(Run.RunStates.MANUAL_REVIEW);
            } else {
                theRun.setStatus(Run.RunStates.JUDGED);
            }
        } else {
            theRun.setStatus(Run.RunStates.JUDGED);
        }
        theRun.addJudgement(judgement);
        this.writeToDisk();
    }

    public Enumeration<Run> getRunList() {
        return this.runHash.elements();
    }

    private String getFileName() {
        return this.storage.getDirectoryName() + File.separator + "runlist.dat";
    }

    private boolean writeToDisk() throws IOException, ClassNotFoundException, FileSecurityException {
        if (!this.isSaveToDisk()) {
            return false;
        }
        return this.storage.store(this.getFileName(), this.runHash);
    }

    public boolean loadFromDisk(int siteNumber) throws IOException, ClassNotFoundException, FileSecurityException {
        String filename = this.getFileName();
        if (Utilities.isFileThere(filename)) {
            this.runHash = (Hashtable)this.storage.load(filename);
            this.nextRunNumber = this.lastRunNumber(siteNumber) + 1;
            return true;
        }
        return false;
    }

    private int lastRunNumber(int siteNumber) {
        int lastNumber = 0;
        for (Run run : this.getList()) {
            if (run.getSiteNumber() != siteNumber) continue;
            lastNumber = Math.max(lastNumber, run.getNumber());
        }
        return lastNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Hashtable<String, Run> hashtable = this.runHash;
        synchronized (hashtable) {
            return this.runHash.size();
        }
    }

    public Run[] getList() {
        if (this.runHash.size() == 0) {
            return new Run[0];
        }
        return this.runHash.values().toArray(new Run[this.size()]);
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public void setSaveToDisk(boolean saveToDisk) {
        this.saveToDisk = saveToDisk;
    }

    public void clone(IStorage storage2) {
        try {
            if (this.saveToDisk && this.runHash.size() > 0) {
                storage2.store(this.getFileName(), this.runHash);
            }
        }
        catch (Exception e) {
            this.logException("Unable to copy run info files " + this.getFileName() + " to " + storage2.getDirectoryName(), e);
        }
    }

    private void logException(String string, Exception e) {
        if (StaticLog.getLog() == null) {
            StaticLog.getLog().log(Log.WARNING, string, e);
        } else {
            System.err.println(string + " " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public int getNextRunNumber() {
        return this.nextRunNumber;
    }
}

