/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public class RunFilesList
implements Serializable {
    private static final long serialVersionUID = -15984887352160586L;
    private boolean writeToDisk = false;
    private boolean cacheRunFiles = false;
    private RunFiles singleRunFiles = null;
    private HashMap<String, RunFiles> runFilesHash = new HashMap();
    private IStorage storage;

    public RunFilesList(boolean cacheRunFiles) {
        this.cacheRunFiles = cacheRunFiles;
    }

    public RunFilesList(IStorage storage) {
        this.storage = storage;
        this.writeToDisk = true;
    }

    public RunFilesList() {
    }

    public String getDirectoryName() {
        return this.storage.getDirectoryName();
    }

    private String getFileName(int siteNumber, int runNumber) {
        return this.getDirectoryName() + File.separator + "s" + siteNumber + "r" + runNumber + ".files";
    }

    public int getLastRunFilesRunId(int siteNumber) {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String filename = this.getFileName(siteNumber, i);
            if (new File(filename).exists()) continue;
            return i - 1;
        }
        return 0;
    }

    private String getFileName(Run run) {
        return this.getFileName(run.getSiteNumber(), run.getNumber());
    }

    protected String getRunKey(int siteNumber, int runNumber) {
        return "s" + siteNumber + "r" + runNumber;
    }

    public RunFiles add(Run run, RunFiles runFiles) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            String filename = this.getFileName(run);
            this.storage.store(filename, runFiles);
            return runFiles;
        }
        if (this.cacheRunFiles) {
            String key = this.getRunKey(run.getSiteNumber(), run.getNumber());
            this.runFilesHash.put(key, runFiles);
            return runFiles;
        }
        this.singleRunFiles = runFiles;
        return this.singleRunFiles;
    }

    private RunFiles getRunFiles(int siteNumber, int runNumber) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            String filename = this.getFileName(siteNumber, runNumber);
            Serializable obj = this.storage.load(filename);
            return (RunFiles)obj;
        }
        if (this.cacheRunFiles) {
            String key = this.getRunKey(siteNumber, runNumber);
            return this.runFilesHash.get(key);
        }
        return null;
    }

    public RunFiles getRunFiles(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            return this.getRunFiles(run.getSiteNumber(), run.getNumber());
        }
        if (this.cacheRunFiles) {
            return this.getRunFiles(run.getSiteNumber(), run.getNumber());
        }
        if (this.singleRunFiles != null && run.getElementId().equals(this.singleRunFiles.getRunId())) {
            return this.singleRunFiles;
        }
        return null;
    }

    public boolean isRunFilesPresent(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            String filename = this.getFileName(run.getSiteNumber(), run.getNumber());
            return new File(filename).isFile();
        }
        if (this.cacheRunFiles) {
            return this.getRunFiles(run.getSiteNumber(), run.getNumber()) != null;
        }
        return this.singleRunFiles != null && run.getElementId().equals(this.singleRunFiles.getRunId());
    }

    public String getRunKey(Run run) {
        return run.getElementId().toString();
    }

    public void clearCache() {
        this.runFilesHash = new HashMap();
        this.singleRunFiles = null;
    }

    public boolean isCacheRunFiles() {
        return this.cacheRunFiles;
    }

    public void setCacheRunFiles(boolean cacheRunFiles) {
        this.cacheRunFiles = cacheRunFiles;
    }

    public boolean isWriteToDisk() {
        return this.writeToDisk;
    }

    public void clone(IStorage storage2) {
        File dir;
        if (this.writeToDisk && (dir = new File(this.storage.getDirectoryName())).isDirectory()) {
            File[] entries;
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".files");
                }
            };
            for (File file : entries = dir.listFiles(filter)) {
                try {
                    if (file.getCanonicalFile().toString().indexOf("JudgementRecord") != -1) continue;
                    Serializable serializable = this.storage.load(file.getCanonicalPath());
                    storage2.store(file.getName(), serializable);
                }
                catch (Exception e) {
                    this.logException("Unable to copy file " + file.getName() + " to " + storage2.getDirectoryName(), e);
                }
            }
            dir = null;
            entries = null;
        }
    }

    private void logException(String string, Exception e) {
        if (StaticLog.getLog() == null) {
            StaticLog.getLog().log(Log.WARNING, string, e);
        } else {
            System.err.println(string + " " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

