/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.list.BaseElementList;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class ContestTimeList
extends BaseElementList {
    private static final long serialVersionUID = -1573135566498698327L;
    public static final String SVN_ID = "$Id: ContestTimeList.java 2092 2010-06-25 17:17:56Z laned $";

    public void add(ContestTime contestTime) {
        if (this.get(contestTime) != null) {
            throw new IllegalArgumentException("Attemped to add Contest time for " + contestTime.getSiteNumber() + " site already added");
        }
        super.add(contestTime);
    }

    public ContestTime[] getList() {
        return this.values().toArray(new ContestTime[this.size()]);
    }

    public ContestTime get(int siteNumber) {
        for (ContestTime contestTime : this.getList()) {
            if (contestTime.getSiteNumber() != siteNumber) continue;
            return contestTime;
        }
        return null;
    }

    public ContestTime get(ElementId elementId) {
        for (ContestTime contestTime : this.getList()) {
            if (!contestTime.getElementId().equals(elementId)) continue;
            return contestTime;
        }
        return null;
    }

    public String getKey(IElementObject elementObject) {
        ContestTime contestTime = (ContestTime)elementObject;
        return new Long(contestTime.getSiteNumber()).toString();
    }
}

