/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseElementList
implements Serializable {
    private static final long serialVersionUID = 1669027887187605463L;
    private Hashtable<String, IElementObject> hash = new Hashtable();

    public abstract String getKey(IElementObject var1);

    public void add(IElementObject elementObject) {
        this.hash.put(this.getKey(elementObject), elementObject);
    }

    public void addList(Map<String, IElementObject> moreItems) {
        this.hash.putAll(moreItems);
    }

    public void delete(IElementObject elementObject) {
        this.hash.remove(this.getKey(elementObject));
    }

    public void delete(ElementId elementId) {
        String key = elementId.toString();
        if (this.hash.containsKey(key)) {
            this.hash.remove(key);
        }
    }

    public IElementObject get(ElementId id) {
        return this.hash.get(id.toString());
    }

    public IElementObject get(IElementObject elementObject) {
        return this.hash.get(this.getKey(elementObject));
    }

    public void clear() {
        this.hash = new Hashtable(200);
    }

    public boolean update(IElementObject elementObject) {
        if (this.hash.containsKey(this.getKey(elementObject))) {
            elementObject.getElementId().incrementVersionNumber();
            this.hash.put(this.getKey(elementObject), elementObject);
            return true;
        }
        this.hash.put(this.getKey(elementObject), elementObject);
        return false;
    }

    public Enumeration<? extends IElementObject> elements() {
        return this.hash.elements();
    }

    public int size() {
        return this.hash.size();
    }

    public Collection<? extends IElementObject> values() {
        return this.hash.values();
    }
}

