/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.imports;

import edu.csus.ecs.pc2.core.exception.IllegalTSVFormatException;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.TabSeparatedValueParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;

public class LoadAccounts {
    private HashMap<ClientId, Account> accountMap = new HashMap();
    private HashMap<String, Group> groups = new HashMap();
    private int siteColumn = -1;
    private int accountColumn = -1;
    private int displayNameColumn = -1;
    private int passwordColumn = -1;
    private int groupColumn = -1;
    private int permDisplayColumn = -1;
    private int permLoginColumn = -1;
    private int aliasColumn = -1;
    private int externalIdColumn = -1;
    private int permPasswordColumn = -1;
    private int longSchoolNameColumnn = -1;
    private int shortSchoolNameColumn = -1;
    private int teamNameColumn = -1;
    private HashMap<ClientId, Account> existingAccountsMap = new HashMap();

    Account getAccount(String[] values) {
        String message;
        boolean newValue;
        String accountString = values[this.accountColumn];
        String[] accountSplit = accountString.split("[0-9]+$");
        String accountName = accountString.substring(0, accountSplit[0].length());
        ClientType.Type type = ClientType.Type.valueOf(accountName.toUpperCase());
        int clientNumber = Integer.parseInt(accountString.substring(accountSplit[0].length()));
        String siteString = values[this.siteColumn];
        ClientId clientId = new ClientId(Integer.parseInt(siteString), type, clientNumber);
        Account accountClean = this.existingAccountsMap.get(clientId);
        if (accountClean == null) {
            return null;
        }
        Account account = new Account(accountClean.getClientId(), accountClean.getPassword(), accountClean.getClientId().getSiteNumber());
        account.clearListAndLoadPermissions(accountClean.getPermissionList());
        account.setGroupId(accountClean.getGroupId());
        account.setDisplayName(new String(accountClean.getDisplayName()));
        account.setAliasName(new String(accountClean.getAliasName()));
        account.setExternalId(new String(accountClean.getExternalId()));
        account.setExternalName(new String(accountClean.getExternalName()));
        account.setGroupId(accountClean.getGroupId());
        account.setLongSchoolName(new String(accountClean.getLongSchoolName()));
        account.setShortSchoolName(new String(accountClean.getShortSchoolName()));
        if (this.passwordColumn != -1 && values.length > this.passwordColumn) {
            account.setPassword(values[this.passwordColumn]);
        }
        if (this.displayNameColumn != -1 && values.length > this.displayNameColumn) {
            account.setDisplayName(values[this.displayNameColumn]);
        }
        if (this.aliasColumn != -1 && values.length > this.aliasColumn) {
            account.setAliasName(values[this.aliasColumn]);
        }
        if (this.externalIdColumn != -1 && values.length > this.externalIdColumn) {
            account.setExternalId(values[this.externalIdColumn]);
        }
        if (this.longSchoolNameColumnn != -1 && values.length > this.longSchoolNameColumnn) {
            account.setLongSchoolName(values[this.longSchoolNameColumnn]);
        }
        if (this.shortSchoolNameColumn != -1 && values.length > this.shortSchoolNameColumn) {
            account.setShortSchoolName(values[this.shortSchoolNameColumn]);
        }
        if (this.teamNameColumn != -1 && values.length > this.teamNameColumn) {
            account.setExternalName(values[this.teamNameColumn]);
        }
        if (this.groups.size() > 0 && this.groupColumn != -1 && values.length > this.groupColumn && values[this.groupColumn].length() > 0 && this.groups.containsKey(values[this.groupColumn])) {
            account.setGroupId(this.groups.get(values[this.groupColumn]).getElementId());
        }
        if (this.permDisplayColumn != -1 && values.length > this.permDisplayColumn && values[this.permDisplayColumn].length() > 0) {
            newValue = Boolean.parseBoolean(values[this.permDisplayColumn]);
            if (clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR) && clientId.getClientNumber() == 1) {
                if (account.getPermissionList().isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD) != newValue) {
                    message = "Attempt to change root permission DISPLAY_ON_SCOREBOARD denied.";
                    StaticLog.warning(message);
                    System.out.println("WARNING: " + message);
                }
            } else if (newValue) {
                account.addPermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
            } else {
                account.removePermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
            }
        }
        if (this.permLoginColumn != -1 && values.length > this.permLoginColumn && values[this.permLoginColumn].length() > 0) {
            newValue = Boolean.parseBoolean(values[this.permLoginColumn]);
            if (clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR) && clientId.getClientNumber() == 1) {
                if (account.getPermissionList().isAllowed(Permission.Type.LOGIN) != newValue) {
                    message = "Attempt to change root permission LOGIN denied.";
                    StaticLog.warning(message);
                    System.out.println("WARNING: " + message);
                }
            } else if (Boolean.parseBoolean(values[this.permLoginColumn])) {
                account.addPermission(Permission.Type.LOGIN);
            } else {
                account.removePermission(Permission.Type.LOGIN);
            }
        }
        if (this.permPasswordColumn != -1 && values.length > this.permPasswordColumn && values[this.permPasswordColumn].length() > 0) {
            Permission.Type perm = Permission.Type.CHANGE_PASSWORD;
            boolean newValue2 = Boolean.parseBoolean(values[this.permPasswordColumn]);
            if (clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR) && clientId.getClientNumber() == 1) {
                if (account.getPermissionList().isAllowed(perm) != newValue2) {
                    String message2 = "Attempt to change root permission " + (Object)((Object)perm) + " denied.";
                    StaticLog.warning(message2);
                    System.out.println("WARNING: " + message2);
                }
            } else if (Boolean.parseBoolean(values[this.permPasswordColumn])) {
                account.addPermission(perm);
            } else {
                account.removePermission(perm);
            }
        }
        return account;
    }

    public Account[] fromTSVFile(String filename, Account[] existingAccounts, Group[] groupList) throws Exception {
        if (existingAccounts != null && existingAccounts.length > 0) {
            for (int i = 0; i < existingAccounts.length; ++i) {
                this.existingAccountsMap.put(existingAccounts[i].getClientId(), existingAccounts[i]);
            }
        }
        this.groups.clear();
        for (Group group : groupList) {
            this.groups.put(group.toString(), group);
        }
        int lineCount = 0;
        FileReader fileReader = new FileReader(filename);
        BufferedReader in = new BufferedReader(fileReader);
        String line = in.readLine();
        while (line != null && line.startsWith("#")) {
            line = in.readLine();
            ++lineCount;
        }
        ++lineCount;
        if (line != null) {
            String[] columns = TabSeparatedValueParser.parseLine(line);
            this.siteColumn = -1;
            this.accountColumn = -1;
            this.displayNameColumn = -1;
            this.passwordColumn = -1;
            this.groupColumn = -1;
            this.aliasColumn = -1;
            this.externalIdColumn = -1;
            this.permDisplayColumn = -1;
            this.permLoginColumn = -1;
            this.permPasswordColumn = -1;
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].equalsIgnoreCase("site")) {
                    this.siteColumn = i;
                }
                if (columns[i].equalsIgnoreCase("account")) {
                    this.accountColumn = i;
                }
                if (columns[i].equalsIgnoreCase("displayname")) {
                    this.displayNameColumn = i;
                }
                if (columns[i].equalsIgnoreCase("password")) {
                    this.passwordColumn = i;
                }
                if (columns[i].equalsIgnoreCase("group")) {
                    this.groupColumn = i;
                }
                if (columns[i].equalsIgnoreCase("permdisplay")) {
                    this.permDisplayColumn = i;
                }
                if (columns[i].equalsIgnoreCase("permlogin")) {
                    this.permLoginColumn = i;
                }
                if (columns[i].equalsIgnoreCase("externalid")) {
                    this.externalIdColumn = i;
                }
                if (columns[i].equalsIgnoreCase("alias")) {
                    this.aliasColumn = i;
                }
                if (columns[i].equalsIgnoreCase("permpassword")) {
                    this.permPasswordColumn = i;
                }
                if (columns[i].equalsIgnoreCase("longschoolname")) {
                    this.longSchoolNameColumnn = i;
                }
                if (columns[i].equalsIgnoreCase("shortschoolname")) {
                    this.shortSchoolNameColumn = i;
                }
                if (!columns[i].equalsIgnoreCase("teamname")) continue;
                this.teamNameColumn = i;
            }
            if (this.accountColumn == -1 || this.siteColumn == -1) {
                String msg = "1st line should be the row headers (account and site are required)";
                throw new IllegalTSVFormatException(msg);
            }
        }
        line = in.readLine();
        ++lineCount;
        while (line != null) {
            try {
                if (line.startsWith("#") || line.equals("")) {
                    line = in.readLine();
                    ++lineCount;
                    continue;
                }
                String[] values = TabSeparatedValueParser.parseLine(line);
                if (!values[this.accountColumn].equals("")) {
                    Account account = this.getAccount(values);
                    if (account == null) {
                        String msg = filename + ":" + lineCount + ": " + " please create the account first (" + values[this.accountColumn] + ")";
                        throw new IllegalTSVFormatException(msg);
                    }
                    this.accountMap.put(account.getClientId(), account);
                }
            }
            catch (IllegalTSVFormatException e2) {
                throw e2;
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "Error " + filename + ":" + lineCount + ": " + e.getMessage();
                Exception sendException = new Exception(msg);
                sendException.setStackTrace(e.getStackTrace());
                throw sendException;
            }
            line = in.readLine();
            ++lineCount;
        }
        in.close();
        fileReader.close();
        in = null;
        fileReader = null;
        return this.accountMap.values().toArray(new Account[this.accountMap.size()]);
    }
}

