/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.imports;

import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.CommaSeparatedValueParser;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.TabSeparatedValueParser;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportAccounts {
    private static String[] titles = new String[]{"site", "account", "displayname", "password", "group", "permdisplay", "permlogin", "externalid", "alias", "permpassword"};
    private static Hashtable<ElementId, String> groupHash;
    private static Exception exception;

    private ExportAccounts() {
    }

    public static boolean saveAccounts(Formats format, Account[] accounts, Group[] groups, File outputFile) {
        ExportAccounts.setException(null);
        boolean result = false;
        groupHash = new Hashtable();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                Group group = groups[i];
                groupHash.put(group.getElementId(), group.getDisplayName());
            }
        }
        if (accounts != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(outputFile, false), true);
                Arrays.sort(accounts, new AccountComparator());
                if (format.equals((Object)Formats.TXT)) {
                    result = ExportAccounts.writeTXT(printWriter, accounts);
                }
                if (format.equals((Object)Formats.CSV)) {
                    result = ExportAccounts.writeCSV(printWriter, accounts);
                }
                if (format.equals((Object)Formats.XML)) {
                    result = ExportAccounts.writeXML(printWriter, accounts, groups);
                }
                printWriter.close();
            }
            catch (FileNotFoundException e) {
                ExportAccounts.setException(e);
                result = false;
            }
        }
        return result;
    }

    private static boolean writeXML(PrintWriter out, Account[] accounts, Group[] groups) {
        boolean result = true;
        try {
            String xmlString = ExportAccounts.buildXMLString(accounts, groups);
            if (xmlString.equals("")) {
                result = false;
            }
            out.println(xmlString);
        }
        catch (Exception e) {
            ExportAccounts.setException(e);
            result = false;
        }
        return result;
    }

    private static boolean writeCSV(PrintWriter out, Account[] accounts) {
        boolean result = true;
        try {
            out.println(CommaSeparatedValueParser.toString(titles));
            for (int i = 0; i < accounts.length; ++i) {
                Account account = accounts[i];
                if (account.getClientId().getClientType().equals((Object)ClientType.Type.SERVER)) continue;
                String[] a = ExportAccounts.buildAccountString(account);
                out.println(CommaSeparatedValueParser.toString(a));
            }
        }
        catch (Exception e) {
            ExportAccounts.setException(e);
            result = false;
        }
        return result;
    }

    private static boolean writeTXT(PrintWriter out, Account[] accounts) {
        boolean result = true;
        try {
            out.println(TabSeparatedValueParser.toString(titles));
            for (int i = 0; i < accounts.length; ++i) {
                Account account = accounts[i];
                if (account.getClientId().getClientType().equals((Object)ClientType.Type.SERVER)) continue;
                String[] a = ExportAccounts.buildAccountString(account);
                out.println(TabSeparatedValueParser.toString(a));
            }
        }
        catch (Exception e) {
            ExportAccounts.setException(e);
            result = false;
        }
        return result;
    }

    private static String[] buildAccountString(Account account) {
        String[] a = new String[titles.length];
        a[0] = Integer.toString(account.getSiteNumber());
        a[1] = account.getClientId().getName();
        a[2] = account.getDisplayName();
        a[3] = account.getPassword();
        a[4] = account.getGroupId() != null ? groupHash.get(account.getGroupId()) : "";
        a[5] = Boolean.toString(account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD));
        a[6] = Boolean.toString(account.isAllowed(Permission.Type.LOGIN));
        a[7] = account.getExternalId();
        a[8] = account.getAliasName();
        a[9] = Boolean.toString(account.isAllowed(Permission.Type.CHANGE_PASSWORD));
        return a;
    }

    public static String buildXMLString(Account[] accounts, Group[] groups) {
        String xmlString;
        Hashtable<ElementId, String> groupsH = new Hashtable<ElementId, String>();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                Group group = groups[i];
                groupsH.put(group.getElementId(), group.getDisplayName());
            }
        }
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("accounts");
        for (int i = 0; i < accounts.length; ++i) {
            Account account = accounts[i];
            if (account.getClientId().getClientType().equals((Object)ClientType.Type.SERVER)) continue;
            ExportAccounts.addSingleAccountXML(account, groupsH, mementoRoot);
        }
        try {
            xmlString = mementoRoot.saveToString();
        }
        catch (IOException e) {
            ExportAccounts.setException(e);
            xmlString = "";
        }
        return xmlString;
    }

    private static void addSingleAccountXML(Account account, Hashtable<ElementId, String> groups, XMLMemento mementoRoot) {
        IMemento accountMemento = mementoRoot.createChild("account");
        accountMemento.putString("teamName", account.getDisplayName());
        accountMemento.putInteger("teamId", account.getClientId().getClientNumber());
        accountMemento.putInteger("teamSiteId", account.getClientId().getSiteNumber());
        accountMemento.putString("teamKey", account.getClientId().getTripletKey());
        accountMemento.putString("teamExternalId", account.getExternalId());
        accountMemento.putString("teamAlias", account.getAliasName().trim());
        String groupName = "";
        if (account.getGroupId() != null) {
            groupName = groups.get(account.getGroupId());
        }
        accountMemento.putString("groupName", groupName);
        accountMemento.putString("accountName", account.getClientId().getName());
        accountMemento.putInteger("siteId", account.getSiteNumber());
        accountMemento.putString("password", account.getPassword());
        accountMemento.putBoolean("permdisplay", account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD));
        accountMemento.putBoolean("permlogin", account.isAllowed(Permission.Type.LOGIN));
        accountMemento.putBoolean("permpassword", account.isAllowed(Permission.Type.CHANGE_PASSWORD));
    }

    private static void setException(Exception exception) {
        ExportAccounts.exception = exception;
    }

    public static Exception getException() {
        return exception;
    }

    static {
        exception = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Formats {
        CSV,
        TXT,
        XML;

    }
}

