/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.execute.IOCollector;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ExecuteTimer
extends Thread
implements ActionListener {
    public static final String SVN_ID = "$Id: ExecuteTimer.java 2093 2010-06-25 17:31:54Z laned $";
    private long maxTime = 120L;
    private Timer timer;
    private JFrame ivjExecuteTimerFrame = null;
    private JLabel ivjExecuteTimerLabel1 = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel ivjTimerCount = null;
    private GregorianCalendar startTime = this.now();
    private JButton ivjbtnTerminate = null;
    private Process proc;
    private IOCollector firstIO;
    private IOCollector secondIO;
    private boolean doAutoStop = false;
    private boolean runTimeLimitExceeded = false;
    private boolean otherContactStaff = false;
    private Log log = null;
    private ClientId clientId;

    public ExecuteTimer(ClientId clientId) {
        this.clientId = clientId;
        this.initialize();
    }

    public ExecuteTimer(Log log, int timeLimit, ClientId clientId) {
        this.log = log;
        this.clientId = clientId;
        this.maxTime = timeLimit;
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        long currentTime = this.getElapsedSecs();
        long seconds = currentTime % 60L;
        long minutes = currentTime / 60L;
        String newTime = "";
        if (minutes < 10L) {
            newTime = newTime + "0";
        }
        newTime = newTime + minutes + ":";
        if (seconds < 10L) {
            newTime = newTime + "0";
        }
        newTime = newTime + seconds;
        if (currentTime > this.maxTime && !this.isTeam()) {
            this.getTimerCount().setForeground(Color.red);
            if (this.doAutoStop) {
                this.log.config("ExecuteTimer - halting run execute, over time limit ");
                this.setRunTimeLimitExceeded(true);
                this.stopIOCollectors();
            }
        }
        this.getTimerCount().setText(newTime);
        if (e.getSource() == this.getbtnTerminate()) {
            this.connEtoC1(e);
        }
    }

    public void btnTerminateActionPerformed(ActionEvent actionEvent) {
        if (this.doAutoStop) {
            this.log.config("ExecuteTimer - User hit terminate while AJ'ing.");
            this.setOtherContactStaff(true);
        }
        this.stopIOCollectors();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.btnTerminateActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getbtnTerminate() {
        if (this.ivjbtnTerminate == null) {
            try {
                this.ivjbtnTerminate = new JButton();
                this.ivjbtnTerminate.setName("btnTerminate");
                this.ivjbtnTerminate.setMnemonic('t');
                this.ivjbtnTerminate.setText("Terminate");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnTerminate;
    }

    private long getElapsedSecs() {
        long milliDiff = this.now().getTime().getTime() - this.startTime.getTime().getTime();
        long secs = milliDiff / 1000L;
        return secs;
    }

    private JFrame getExecuteTimerFrame() {
        if (this.ivjExecuteTimerFrame == null) {
            try {
                this.ivjExecuteTimerFrame = new JFrame();
                this.ivjExecuteTimerFrame.setName("ExecuteTimerFrame");
                this.ivjExecuteTimerFrame.setDefaultCloseOperation(0);
                this.ivjExecuteTimerFrame.setTitle("Execution Timer");
                this.ivjExecuteTimerFrame.setBounds(125, 30, 253, 143);
                this.ivjExecuteTimerFrame.setVisible(true);
                this.ivjExecuteTimerFrame.setCursor(new Cursor(0));
                this.getExecuteTimerFrame().setContentPane(this.getJFrameContentPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExecuteTimerFrame;
    }

    private JLabel getExecuteTimerLabel1() {
        if (this.ivjExecuteTimerLabel1 == null) {
            try {
                this.ivjExecuteTimerLabel1 = new JLabel();
                this.ivjExecuteTimerLabel1.setName("ExecuteTimerLabel1");
                this.ivjExecuteTimerLabel1.setText("Execution Time");
                this.ivjExecuteTimerLabel1.setVerticalTextPosition(3);
                this.ivjExecuteTimerLabel1.setFont(new Font("dialog", 1, 18));
                this.ivjExecuteTimerLabel1.setVerticalAlignment(3);
                this.ivjExecuteTimerLabel1.setHorizontalAlignment(0);
                this.ivjExecuteTimerLabel1.setCursor(new Cursor(0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExecuteTimerLabel1;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(this.getJFrameContentPaneBorderLayout());
                this.getJFrameContentPane().add((Component)this.getExecuteTimerLabel1(), "North");
                this.getJFrameContentPane().add((Component)this.getTimerCount(), "Center");
                this.getJFrameContentPane().add((Component)this.getbtnTerminate(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private BorderLayout getJFrameContentPaneBorderLayout() {
        BorderLayout contentPaneBorderLayout = null;
        try {
            contentPaneBorderLayout = new BorderLayout();
            contentPaneBorderLayout.setVgap(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return contentPaneBorderLayout;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public Process getProc() {
        return this.proc;
    }

    private JLabel getTimerCount() {
        if (this.ivjTimerCount == null) {
            try {
                this.ivjTimerCount = new JLabel();
                this.ivjTimerCount.setName("TimerCount");
                this.ivjTimerCount.setFont(new Font("monospaced", 1, 48));
                this.ivjTimerCount.setText(" ");
                this.ivjTimerCount.setHorizontalAlignment(0);
                this.ivjTimerCount.setCursor(new Cursor(0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTimerCount;
    }

    public JFrame getTimerFrame() {
        return this.getExecuteTimerFrame();
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getbtnTerminate().addActionListener(this);
    }

    private void initialize() {
        try {
            this.timer = new Timer(1000, this);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean isOtherContactStaff() {
        return this.otherContactStaff;
    }

    public boolean isRunTimeLimitExceeded() {
        return this.runTimeLimitExceeded;
    }

    private GregorianCalendar now() {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        return new GregorianCalendar(tz);
    }

    public void setDoAutoStop() {
        this.doAutoStop = true;
    }

    public void setDoAutoStop(boolean newDoAutoStop) {
        this.doAutoStop = newDoAutoStop;
    }

    public void setIOCollectors(IOCollector one, IOCollector two) {
        this.firstIO = one;
        this.secondIO = two;
    }

    public void setMaxTime(long newMaxTime) {
        this.maxTime = newMaxTime;
    }

    private void setOtherContactStaff(boolean newOtherContactStaff) {
        this.otherContactStaff = newOtherContactStaff;
    }

    public void setProc(Process newProc) {
        this.proc = newProc;
    }

    private void setRunTimeLimitExceeded(boolean newRunTimeLimitExceeded) {
        this.runTimeLimitExceeded = newRunTimeLimitExceeded;
    }

    public void setStartTime() {
        this.getTimerCount().setText("00:00");
        this.startTime = this.now();
    }

    public void setTitle(String msg) {
        this.getExecuteTimerLabel1().setText(msg);
    }

    public void startTimer() {
        this.setStartTime();
        this.timer.start();
        this.getExecuteTimerFrame().setVisible(true);
    }

    public void stopIOCollectors() {
        this.stopTimer();
        this.firstIO.haltMe();
        this.secondIO.haltMe();
        if (this.proc != null) {
            this.log.config("ExecuteTimer: attempting to destroy process");
            this.proc.destroy();
        }
    }

    public void stopTimer() {
        this.timer.stop();
        this.getExecuteTimerFrame().setVisible(false);
        this.getExecuteTimerFrame().dispose();
    }

    private boolean isTeam() {
        return this.clientId.getClientType().equals((Object)ClientType.Type.TEAM);
    }
}

