/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.ExecuteTimer;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.execute.IOCollector;
import edu.csus.ecs.pc2.core.execute.XMLResultsParser;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;

public class Executable {
    private Run run = null;
    private Language language = null;
    private Problem problem = null;
    private ProblemDataFiles problemDataFiles = null;
    private ClientId executorId = null;
    private String mainFileDirectory;
    private ExecutionData executionData;
    private ExecuteTimer executionTimer;
    private IFileViewer fileViewer = null;
    private static final int ERRORLENGTH = 50;
    public static final String COMPILER_STDOUT_FILENAME = "cstdout.pc2";
    public static final String COMPILER_STDERR_FILENAME = "cstderr.pc2";
    public static final String EXECUTE_STDOUT_FILENAME = "estdout.pc2";
    public static final String EXECUTE_STDERR_FILENAME = "estderr.pc2";
    public static final String VALIDATOR_STDOUT_FILENAME = "vstdout.pc2";
    public static final String VALIDATOR_STDERR_FILENAME = "vstderr.pc2";
    private RunFiles runFiles;
    private String errorString;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private String executeDirectoryName = null;
    private String executeDirectoryNameSuffix = "";
    private boolean overwriteJudgesDataFiles = true;
    private boolean testRunOnly = false;
    private boolean showMessageToUser;

    public Executable(IInternalContest inContest, IInternalController inController, Run run, RunFiles runFiles) {
        this.contest = inContest;
        this.controller = inController;
        this.runFiles = runFiles;
        this.run = run;
        this.language = inContest.getLanguage(run.getLanguageId());
        this.problem = inContest.getProblem(run.getProblemId());
        this.initialize();
    }

    private void initialize() {
        this.executorId = this.contest.getClientId();
        this.mainFileDirectory = this.getDirName(this.runFiles.getMainFile());
        this.executeDirectoryName = this.getExecuteDirectoryName();
        this.log = this.controller.getLog();
        if (this.executorId.getClientType() != ClientType.Type.TEAM) {
            this.problemDataFiles = this.contest.getProblemDataFile(this.problem);
        }
    }

    private boolean clearDirectory(String dirName) {
        File dir = null;
        boolean result = true;
        dir = new File(dirName);
        String[] filesToRemove = dir.list();
        for (int i = 0; i < filesToRemove.length; ++i) {
            File fn1 = new File(dirName + File.separator + filesToRemove[i]);
            if (fn1.isDirectory()) {
                result &= this.clearDirectory(dirName + File.separator + filesToRemove[i]);
            }
            result &= fn1.delete();
        }
        return result;
    }

    public IFileViewer execute() {
        return this.execute(true);
    }

    public IFileViewer execute(boolean clearDirFirst) {
        this.fileViewer = new MultipleFileViewer(this.log);
        try {
            int errnoIndex;
            boolean cleared;
            this.executionData = new ExecutionData();
            this.executeDirectoryName = this.getExecuteDirectoryName();
            boolean dirThere = this.insureDir(this.executeDirectoryName);
            if (!dirThere) {
                this.log.config("Directory could not be created: " + this.executeDirectoryName);
                this.showDialogToUser("Unable to create directory " + this.executeDirectoryName);
                this.setException(this.executionData, "Unable to create directory " + this.executeDirectoryName);
                return this.fileViewer;
            }
            if (clearDirFirst && this.overwriteJudgesDataFiles && !(cleared = this.clearDirectory(this.executeDirectoryName))) {
                this.log.config("Directory could not be cleared, other process running? ");
                this.showDialogToUser("Unable to remove all files from directory " + this.executeDirectoryName);
                this.setException(this.executionData, "Unable to remove all files from directory " + this.executeDirectoryName);
                return this.fileViewer;
            }
            if (this.runFiles.getMainFile() != null) {
                this.createFile(this.runFiles.getMainFile(), this.prefixExecuteDirname(this.runFiles.getMainFile().getName()));
            }
            if (this.runFiles.getOtherFiles() != null) {
                for (SerializedFile file : this.runFiles.getOtherFiles()) {
                    if (file == null) continue;
                    this.createFile(file, this.prefixExecuteDirname(file.getName()));
                }
            }
            if (this.isTestRunOnly()) {
                if (this.compileProgram()) {
                    this.executeProgram(0);
                } else if (this.executionData.getCompileStderr() == null && this.executionData.getCompileStdout() == null) {
                    errnoIndex = this.errorString.indexOf(61) + 1;
                    String errorMessage = this.errorString.substring(errnoIndex).equals("2") ? "Compiler not found, contact staff." : "Problem executing compiler, contact staff.";
                    this.showDialogToUser(errorMessage);
                    this.setException(this.executionData, errorMessage);
                    this.fileViewer.addTextPane("Error during compile", errorMessage);
                }
            } else if (this.compileProgram()) {
                int dataSetNumber;
                SerializedFile[] dataFiles = null;
                if (this.problemDataFiles != null) {
                    dataFiles = this.problemDataFiles.getJudgesDataFiles();
                }
                if (dataFiles == null || dataFiles.length <= 1) {
                    if (this.executeProgram(dataSetNumber) && this.isValidated()) {
                        this.validateProgram(dataSetNumber);
                    }
                } else {
                    boolean passed = true;
                    for (dataSetNumber = 0; passed && dataSetNumber < dataFiles.length; ++dataSetNumber) {
                        passed = this.executeProgram(dataSetNumber) && this.isValidated() ? this.validateProgram(dataSetNumber) : false;
                    }
                }
            } else if (this.executionData.getCompileStderr() == null && this.executionData.getCompileStdout() == null) {
                errnoIndex = this.errorString.indexOf(61) + 1;
                String errorMessage = this.errorString.substring(errnoIndex).equals("2") ? "Compiler not found, contact staff." : "Problem executing compiler, contact staff.";
                this.showDialogToUser(errorMessage);
                this.setException(this.executionData, errorMessage);
                this.fileViewer.addTextPane("Error during compile", errorMessage);
            }
            this.fileViewer.setTitle("Executable");
            String outputFile = this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME);
            File file = new File(outputFile);
            boolean programGeneratedOutput = false;
            if (file.isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Program output", outputFile);
                programGeneratedOutput = true;
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Program stderr", outputFile);
                programGeneratedOutput = true;
            }
            if (!programGeneratedOutput) {
                this.fileViewer.addTextPane("Program output", "PC2: execution of program did not generate any output");
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Compiler stdout", outputFile);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(COMPILER_STDERR_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Compiler stderr", outputFile);
            }
            if (this.executionData.getExecuteExitValue() != 0) {
                long returnValue = (long)this.executionData.getExecuteExitValue() << 32 >>> 32;
                this.fileViewer.setInformationLabelText("<html><font size='+1' color='red'>Team program exit code = 0x" + Long.toHexString(returnValue).toUpperCase() + "</font>");
            } else {
                this.fileViewer.setInformationLabelText("");
            }
            if (!this.isTestRunOnly() && this.problem.isShowCompareWindow()) {
                String teamsOutputFileName = this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME);
                if (this.problem.getAnswerFileName() != null && this.problem.getAnswerFileName().length() > 0) {
                    String answerFileName = this.prefixExecuteDirname(this.problem.getAnswerFileName());
                    if (!new File(answerFileName).isFile()) {
                        int dataSetNumber = 0;
                        this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), dataSetNumber, answerFileName);
                    }
                    this.fileViewer.setCompareFileNames(answerFileName, teamsOutputFileName);
                    this.fileViewer.enableCompareButton(true);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception during execute() ", e);
            this.fileViewer.addTextPane("Error during execute", "Exception during execute, check log " + e.getMessage());
        }
        return this.fileViewer;
    }

    private void showDialogToUser(String string) {
        if (this.showMessageToUser) {
            this.fileViewer.showMessage(string);
        }
    }

    boolean insureDir(String dirName) {
        File dir = null;
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            this.log.log(Log.CONFIG, "Executable.execute(RunData): Directory " + dir.getName() + " could not be created.");
            this.setException(this.executionData, "Executable.execute(RunData): Directory " + dir.getName() + " could not be created.");
        }
        return dir.isDirectory();
    }

    private boolean validateProgram(int dataSetNumber) {
        this.executionData.setValidationReturnCode(-1L);
        this.executionData.setValidationSuccess(false);
        if (this.isJudge()) {
            this.controller.sendValidatingMessage(this.run);
        }
        if (this.problemDataFiles.getValidatorFile() != null) {
            String validatorFileName = this.problemDataFiles.getValidatorFile().getName();
            String validatorUnpackName = this.prefixExecuteDirname(validatorFileName);
            if (!this.createFile(this.problemDataFiles.getValidatorFile(), validatorUnpackName)) {
                this.log.info("Unable to create validator program " + validatorUnpackName);
                this.setException(this.executionData, "Unable to create validator program " + validatorUnpackName);
                throw new SecurityException("Unable to create validator, check logs");
            }
            if (!validatorFileName.endsWith(".jar")) {
                this.setExecuteBit(this.prefixExecuteDirname(validatorFileName));
            }
        }
        if (this.overwriteJudgesDataFiles) {
            this.createFile(this.problemDataFiles.getJudgesDataFiles(), dataSetNumber, this.prefixExecuteDirname(this.problem.getDataFileName()));
            this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), dataSetNumber, this.prefixExecuteDirname(this.problem.getAnswerFileName()));
        }
        SerializedFile userOutputFile = this.executionData.getExecuteProgramOutput();
        this.createFile(userOutputFile, this.prefixExecuteDirname(userOutputFile.getName()));
        String secs = new Long(new Date().getTime() % 100L).toString();
        String resultsFileName = this.run.getNumber() + secs + "XRSAM.txt";
        String commandPattern = this.problem.getValidatorCommandLine();
        if (this.problem.isUsingPC2Validator()) {
            String pathToPC2Jar = this.findPC2JarPath();
            commandPattern = "java -cp " + pathToPC2Jar + this.problem.getValidatorCommandLine();
        }
        this.log.log(Log.DEBUG, "before substitution: " + commandPattern);
        String cmdLine = this.substituteAllStrings(this.run, commandPattern);
        cmdLine = this.replaceString(cmdLine, "{:resfile}", resultsFileName);
        this.log.log(Log.DEBUG, "after  substitution: " + cmdLine);
        if (File.separator.equals("\\") && this.problem.isUsingPC2Validator()) {
            cmdLine = cmdLine.replaceFirst("-cp ", "-cp \"");
            cmdLine = cmdLine.replaceFirst("jar ", "jar\" ");
            this.log.log(Log.DEBUG, "after replaceFirst: " + cmdLine);
        }
        try {
            String actFilename = new String(cmdLine);
            int i = actFilename.trim().indexOf(" ");
            actFilename = i > -1 ? this.executeDirectoryName + actFilename.trim().substring(0, i) : this.executeDirectoryName + actFilename.trim();
            File f = new File(actFilename);
            if (f.exists()) {
                cmdLine = this.prefixExecuteDirname(cmdLine.trim());
            }
        }
        catch (Exception e) {
            this.setException(this.executionData, "Exception in validatorCall " + e.getMessage());
            this.log.log(Log.INFO, "Exception in validatorCall ", e);
            throw new SecurityException(e);
        }
        try {
            PrintWriter stdoutlog = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME), false), true);
            PrintWriter stderrlog = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME), false), true);
            String msg = "Working...";
            if (this.problem.isShowValidationToJudges()) {
                msg = "Validating...";
            }
            long startSecs = System.currentTimeMillis();
            Process process = this.runProgram(cmdLine, msg, false);
            if (process == null) {
                this.executionTimer.stopTimer();
                stderrlog.close();
                stdoutlog.close();
                return false;
            }
            BufferedReader childOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader childError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
            IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
            this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
            this.executionTimer.setProc(process);
            stdoutCollector.start();
            stderrCollector.start();
            stdoutCollector.join();
            stderrCollector.join();
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            } else {
                this.log.config("validatorCall() executionTimer == null");
            }
            if (process != null) {
                process.destroy();
            }
            stdoutlog.close();
            stderrlog.close();
            this.executionData.setvalidateTimeMS(System.currentTimeMillis() - startSecs);
            this.executionData.setValidationStdout(new SerializedFile(this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME)));
            this.executionData.setValidationStderr(new SerializedFile(this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME)));
        }
        catch (Exception ex) {
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.CONFIG, "Exception in validator ", ex);
        }
        boolean fileThere = new File(this.prefixExecuteDirname(resultsFileName)).exists();
        try {
            if (fileThere) {
                XMLResultsParser parser = new XMLResultsParser();
                parser.setLog(this.log);
                boolean done = parser.parseValidatorResultsFile(this.prefixExecuteDirname(resultsFileName));
                Hashtable<String, String> results = parser.getResults();
                if (done && results != null && results.containsKey("outcome")) {
                    if (!this.problem.isInternationalJudgementReadMethod() || results.containsKey("security") && resultsFileName.equals(results.get("security"))) {
                        this.executionData.setValidationResults(results.get("outcome"));
                        this.executionData.setValidationSuccess(true);
                    } else {
                        this.setException(this.executionData, "validationCall - results file did not contain security");
                        this.log.config("validationCall - results file did not contain security");
                        this.log.config(resultsFileName + " != " + results.get("security"));
                    }
                } else if (!done) {
                    this.setException(this.executionData, "Error parsing/reading results file, check log");
                    this.log.config("Error parsing/reading results file, check log");
                } else if (results != null && !results.containsKey("outcome")) {
                    this.setException(this.executionData, "Error parsing/reading results file, check log");
                    this.log.config("Error could not find 'outcome' in results file, check log");
                } else {
                    this.log.config("Error parsing results file, check log");
                }
            } else {
                this.log.config("validationCall - Did not produce output results file " + resultsFileName);
            }
        }
        catch (Exception ex) {
            this.log.log(Log.INFO, "Exception in validation  ", ex);
            throw new SecurityException(ex);
        }
        finally {
            if (this.executionData.isRunTimeLimitExceeded()) {
                this.executionData.setValidationResults("No - Time Limit Exceeded");
                this.executionData.setValidationSuccess(true);
            }
        }
        return this.executionData.isValidationSuccess();
    }

    private void setException(ExecutionData inExecutionData, String string) {
        inExecutionData.setExecutionException(new Exception(string));
    }

    private String findPC2JarPath() {
        String jarDir = ".." + File.separator + ".classes" + File.pathSeparator;
        try {
            String cp = System.getProperty("java.class.path");
            StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                File dir = new File(token);
                if (!dir.exists() || !dir.isFile() || !dir.toString().endsWith("pc2.jar")) continue;
                jarDir = new File(dir.getParent()).getCanonicalPath();
                break;
            }
        }
        catch (IOException e) {
            System.err.println("Trouble locating pc2home: " + e.getMessage());
        }
        return jarDir + File.separator;
    }

    private boolean isValidated() {
        return this.problem.isValidatedProblem() && !this.isTestRunOnly();
    }

    public String getFileNameFromUser() {
        String outFileName = null;
        JFileChooser chooser = new JFileChooser(this.mainFileDirectory);
        try {
            chooser.setDialogTitle("Open Test Input File");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                this.mainFileDirectory = chooser.getCurrentDirectory().getAbsolutePath();
                outFileName = chooser.getSelectedFile().getCanonicalFile().toString();
            }
        }
        catch (Exception e) {
            this.log.log(Log.CONFIG, "Error getting selected file, try again.", e);
        }
        chooser = null;
        return outFileName;
    }

    private void selectAndCopyDataFile(String inputFileName) throws Exception {
        String pickedFileName = this.getFileNameFromUser();
        if (pickedFileName != null) {
            SerializedFile data = new SerializedFile(pickedFileName);
            if (data.getBuffer() == null) {
                throw new Exception("datafile does not exist/can not be read " + pickedFileName);
            }
            this.createFile(data, inputFileName);
            Object var3_3 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeProgram(int dataSetNumber) {
        boolean passed = false;
        String inputDataFileName = null;
        try {
            if (this.isJudge()) {
                this.controller.sendExecutingMessage(this.run);
            }
            this.executionTimer = new ExecuteTimer(this.log, this.problem.getTimeOutInSeconds(), this.executorId);
            this.executionTimer.startTimer();
            if (this.problem.getDataFileName() != null) {
                if (this.problem.isReadInputDataFromSTDIN()) {
                    File output = File.createTempFile("__t", ".in", new File(this.getExecuteDirectoryName()));
                    inputDataFileName = this.prefixExecuteDirname(output.getName());
                    output.delete();
                } else {
                    inputDataFileName = this.prefixExecuteDirname(this.problem.getDataFileName());
                }
            }
            if (this.isTestRunOnly()) {
                if (this.problem.isReadInputDataFromSTDIN()) {
                    this.selectAndCopyDataFile(inputDataFileName);
                } else if (inputDataFileName != null) {
                    String sourceFileName = this.getDirName(this.runFiles.getMainFile()) + File.separator + this.problem.getDataFileName();
                    SerializedFile dataFile = new SerializedFile(sourceFileName);
                    if (dataFile != null) {
                        this.createFile(dataFile, inputDataFileName);
                    }
                    dataFile = null;
                }
                if (inputDataFileName != null && !new File(inputDataFileName).isFile()) {
                    if (this.executionTimer != null) {
                        this.executionTimer.stopTimer();
                    }
                    throw new SecurityException("Expected data file, was not created, file name is " + this.problem.getDataFileName());
                }
            } else if (inputDataFileName != null && this.problemDataFiles.getJudgesDataFiles() != null && this.overwriteJudgesDataFiles && !this.createFile(this.problemDataFiles.getJudgesDataFiles(), dataSetNumber, inputDataFileName)) {
                throw new SecurityException("Unable to create data file " + inputDataFileName);
            }
            PrintWriter stdoutlog = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME), false), true);
            PrintWriter stderrlog = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME), false), true);
            String cmdline = this.language.getProgramExecuteCommandLine();
            this.log.log(Log.DEBUG, "before substitution: " + cmdline);
            cmdline = this.substituteAllStrings(this.run, cmdline);
            this.log.log(Log.DEBUG, "after  substitution: " + cmdline);
            String actFilename = new String(cmdline);
            int i = actFilename.trim().indexOf(" ");
            actFilename = i > -1 ? this.prefixExecuteDirname(actFilename.trim().substring(0, i)) : this.prefixExecuteDirname(actFilename.trim());
            File f = new File(actFilename);
            if (f.exists()) {
                cmdline = f.getCanonicalPath();
            }
            boolean autoStop = false;
            if (!this.isTestRunOnly()) {
                autoStop = true;
            }
            long startSecs = System.currentTimeMillis();
            Process process = this.runProgram(cmdline, "Executing...", autoStop);
            if (process == null) {
                this.executionTimer.stopTimer();
                stderrlog.close();
                stdoutlog.close();
                this.executionData.setExecuteSucess(false);
                return false;
            }
            BufferedReader childOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader childError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
            IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
            this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
            this.executionTimer.setProc(process);
            stdoutCollector.start();
            stderrCollector.start();
            if (this.isValidDataFile(this.problem) && this.problem.isReadInputDataFromSTDIN()) {
                OutputStream outs = process.getOutputStream();
                PrintWriter pwOut = new PrintWriter(outs);
                FileReader fileReader = new FileReader(inputDataFileName);
                BufferedReader in = new BufferedReader(fileReader);
                int theChar = in.read();
                while (theChar != -1) {
                    pwOut.print((char)theChar);
                    theChar = in.read();
                }
                fileReader.close();
                pwOut.close();
                outs.close();
            }
            stdoutCollector.join();
            stderrCollector.join();
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
                this.executionData.setRunTimeLimitExceeded(this.executionTimer.isRunTimeLimitExceeded());
            }
            if (process != null) {
                int returnValue = process.waitFor();
                this.executionData.setExecuteExitValue(returnValue);
                process.destroy();
            }
            stdoutlog.close();
            stderrlog.close();
            this.executionData.setExecuteSucess(true);
            this.executionData.setExecuteTimeMS(System.currentTimeMillis() - startSecs);
            this.executionData.setExecuteProgramOutput(new SerializedFile(this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME)));
            this.executionData.setExecuteStderr(new SerializedFile(this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME)));
            if (this.executionData.getExecuteExitValue() != 0) {
                long returnValue = (long)this.executionData.getExecuteExitValue() << 32 >>> 32;
                PrintWriter exitCodeFile = null;
                try {
                    exitCodeFile = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname("EXITCODE.TXT"), false), true);
                    exitCodeFile.write("0x" + Long.toHexString(returnValue).toUpperCase());
                }
                catch (FileNotFoundException e) {
                    StaticLog.log("Unable to open file EXITCODE.TXT", e);
                    exitCodeFile = null;
                }
                finally {
                    if (exitCodeFile != null) {
                        exitCodeFile.close();
                    }
                }
            }
            passed = true;
        }
        catch (Exception e) {
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.INFO, "executeProgram() Exception ", e);
            throw new SecurityException(e);
        }
        return passed;
    }

    private boolean isValidDataFile(Problem inProblem) {
        boolean result = false;
        if (inProblem.getDataFileName() != null && inProblem.getDataFileName().trim().length() > 0) {
            result = true;
        }
        return result;
    }

    private boolean isJudge() {
        return this.contest.getClientId().getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean compileProgram() {
        try {
            String programName;
            File program;
            if (this.isJudge()) {
                this.controller.sendCompilingMessage(this.run);
            }
            if ((program = new File(this.prefixExecuteDirname(programName = this.replaceString(this.language.getExecutableIdentifierMask(), "{:basename}", this.removeExtension(this.runFiles.getMainFile().getName()))))).exists()) {
                this.log.config("Team submitted an executable " + programName);
                program.delete();
            }
            this.log.log(Log.DEBUG, "before substitution: " + this.language.getCompileCommandLine());
            String cmdline = this.substituteAllStrings(this.run, this.language.getCompileCommandLine());
            this.log.log(Log.DEBUG, "after  substitution: " + cmdline);
            PrintWriter stdoutlog = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME), false), true);
            PrintWriter stderrlog = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(COMPILER_STDERR_FILENAME), false), true);
            this.executionTimer = new ExecuteTimer(this.log, this.problem.getTimeOutInSeconds(), this.executorId);
            this.executionTimer.startTimer();
            long startSecs = System.currentTimeMillis();
            Process process = this.runProgram(cmdline, "Compiling...", false);
            if (process == null) {
                this.executionTimer.stopTimer();
                stderrlog.close();
                stdoutlog.close();
                this.executionData.setCompileExeFileName("");
                this.executionData.setCompileSuccess(false);
                this.executionData.setCompileResultCode(1L);
                return false;
            }
            BufferedReader childOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader childError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
            IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
            this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
            this.executionTimer.setProc(process);
            stdoutCollector.start();
            stderrCollector.start();
            stdoutCollector.join();
            stderrCollector.join();
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            } else {
                this.log.config("compileCall() executionTimer == null");
            }
            if (process != null) {
                process.destroy();
            }
            stdoutlog.close();
            stderrlog.close();
            this.executionData.setCompileTimeMS(System.currentTimeMillis() - startSecs);
            this.executionData.setCompileStdout(new SerializedFile(this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME)));
            this.executionData.setCompileStderr(new SerializedFile(this.prefixExecuteDirname(COMPILER_STDERR_FILENAME)));
            program = new File(this.prefixExecuteDirname(programName));
            if (program.exists()) {
                this.executionData.setCompileExeFileName(programName);
                this.executionData.setCompileSuccess(true);
                this.executionData.setCompileResultCode(0L);
                return true;
            }
            this.executionData.setCompileExeFileName("");
            this.executionData.setCompileSuccess(false);
            this.executionData.setCompileResultCode(2L);
            return false;
        }
        catch (Exception e) {
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.INFO, "Exception ", e);
            throw new SecurityException(e);
        }
    }

    private long getMaxFileSize() {
        return this.contest.getContestInformation().getMaxFileSize();
    }

    public String replaceString(String origString, String beforeString, String afterString) {
        if (origString == null) {
            return origString;
        }
        int startIdx = origString.lastIndexOf(beforeString);
        if (startIdx == -1) {
            return origString;
        }
        StringBuffer buf = new StringBuffer(origString);
        while (startIdx != -1) {
            buf.replace(startIdx, startIdx + beforeString.length(), afterString);
            startIdx = origString.lastIndexOf(beforeString, startIdx - 1);
        }
        return buf.toString();
    }

    public String replaceString(String origString, String beforeString, int afterInt) {
        String afterString = new Integer(afterInt).toString();
        return this.replaceString(origString, beforeString, afterString);
    }

    public String substituteAllStrings(Run inRun, String origString) {
        String newString = "";
        String nullArgument = "-";
        try {
            String pc2home;
            int i;
            int index;
            SerializedFile validatorFile;
            if (inRun == null) {
                throw new IllegalArgumentException("Run is null");
            }
            if (this.runFiles.getMainFile() == null) {
                this.log.config("substituteAllStrings() main file is null (no contents)");
                return origString;
            }
            newString = this.replaceString(origString, "{:mainfile}", this.runFiles.getMainFile().getName());
            newString = this.replaceString(newString, "{:basename}", this.removeExtension(this.runFiles.getMainFile().getName()));
            String validatorCommand = null;
            if (this.problem.getValidatorProgramName() != null) {
                validatorCommand = this.problem.getValidatorProgramName();
            }
            if (this.problemDataFiles != null && (validatorFile = this.problemDataFiles.getValidatorFile()) != null) {
                validatorCommand = validatorFile.getName();
            }
            if (validatorCommand != null) {
                newString = this.replaceString(newString, "{:validator}", validatorCommand);
            }
            if (inRun.getLanguageId() != null) {
                Language[] langs = this.contest.getLanguages();
                index = 0;
                for (i = 0; i < langs.length; ++i) {
                    if (langs[i] == null || !langs[i].getElementId().equals(inRun.getLanguageId())) continue;
                    index = i + 1;
                    break;
                }
                if (index > 0) {
                    newString = this.replaceString(newString, "{:language}", index);
                    newString = this.replaceString(newString, "{:languageletter}", Utilities.convertNumber(index));
                }
            }
            if (inRun.getProblemId() != null) {
                Problem[] problems = this.contest.getProblems();
                index = 0;
                for (i = 0; i < problems.length; ++i) {
                    if (problems[i] == null || !problems[i].getElementId().equals(inRun.getProblemId())) continue;
                    index = i + 1;
                    break;
                }
                if (index > 0) {
                    newString = this.replaceString(newString, "{:problem}", index);
                    newString = this.replaceString(newString, "{:problemletter}", Utilities.convertNumber(index));
                }
            }
            if (inRun.getSubmitter() != null) {
                newString = this.replaceString(newString, "{:teamid}", inRun.getSubmitter().getClientNumber());
                newString = this.replaceString(newString, "{:siteid}", inRun.getSubmitter().getSiteNumber());
            }
            if (this.problem != null) {
                newString = this.problem.getDataFileName() != null && !this.problem.getDataFileName().equals("") ? this.replaceString(newString, "{:infile}", this.problem.getDataFileName()) : this.replaceString(newString, "{:infile}", nullArgument);
                newString = this.problem.getAnswerFileName() != null && !this.problem.getAnswerFileName().equals("") ? this.replaceString(newString, "{:ansfile}", this.problem.getAnswerFileName()) : this.replaceString(newString, "{:ansfile}", nullArgument);
                newString = this.replaceString(newString, "{:timelimit}", Long.toString(this.problem.getTimeOutInSeconds()));
            } else {
                this.log.config("substituteAllStrings() problem is undefined (null)");
            }
            if (this.executionData != null) {
                if (this.executionData.getExecuteProgramOutput() != null) {
                    newString = this.executionData.getExecuteProgramOutput().getName() != null ? this.replaceString(newString, "{:outfile}", this.executionData.getExecuteProgramOutput().getName()) : this.replaceString(newString, "{:outfile}", nullArgument);
                }
                newString = this.replaceString(newString, "{:exitvalue}", Integer.toString(this.executionData.getExecuteExitValue()));
                newString = this.replaceString(newString, "{:executetime}", Long.toString(this.executionData.getExecuteTimeMS()));
            }
            if ((pc2home = new VersionInfo().locateHome()) != null && pc2home.length() > 0) {
                newString = this.replaceString(newString, "{:pc2home}", pc2home);
            }
        }
        catch (Exception e) {
            this.log.log(Log.CONFIG, "Exception ", e);
        }
        return newString;
    }

    public String removeExtension(String original) {
        String outString = new String(original);
        int dotIndex = outString.lastIndexOf(46, outString.length() - 1);
        if (dotIndex != -1) {
            outString = outString.substring(0, dotIndex);
        }
        return outString;
    }

    private String getDirName(SerializedFile file) {
        String absPath = file.getAbsolutePath();
        return absPath.substring(0, absPath.length() - 1 - file.getName().length());
    }

    public Process runProgram(String cmdline, String msg, boolean autoStopExecution) {
        Process process = null;
        this.errorString = "";
        this.executeDirectoryName = this.getExecuteDirectoryName();
        try {
            File runDir = new File(this.executeDirectoryName);
            if (runDir.isDirectory()) {
                this.log.config("executing: '" + cmdline + "'");
                String[] env = null;
                if (this.executionTimer != null) {
                    this.executionTimer.setDoAutoStop(autoStopExecution);
                    this.executionTimer.setTitle(msg);
                }
                process = Runtime.getRuntime().exec(cmdline, env, runDir);
                if (this.executionTimer != null) {
                    this.executionTimer.setProc(process);
                    this.executionTimer.startTimer();
                }
            } else {
                this.errorString = "Execute Directory does not exist";
                this.log.config("Execute Directory does not exist");
            }
        }
        catch (IOException e) {
            this.errorString = e.getMessage();
            this.log.config("Note: exec failed in RunProgram " + this.errorString);
            return null;
        }
        catch (Exception e) {
            this.errorString = e.getMessage();
            this.log.log(Log.CONFIG, "Note: exec failed in RunProgram " + this.errorString, e);
            return null;
        }
        return process;
    }

    private void setExecuteBit(String filename) {
        this.log.config("setExecuteBit for " + filename);
        try {
            File chmodFile = new File("/bin/chmod");
            if (chmodFile.exists()) {
                String cmdline = "/bin/chmod +x " + filename;
                this.log.config("executing chmod: '" + cmdline + "'");
                Process process = Runtime.getRuntime().exec(cmdline);
                process.waitFor();
            }
        }
        catch (Exception ex) {
            this.log.log(Log.CONFIG, "Exception in setExecuteBit()  ", ex);
        }
    }

    boolean createFile(SerializedFile[] fileList, int setNumber, String outputFileName) {
        if (fileList != null && setNumber < fileList.length) {
            return this.createFile(fileList[setNumber], outputFileName);
        }
        return false;
    }

    boolean createFile(SerializedFile file, String outputFileName) {
        try {
            if (file != null && outputFileName != null) {
                file.writeFile(outputFileName);
                return new File(outputFileName).isFile();
            }
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception creating file " + outputFileName, e);
        }
        return false;
    }

    public String getValidationResults() {
        return this.executionData.getValidationResults();
    }

    public ExecutionData getExecutionData() {
        return this.executionData;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public String getExecuteDirectoryName() {
        return "executesite" + this.contest.getClientId().getSiteNumber() + this.contest.getClientId().getName() + this.getExecuteDirectoryNameSuffix();
    }

    public String prefixExecuteDirname(String filename) {
        return this.getExecuteDirectoryName() + File.separator + filename;
    }

    public boolean isOverwriteJudgesDataFiles() {
        return this.overwriteJudgesDataFiles;
    }

    public void setOverwriteJudgesDataFiles(boolean overwriteDataFiles) {
        this.overwriteJudgesDataFiles = overwriteDataFiles;
    }

    public boolean isTestRunOnly() {
        return this.testRunOnly || this.executorId.getClientType() == ClientType.Type.TEAM;
    }

    public void setTestRunOnly(boolean testRunOnly) {
        this.testRunOnly = testRunOnly || this.executorId.getClientType() == ClientType.Type.TEAM;
    }

    public boolean isValidationSuccess() {
        return this.executionData.isValidationSuccess();
    }

    public boolean isShowMessageToUser() {
        return this.showMessageToUser;
    }

    public void setShowMessageToUser(boolean showMessageToUser) {
        this.showMessageToUser = showMessageToUser;
    }

    public String getExecuteDirectoryNameSuffix() {
        return this.executeDirectoryNameSuffix;
    }

    public void setExecuteDirectoryNameSuffix(String executeDirectoryNameSuffix) {
        this.executeDirectoryNameSuffix = executeDirectoryNameSuffix;
    }
}

