/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.archive;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.ParseArguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipPC2 {
    private String zipFileName = "";
    private String date = "";
    private Hashtable<String, String> filesToInclude = new Hashtable();
    private Hashtable<String, Long> lastModified = new Hashtable();
    private String comment = "";

    public ZipPC2() {
        String newname = this.zipFileName = this.createZipFileName();
        while (newname.indexOf(" ") > 0) {
            newname = newname.replace(' ', '-');
        }
        this.zipFileName = newname;
        this.date = this.getDate();
        this.zipFileName = this.date + "-" + this.zipFileName + ".zip";
    }

    private String createZipFileName() {
        this.zipFileName = "pc2archive";
        if (IniFile.isFilePresent()) {
            new IniFile();
            this.zipFileName = IniFile.containsKey("global.archive") ? IniFile.getValue("global.archive") : (IniFile.containsKey("server.site") ? IniFile.getValue("server.site") : (IniFile.containsKey("client.site") ? IniFile.getValue("client.site") : "pc2archive"));
        }
        return this.zipFileName;
    }

    public void addDirToList(String dirName) {
        File file = new File(dirName);
        String fileName = "";
        if (file.exists() && file.isDirectory()) {
            String[] fileList = file.list();
            for (int i = 0; i < fileList.length; ++i) {
                fileName = dirName + File.separator + fileList[i];
                file = new File(fileName);
                if (file.isDirectory()) {
                    this.addDirToList(fileName);
                    continue;
                }
                this.addFileToList(fileName);
            }
        }
    }

    public void addFileToList(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            this.filesToInclude.put(fileName, fileName);
            this.lastModified.put(fileName, new Long(file.lastModified()));
        }
    }

    private void buildFileList() {
        String[] simpleFileExtensions = new String[]{"log", "html", "ini", "set", "tab", "tpl", "properties"};
        File file = new File(".");
        String[] dirEntryList = file.list();
        for (int i = 0; i < dirEntryList.length; ++i) {
            String dirEntryName = dirEntryList[i];
            file = new File(dirEntryName);
            for (String name : simpleFileExtensions) {
                if (!dirEntryName.endsWith(name)) continue;
                this.addFileToList(dirEntryName);
            }
            if (dirEntryName.equalsIgnoreCase("logs")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.equalsIgnoreCase("packets")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.equalsIgnoreCase("html")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.startsWith("db.")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.startsWith("execute")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.equalsIgnoreCase("reports")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.equalsIgnoreCase("old")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (dirEntryName.equalsIgnoreCase("data")) {
                this.addDirToList(dirEntryName);
                continue;
            }
            if (!dirEntryName.equalsIgnoreCase("profiles")) continue;
            this.addDirToList(dirEntryName);
        }
        this.addFileToList("score.dat");
        this.addFileToList("results.xml");
        this.addFileToList("pc2export.dat");
    }

    public String createArchive() {
        byte[] b = new byte[1024];
        try {
            this.buildFileList();
            String[] fileList = this.sortFileList();
            if (fileList == null || fileList.length <= 0) {
                ZipPC2.writelog("No files to archive");
                return null;
            }
            File dir = new File("archive");
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (dir.exists() && dir.isDirectory()) {
                this.zipFileName = "archive" + File.separatorChar + this.zipFileName;
            }
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.zipFileName));
            zip.setComment(this.comment);
            String inputFile = "";
            Long o2 = null;
            int seq = 0;
            int count = 0;
            ZipPC2.writelog("Creating " + this.zipFileName);
            for (int i = 0; i < fileList.length; ++i) {
                try {
                    inputFile = fileList[i];
                    ZipPC2.writelog("Adding " + inputFile);
                    FileInputStream in = new FileInputStream(inputFile);
                    ZipEntry ze = new ZipEntry(inputFile);
                    zip.putNextEntry(ze);
                    while (in.available() > 0) {
                        ++seq;
                        count = in.available();
                        if (count >= 1024) {
                            count = 1024;
                            in.read(b);
                        } else {
                            in.read(b, 0, count);
                        }
                        zip.write(b, 0, count);
                    }
                    if (this.filesToInclude == null) {
                        ZipPC2.writelog("filesToInclude is null");
                    }
                    if ((o2 = this.lastModified.get(inputFile)) != null) {
                        ze.setTime(o2);
                    } else {
                        ZipPC2.writelog("Last modified date for " + inputFile + " could not be determined");
                    }
                    in.close();
                    zip.closeEntry();
                    count = 0;
                    seq = 0;
                    inputFile = "";
                    continue;
                }
                catch (Exception e) {
                    ZipPC2.writelog("error (" + inputFile + " seq=" + seq + ",count=" + count + ") " + e.getMessage(), e);
                }
            }
            ZipPC2.writelog("Closing " + this.zipFileName);
            zip.close();
        }
        catch (Exception e) {
            ZipPC2.writelog("error creating " + this.zipFileName + ": " + e.getMessage(), e);
        }
        return this.zipFileName;
    }

    public String createArchive(Vector<String> listOFiles, boolean packStdFilesToo) {
        byte[] b = new byte[1024];
        try {
            if (listOFiles == null) {
                ZipPC2.writelog("createArchive(Vector, boolean), Vector is null ");
                return null;
            }
            if (packStdFilesToo) {
                this.buildFileList();
            }
            if (this.filesToInclude.size() == 0) {
                ZipPC2.writelog("createArchive(Vector, boolean), no files to archive ");
                return null;
            }
            for (int i = 0; i < listOFiles.size(); ++i) {
                String filename = listOFiles.elementAt(i);
                File file = new File(filename);
                if (file.isFile()) {
                    this.addFileToList(filename);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.addDirToList(filename);
            }
            String[] fileList = this.sortFileList();
            if (fileList == null || fileList.length <= 0) {
                ZipPC2.writelog("No files to archive");
                return null;
            }
            File dir = new File("archive");
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (dir.exists() && dir.isDirectory()) {
                this.zipFileName = "archive" + File.separatorChar + this.zipFileName;
            }
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.zipFileName));
            zip.setComment(this.comment);
            String inputFile = "";
            Long o2 = null;
            int seq = 0;
            int count = 0;
            ZipPC2.writelog("Creating " + this.zipFileName);
            for (int i = 0; i < fileList.length; ++i) {
                try {
                    inputFile = fileList[i];
                    ZipPC2.writelog("Adding " + inputFile);
                    FileInputStream in = new FileInputStream(inputFile);
                    ZipEntry ze = new ZipEntry(inputFile);
                    zip.putNextEntry(ze);
                    while (in.available() > 0) {
                        ++seq;
                        count = in.available();
                        if (count >= 1024) {
                            count = 1024;
                            in.read(b);
                        } else {
                            in.read(b, 0, count);
                        }
                        zip.write(b, 0, count);
                    }
                    if (this.filesToInclude == null) {
                        ZipPC2.writelog("filesToInclude is null");
                    }
                    if ((o2 = this.lastModified.get(inputFile)) != null) {
                        ze.setTime(o2);
                    } else {
                        ZipPC2.writelog("Last modified date for " + inputFile + " could not be determined");
                    }
                    in.close();
                    zip.closeEntry();
                    count = 0;
                    seq = 0;
                    inputFile = "";
                    continue;
                }
                catch (Exception e) {
                    ZipPC2.writelog("error (" + inputFile + " seq=" + seq + ",count=" + count + ") " + e.getMessage(), e);
                }
            }
            ZipPC2.writelog("Closing " + this.zipFileName);
            zip.close();
        }
        catch (Exception e) {
            ZipPC2.writelog("CreateArchive: error creating " + this.zipFileName + ": " + e.getMessage(), e);
            return null;
        }
        return this.zipFileName;
    }

    private String getDate() {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        GregorianCalendar cal = new GregorianCalendar(tz);
        this.comment = "Create by PC^2 " + new VersionInfo().getSystemVersionInfo() + " " + cal.getTime().toString();
        DecimalFormat df = new DecimalFormat("00");
        StringBuffer t = new StringBuffer();
        StringBuffer dateSB = df.format((long)cal.get(1), t, new FieldPosition(0));
        dateSB = df.format((long)(cal.get(2) + 1), t, new FieldPosition(0));
        dateSB = df.format((long)cal.get(5), t, new FieldPosition(0));
        dateSB = df.format((long)cal.get(11), t, new FieldPosition(0));
        dateSB = df.format((long)cal.get(12), t, new FieldPosition(0));
        return dateSB.toString();
    }

    public static void main(String[] args) {
        ParseArguments pa = null;
        try {
            String[] reqArgs = new String[]{"--ini"};
            pa = new ParseArguments(args, reqArgs);
            if (pa.isOptPresent("--help") || pa.isOptPresent("-h")) {
                System.out.println();
                System.out.println("Usage:  ZipPC2 [OPTION] [dirs|files]");
                System.out.println("Creates a zip of the specified dirs & files");
                System.out.println();
                System.out.println("  -h, --help     display this help and exit");
                System.out.println("      --ini FILE file or URL for (defaults to pc2v8.ini)");
                System.out.println("  -v, --version  output version information and exit");
                System.out.println();
                System.exit(0);
            }
            if (pa.isOptPresent("-v") || pa.isOptPresent("--version")) {
                VersionInfo sri = new VersionInfo();
                System.out.println(sri.getSystemName());
                System.out.println(sri.getContactEMail());
                System.out.println(sri.getSystemVersionInfo());
                System.exit(0);
            }
            if (pa.isOptPresent("--ini") && pa.getOptValue("--ini") != null && pa.getOptValue("--ini").length() > 0) {
                IniFile.setIniURLorFile(pa.getOptValue("--ini"));
            }
        }
        catch (Exception ex99) {
            ZipPC2.writelog("Exception ", ex99);
            System.exit(99);
        }
        ZipPC2 aZipPC2 = new ZipPC2();
        for (int i = 0; i < args.length; ++i) {
            String filename = args[i];
            File file = new File(filename);
            if (file.isFile()) {
                aZipPC2.addFileToList(filename);
                continue;
            }
            if (!file.isDirectory()) continue;
            aZipPC2.addDirToList(filename);
        }
        String arcFileName = aZipPC2.createArchive();
        if (arcFileName == null) {
            ZipPC2.writelog("Could not create archive ");
        }
    }

    private String[] sortFileList() {
        Enumeration<String> enumeration = this.filesToInclude.elements();
        String[] strings = new String[this.filesToInclude.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String s = enumeration.nextElement();
            if (s == null) continue;
            strings[i++] = s;
        }
        if (strings.length <= 1) {
            return strings;
        }
        Arrays.sort(strings, new StringIgnoreCaseComparator());
        return strings;
    }

    private static void writelog(String str) {
        ZipPC2.writelog(str, null);
    }

    private static void writelog(String str, Exception ex) {
        Date d = new Date();
        System.err.println(d + " " + str);
        if (ex != null) {
            ex.printStackTrace(System.err);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StringIgnoreCaseComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8901841329708366388L;

        protected StringIgnoreCaseComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    }
}

