/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.archive;

import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileComparatorByName;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;

public final class PacketFormatter {
    private PacketFormatter() {
    }

    public static String summaryFormat(Packet packet) {
        StringBuffer buffer = new StringBuffer();
        Object obj = packet.getContent();
        if (obj instanceof Properties) {
            Properties prop = (Properties)obj;
            Enumeration<Object> enumeration = prop.keys();
            while (enumeration.hasMoreElements()) {
                String element = (String)enumeration.nextElement();
                String className = prop.get(element).getClass().getName();
                className = className.replaceFirst("edu.csus.ecs.pc2.core.model.", "");
                className = className.replaceFirst("edu.csus.ecs.pc2.core.", "");
                buffer.append(className);
                buffer.append(' ');
                if (prop.size() != 1) continue;
                buffer.append(prop.get(element));
            }
        } else {
            buffer.append("  Contains: ");
            buffer.append(obj.toString());
            buffer.append(' ');
            buffer.append(obj);
        }
        return buffer.toString();
    }

    public static DefaultMutableTreeNode buildContentTree(DefaultMutableTreeNode node, Packet packet) {
        DefaultMutableTreeNode subNode = null;
        Object obj = packet.getContent();
        if (obj instanceof Properties) {
            Properties prop = (Properties)obj;
            Object[] keys = prop.keySet().toArray(new String[prop.keySet().size()]);
            Arrays.sort(keys);
            subNode = new DefaultMutableTreeNode(new ObjectWrapper("Created", packet.getCreateDate()));
            node.add(subNode);
            for (Object name : keys) {
                subNode = PacketFormatter.createTree((String)name + " ", prop.get(name));
                if (subNode == null) {
                    subNode = new DefaultMutableTreeNode(new ObjectWrapper((String)name, prop.get(name)));
                }
                node.add(subNode);
            }
        } else {
            subNode = new DefaultMutableTreeNode(new ObjectWrapper(obj.getClass().getName(), obj));
            node.add(subNode);
        }
        return node;
    }

    private static DefaultMutableTreeNode createTree(String key, Object object) {
        if (object instanceof Profile) {
            Profile profile = (Profile)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Profile: " + profile.getName());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("description = " + profile.getDescription());
            node.add(child);
            child = new DefaultMutableTreeNode("path = " + profile.getProfilePath());
            node.add(child);
            child = new DefaultMutableTreeNode("contest Id = " + profile.getContestId());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + profile.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof Site) {
            DefaultMutableTreeNode child;
            Site site = (Site)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Site: " + site.getSiteNumber() + " title: " + site.getDisplayName());
            Properties connectionInfo = site.getConnectionInfo();
            Enumeration<Object> enumeration = connectionInfo.keys();
            while (enumeration.hasMoreElements()) {
                String siteKey = (String)enumeration.nextElement();
                String value = (String)connectionInfo.get(siteKey);
                child = new DefaultMutableTreeNode(siteKey + "=" + value);
                node.add(child);
            }
            child = new DefaultMutableTreeNode(key + "ElementId: " + site.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof Profile[]) {
            Profile[] profiles = (Profile[])object;
            Arrays.sort(profiles, new ProfileComparatorByName());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Profile list: " + profiles.length + " profiles");
            for (Profile profile : profiles) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", profile);
                node.add(child);
            }
            return node;
        }
        if (object instanceof Account[]) {
            DefaultMutableTreeNode child;
            Account[] accounts = (Account[])object;
            Arrays.sort(accounts, new AccountComparator());
            String breakdown = PacketFormatter.getAccountBreakdown(accounts);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Account list: " + accounts.length + " accounts total.  " + breakdown);
            int maxSitesForAccounts = PacketFormatter.getNumberOfSites(accounts);
            if (maxSitesForAccounts > 1) {
                for (int i = 0; i < maxSitesForAccounts; ++i) {
                    breakdown = PacketFormatter.getAccountBreakdown(accounts, i + 1);
                    child = new DefaultMutableTreeNode("  Site: " + (i + 1) + " " + breakdown);
                    node.add(child);
                }
            }
            for (Account account : accounts) {
                child = PacketFormatter.createTree("", account);
                node.add(child);
            }
            return node;
        }
        if (object instanceof ClientId[]) {
            ClientId[] clientIds = (ClientId[])object;
            Arrays.sort(clientIds, new ClientIdComparator());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ClientId list: " + clientIds.length + " ClientIds");
            for (ClientId clientId : clientIds) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", clientId);
                node.add(child);
            }
            return node;
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar calendar = (GregorianCalendar)object;
            long secondsOffset = calendar.getTime().getTime() / 1000L;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Date offset: " + secondsOffset);
            return node;
        }
        if (object instanceof Account) {
            Account account = (Account)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Account: " + account);
            DefaultMutableTreeNode child = PacketFormatter.createTree("", account.getClientId());
            node.add(child);
            child = new DefaultMutableTreeNode("     Name: " + account.getDisplayName());
            node.add(child);
            child = new DefaultMutableTreeNode("    Group: " + account.getGroupId());
            node.add(child);
            child = new DefaultMutableTreeNode("     Site: " + account.getSiteNumber());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + account.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof ClientId) {
            ClientId clientId = (ClientId)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Client Id: " + clientId.getClientType().toString() + " " + clientId.getClientNumber());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("  Triplet: " + clientId.getTripletKey());
            node.add(child);
            child = new DefaultMutableTreeNode("     Site: " + clientId.getSiteNumber());
            node.add(child);
            return node;
        }
        if (object instanceof Language) {
            Language language = (Language)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Language: " + language.getDisplayName());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Name: " + language.getDisplayName());
            node.add(child);
            child = new DefaultMutableTreeNode("Compile: " + language.getCompileCommandLine());
            node.add(child);
            child = new DefaultMutableTreeNode("Executable Mask: " + language.getExecutableIdentifierMask());
            node.add(child);
            child = new DefaultMutableTreeNode("Execute: " + language.getProgramExecuteCommandLine());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + language.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof Judgement) {
            Judgement judgement = (Judgement)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Judgement: " + judgement.getDisplayName());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("ElementId: " + judgement.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof ContestTime[]) {
            ContestTime[] times = (ContestTime[])object;
            Arrays.sort(times, new ContestTimeComparator());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ContestTimes list: " + times.length + " times.");
            for (ContestTime time : times) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", time);
                node.add(child);
            }
            return node;
        }
        if (object instanceof ContestTime) {
            ContestTime contestTime = (ContestTime)object;
            String status = "STOPPED";
            if (contestTime.isContestRunning()) {
                status = "RUNNING";
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ContestTime: Site " + contestTime.getSiteNumber() + " " + status + " remaining " + contestTime.getRemainingTimeStr());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Remaining: " + contestTime.getRemainingTimeStr());
            node.add(child);
            child = new DefaultMutableTreeNode("   Length: " + contestTime.getContestLengthStr());
            node.add(child);
            child = new DefaultMutableTreeNode("  Elapsed: " + contestTime.getElapsedTimeStr());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + contestTime.getElementId().toString());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + contestTime.getElementId().toString());
            node.add(child);
            return node;
        }
        return PacketFormatter.createOtherTrees(key, object);
    }

    protected static void addNonNull(DefaultMutableTreeNode node, DefaultMutableTreeNode child) {
        if (child != null) {
            node.add(child);
        }
    }

    protected static String getAccountBreakdown(Account[] accounts) {
        return PacketFormatter.getAccountBreakdown(accounts, 0);
    }

    protected static int getNumberOfSites(Account[] accounts) {
        int num = 0;
        for (Account account : accounts) {
            num = Math.max(num, account.getSiteNumber());
        }
        return num;
    }

    protected static String getAccountBreakdown(Account[] accounts, int siteNumber) {
        ClientType.Type[] types;
        int[] totals = new int[ClientType.Type.values().length];
        for (Account account : accounts) {
            if (siteNumber != 0 && siteNumber != account.getSiteNumber()) continue;
            ClientType.Type type = account.getClientId().getClientType();
            int n = type.ordinal();
            totals[n] = totals[n] + 1;
        }
        StringBuffer sb = new StringBuffer();
        int totalAccountsFound = 0;
        for (ClientType.Type type : types = ClientType.Type.values()) {
            int count = totals[type.ordinal()];
            if (count <= 0) continue;
            totalAccountsFound += count;
            sb.append(count);
            sb.append(' ');
            sb.append((Object)type);
            sb.append(' ');
        }
        if (totalAccountsFound == 0) {
            return "no accounts";
        }
        return new String(sb).trim();
    }

    private static DefaultMutableTreeNode createOtherTrees(String key, Object object) {
        if (object instanceof Run) {
            Run run = (Run)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + " Run: " + run);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("      Team: " + run.getSubmitter());
            node.add(child);
            child = new DefaultMutableTreeNode("   elapsed: " + run.getElapsedMins());
            node.add(child);
            child = new DefaultMutableTreeNode("    Solved: " + run.isSolved());
            node.add(child);
            child = new DefaultMutableTreeNode("   Problem: " + run.getProblemId());
            node.add(child);
            child = new DefaultMutableTreeNode("    Judged: " + run.isJudged());
            node.add(child);
            child = new DefaultMutableTreeNode(" Send2Team: " + run.isSendToTeams());
            node.add(child);
            child = new DefaultMutableTreeNode("    Deleted: " + run.isDeleted());
            node.add(child);
            child = new DefaultMutableTreeNode("   Language: " + run.getLanguageId());
            node.add(child);
            child = new DefaultMutableTreeNode("  ElementId: " + run.isDeleted());
            node.add(child);
            return node;
        }
        if (object instanceof Clarification) {
            Clarification clarification = (Clarification)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Clarification: " + clarification);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("      Team: " + clarification.getSubmitter());
            node.add(child);
            child = new DefaultMutableTreeNode("   elapsed: " + clarification.getElapsedMins());
            node.add(child);
            child = new DefaultMutableTreeNode("   Problem: " + clarification.getProblemId());
            node.add(child);
            child = new DefaultMutableTreeNode("  Answered: " + clarification.isAnswered());
            node.add(child);
            child = new DefaultMutableTreeNode("   For All: " + clarification.isSendToAll());
            node.add(child);
            child = new DefaultMutableTreeNode("  ElementId: " + clarification.isDeleted());
            node.add(child);
            return node;
        }
        if (object instanceof Problem) {
            Problem problem = (Problem)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Problem: " + problem.getDisplayName());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Name: " + problem.getDisplayName());
            node.add(child);
            child = new DefaultMutableTreeNode("AnswerFileName " + problem.getAnswerFileName());
            node.add(child);
            child = new DefaultMutableTreeNode("DataFileName " + problem.getDataFileName());
            node.add(child);
            child = new DefaultMutableTreeNode("Active " + problem.isActive());
            node.add(child);
            child = new DefaultMutableTreeNode("ComputerJudged " + problem.isComputerJudged());
            node.add(child);
            child = new DefaultMutableTreeNode("ManualReview " + problem.isManualReview());
            node.add(child);
            child = new DefaultMutableTreeNode("PrelimaryNotification " + problem.isPrelimaryNotification());
            node.add(child);
            child = new DefaultMutableTreeNode("ValidatorCommandLine " + problem.getValidatorCommandLine());
            node.add(child);
            child = new DefaultMutableTreeNode("ValidatorProgramName " + problem.getValidatorProgramName());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + problem.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof Language[]) {
            Language[] languages = (Language[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Language list: " + languages.length + " languages");
            for (Language language : languages) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", language);
                node.add(child);
            }
            return node;
        }
        if (object instanceof Run[]) {
            Run[] runs = (Run[])object;
            Arrays.sort(runs, new RunComparator());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Run list: " + runs.length + " runs");
            for (Run run : runs) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", run);
                node.add(child);
            }
            return node;
        }
        if (object instanceof Clarification[]) {
            Clarification[] clarifications = (Clarification[])object;
            Arrays.sort(clarifications, new ClarificationComparator());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Clarification list: " + clarifications.length + " runs");
            for (Clarification clarification : clarifications) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", clarification);
                node.add(child);
            }
            return node;
        }
        if (object instanceof Judgement[]) {
            Judgement[] judgements = (Judgement[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Judgement list: " + judgements.length + " judgements");
            for (Judgement judgement : judgements) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", judgement);
                node.add(child);
            }
            return node;
        }
        if (object instanceof Problem[]) {
            Problem[] problems = (Problem[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Problem list: " + problems.length + " problems");
            for (Problem problem : problems) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", problem);
                node.add(child);
            }
            return node;
        }
        if (object instanceof RunFiles[]) {
            RunFiles[] list = (RunFiles[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "RunFiles list: " + list.length + " problems");
            for (RunFiles runFiles : list) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", runFiles);
                node.add(child);
            }
            return node;
        }
        if (object instanceof RunFiles) {
            RunFiles runfiles = (RunFiles)object;
            String mainFileName = runfiles.getMainFile().getName();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "RunFiles: " + mainFileName + " for " + runfiles.getRunId());
            SerializedFile mainFile = runfiles.getMainFile();
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("mainfile file: " + mainFile.getName() + " " + mainFile.getBuffer().length + " bytes");
            node.add(child);
            if (runfiles.getOtherFiles() != null) {
                for (SerializedFile file : runfiles.getOtherFiles()) {
                    child = new DefaultMutableTreeNode("additional file: " + file.getName() + " " + file.getBuffer().length + " bytes");
                    node.add(child);
                }
            } else {
                child = new DefaultMutableTreeNode("additional file: null ");
                node.add(child);
            }
            child = new DefaultMutableTreeNode("RunID: " + runfiles.getRunId().toString());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + runfiles.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof ProfileCloneSettings) {
            ProfileCloneSettings settings = (ProfileCloneSettings)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Clone Settings: " + settings.getName());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Name: " + settings.getName());
            node.add(child);
            child = new DefaultMutableTreeNode("Title: " + settings.getContestTitle());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyRuns = =" + settings.isCopyRuns());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyClarifications = =" + settings.isCopyClarifications());
            node.add(child);
            child = new DefaultMutableTreeNode("ResetContestTimes = " + settings.isResetContestTimes());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyAccounts = " + settings.isCopyAccounts());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyContestSettings = =" + settings.isCopyContestSettings());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyGroups = =" + settings.isCopyGroups());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyJudgements = =" + settings.isCopyJudgements());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyLanguages = =" + settings.isCopyLanguages());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyNotifications = =" + settings.isCopyNotifications());
            node.add(child);
            child = new DefaultMutableTreeNode("CopyProblems = =" + settings.isCopyProblems());
            node.add(child);
            return node;
        }
        return PacketFormatter.createMoreTrees(key, object);
    }

    private static DefaultMutableTreeNode createMoreTrees(String key, Object object) {
        if (object instanceof Group) {
            Group group = (Group)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Group: " + group.getDisplayName());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("GroupId: " + group.getGroupId());
            node.add(child);
            child = new DefaultMutableTreeNode("Name: " + group.getDisplayName());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + group.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof Group[]) {
            Group[] groups = (Group[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Group list: " + groups.length + " Groups");
            for (Group group : groups) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", group);
                node.add(child);
            }
            return node;
        }
        if (object instanceof Site[]) {
            Site[] sites = (Site[])object;
            Arrays.sort(sites, new SiteComparatorBySiteNumber());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Site list: " + sites.length + " Sites");
            for (Site site : sites) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", site);
                node.add(child);
            }
            return node;
        }
        return PacketFormatter.evenMoreTrees(key, object);
    }

    private static DefaultMutableTreeNode evenMoreTrees(String key, Object object) {
        if (object instanceof ContestInformation) {
            ContestInformation contestInformation = (ContestInformation)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ContestInformation: " + contestInformation.getContestTitle());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Title: " + contestInformation.getContestTitle());
            node.add(child);
            child = new DefaultMutableTreeNode("URL: " + contestInformation.getContestURL());
            node.add(child);
            child = new DefaultMutableTreeNode("Default Clar. Answer: " + contestInformation.getJudgesDefaultAnswer());
            node.add(child);
            NotificationSetting[] notificationSettings = contestInformation.getJudgementNotificationsList().getList();
            child = PacketFormatter.createTree("", notificationSettings);
            PacketFormatter.addNonNull(node, child);
            child = new DefaultMutableTreeNode("URL: " + contestInformation.getContestURL());
            node.add(child);
            return node;
        }
        if (object instanceof FinalizeData) {
            FinalizeData finalizeData = (FinalizeData)object;
            String certified = "No";
            if (finalizeData.isCertified()) {
                certified = "Yes";
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "FinalizeData: certified " + certified);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Comment: " + finalizeData.getComment());
            node.add(child);
            child = new DefaultMutableTreeNode("Certified: " + certified);
            node.add(child);
            child = new DefaultMutableTreeNode("Gold rank: " + finalizeData.getGoldRank());
            node.add(child);
            child = new DefaultMutableTreeNode("Silver rank: " + finalizeData.getSilverRank());
            node.add(child);
            child = new DefaultMutableTreeNode("Bronze rank: " + finalizeData.getBronzeRank());
            node.add(child);
            return node;
        }
        if (object instanceof NotificationSetting[]) {
            NotificationSetting[] notificationSettings = (NotificationSetting[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Client list: " + notificationSettings.length + " NotificationSettings");
            for (NotificationSetting notificationSetting : notificationSettings) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", notificationSetting);
                PacketFormatter.addNonNull(node, child);
            }
            return node;
        }
        if (object instanceof NotificationSetting) {
            NotificationSetting notificationSetting = (NotificationSetting)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "NotificationSetting: " + notificationSetting);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("site = " + notificationSetting.getSiteNumber());
            node.add(child);
            return node;
        }
        if (object instanceof ClientSettings[]) {
            ClientSettings[] clientSettingss = (ClientSettings[])object;
            Arrays.sort(clientSettingss, new ClientSettingsComparator());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ClientSettings list: " + clientSettingss.length + " ClientSettingss");
            for (ClientSettings clientSettings : clientSettingss) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", clientSettings);
                PacketFormatter.addNonNull(node, child);
            }
            return node;
        }
        if (object instanceof ClientSettings) {
            ClientSettings setting = (ClientSettings)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ClientSettings: " + setting.getClientId());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("ClientId: " + setting.getClientId());
            node.add(child);
            child = new DefaultMutableTreeNode("Auto Judging: " + setting.isAutoJudging());
            node.add(child);
            child = new DefaultMutableTreeNode("Site: " + setting.getSiteNumber());
            node.add(child);
            child = PacketFormatter.createTree("Auto Judging Filter", setting.getAutoJudgeFilter());
            node.add(child);
            Object[] keys = setting.getKeys();
            Arrays.sort(keys);
            for (Object name : keys) {
                child = new DefaultMutableTreeNode("Property:" + (String)name + ":" + setting.getProperty((String)name));
                node.add(child);
            }
            child = new DefaultMutableTreeNode("ElementId: " + setting.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof Filter) {
            Filter filter = (Filter)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "Filter: " + filter);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Summary: " + filter);
            node.add(child);
            child = new DefaultMutableTreeNode("Filter on: " + filter.isFilterOn());
            node.add(child);
            return node;
        }
        if (object instanceof BalloonSettings[]) {
            BalloonSettings[] balloonSettings = (BalloonSettings[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "BalloonSettings list: " + balloonSettings.length + " BalloonSettings");
            for (BalloonSettings settings : balloonSettings) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", settings);
                node.add(child);
            }
            return node;
        }
        if (object instanceof BalloonSettings) {
            BalloonSettings balloonSettings = (BalloonSettings)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "BalloonSettings: " + balloonSettings);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Site Number: " + balloonSettings.getSiteNumber());
            node.add(child);
            child = new DefaultMutableTreeNode("Balloon client: " + balloonSettings.getBalloonClient());
            node.add(child);
            child = new DefaultMutableTreeNode("Enabled: " + balloonSettings.isBalloonsEnabled());
            node.add(child);
            child = new DefaultMutableTreeNode("Include Nos: " + balloonSettings.isIncludeNos());
            node.add(child);
            child = new DefaultMutableTreeNode("Use postscript: " + balloonSettings.isPostscriptCapable());
            node.add(child);
            child = new DefaultMutableTreeNode("Print balloons: " + balloonSettings.isPrintBalloons());
            node.add(child);
            child = new DefaultMutableTreeNode("Email Balloon: " + balloonSettings.isEmailBalloons());
            node.add(child);
            child = new DefaultMutableTreeNode("Balloon email: " + balloonSettings.getEmailContact());
            node.add(child);
            child = PacketFormatter.createTree("Mail Props", balloonSettings.getMailProperties());
            PacketFormatter.addNonNull(node, child);
            child = new DefaultMutableTreeNode("Print device:" + balloonSettings.getPrintDevice());
            node.add(child);
            child = new DefaultMutableTreeNode("ElementId: " + balloonSettings.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof ConnectionHandlerID) {
            ConnectionHandlerID connectionID = (ConnectionHandlerID)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ConnectionId: " + connectionID);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Ready to communicate: " + connectionID.isReadyToCommunicate());
            node.add(child);
            return node;
        }
        if (object instanceof ConnectionHandlerID[]) {
            ConnectionHandlerID[] connectionIds = (ConnectionHandlerID[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ConnHandId list: " + connectionIds.length + " ConnHandIds");
            for (ConnectionHandlerID connectionId : connectionIds) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", connectionId);
                PacketFormatter.addNonNull(node, child);
            }
            return node;
        }
        if (object instanceof ProblemDataFiles) {
            ProblemDataFiles data = (ProblemDataFiles)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ProblemDataFiles: " + data.getProblemId());
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("problem: " + data.getProblemId());
            node.add(child);
            data.getJudgesDataFile();
            child = PacketFormatter.createTree("Judge Data File", data.getJudgesDataFile());
            PacketFormatter.addNonNull(node, child);
            child = PacketFormatter.createTree("Judge Ans File", data.getJudgesAnswerFile());
            PacketFormatter.addNonNull(node, child);
            child = PacketFormatter.createTree("Validator", data.getValidatorFile());
            PacketFormatter.addNonNull(node, child);
            child = new DefaultMutableTreeNode("ElementId: " + data.getElementId().toString());
            node.add(child);
            return node;
        }
        if (object instanceof SerializedFile) {
            SerializedFile file = (SerializedFile)object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "File: " + file.getName() + " " + file.getBuffer().length + " bytes");
            return node;
        }
        if (object instanceof SerializedFile[]) {
            SerializedFile[] files = (SerializedFile[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "SerialFile list: " + files.length + " ProblemDataFiless");
            for (SerializedFile file : files) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", file);
                PacketFormatter.addNonNull(node, child);
            }
            return node;
        }
        if (object instanceof ProblemDataFiles[]) {
            ProblemDataFiles[] datas = (ProblemDataFiles[])object;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key + "ProblemDataFiles list: " + datas.length + " data files");
            for (ProblemDataFiles data : datas) {
                DefaultMutableTreeNode child = PacketFormatter.createTree("", data);
                PacketFormatter.addNonNull(node, child);
            }
            return node;
        }
        return null;
    }

    protected static class ObjectWrapper {
        private String string;
        private String key;

        protected ObjectWrapper(String key) {
            this.key = key;
        }

        public ObjectWrapper(String key, Object object) {
            this(key);
            this.string = object instanceof String ? "(String) " + (String)object : (object instanceof Integer ? "(Integer) " + (Integer)object : (object instanceof Date ? "(Date) " + (Date)object : "Object:" + object.toString()));
        }

        public String toString() {
            return this.key + "=" + this.string;
        }
    }
}

