/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class Utilities {
    private static boolean debugMode = false;
    private static final String LETTERS = " ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private Utilities() {
    }

    public static boolean insureDir(String dirName) {
        File dir = null;
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("insureDir Directory " + dir.getName() + " could not be created.");
        }
        return dir.isDirectory();
    }

    public static boolean isFileThere(String filename) {
        File file = new File(filename);
        return file.isFile();
    }

    public static boolean isEquals(char[] oldBuffer, char[] newBuffer) {
        if (oldBuffer == null) {
            return newBuffer == null;
        }
        if (newBuffer == null) {
            return false;
        }
        if (oldBuffer.length != newBuffer.length) {
            return false;
        }
        for (int i = 0; i < newBuffer.length; ++i) {
            if (newBuffer[i] == oldBuffer[i]) continue;
            return false;
        }
        return true;
    }

    public static String[] loadFile(String filename) throws IOException {
        Vector<String> lines = new Vector<String>();
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        if (!new File(filename).exists()) {
            return new String[0];
        }
        FileReader fileReader = new FileReader(filename);
        BufferedReader in = new BufferedReader(fileReader);
        String line = in.readLine();
        while (line != null) {
            lines.addElement(line);
            line = in.readLine();
        }
        in.close();
        fileReader.close();
        in = null;
        fileReader = null;
        if (lines.size() == 0) {
            return new String[0];
        }
        String[] out = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            out[i] = (String)lines.elementAt(i);
        }
        return out;
    }

    public static String getCurrentDirectory() {
        File curdir = new File(".");
        try {
            return curdir.getCanonicalPath();
        }
        catch (Exception e) {
            return ".";
        }
    }

    public static String getL10nDateTime() {
        Locale currentLocale = Locale.getDefault();
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(0, 1, currentLocale);
        return dateFormatter.format(today);
    }

    public static String getL10nDateTime(int dateStyle, int timeStyle, Locale currentLocale) {
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(dateStyle, timeStyle, currentLocale);
        return dateFormatter.format(today);
    }

    public static String getRFC2822DateTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        return String.format("%1$ta, %1$te %1$tb %1$tY %1$tT %1$tz", calendar);
    }

    public static String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    public static String[] loadINIFile(String filename) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            while ((line = file.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                v.addElement(line);
            }
            file.close();
            file = null;
        }
        catch (Exception e) {
            return null;
        }
        return v.toArray(new String[v.size()]);
    }

    public static String forHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '(') {
                result.append("&#040;");
            } else if (character == ')') {
                result.append("&#041;");
            } else if (character == '#') {
                result.append("&#035;");
            } else if (character == '%') {
                result.append("&#037;");
            } else if (character == ';') {
                result.append("&#059;");
            } else if (character == '+') {
                result.append("&#043;");
            } else if (character == '-') {
                result.append("&#045;");
            } else if (character == '\n') {
                result.append("<br>");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean debugMode) {
        Utilities.debugMode = debugMode;
    }

    public static String basename(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex == -1) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }

    public static String convertNumber(int index) {
        String letter = String.valueOf(index);
        if (index > 26) {
            int i2 = index;
            int count = 0;
            while (index > 26) {
                index -= 26;
                ++count;
            }
            int mod = i2 - count * 26;
            letter = Utilities.convertBase26Number(count) + Utilities.convertBase26Number(mod);
        } else {
            letter = Utilities.convertBase26Number(index);
        }
        return letter;
    }

    private static String convertBase26Number(int index) {
        return LETTERS.substring(index, index + 1);
    }

    public static String dirname(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex == -1) {
            return path;
        }
        if (lastIndex == 0) {
            return path;
        }
        return path.substring(0, lastIndex);
    }

    public static String getReportFilename(IReport selectedReport) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + ".txt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewReport(IReport report, String title, IInternalContest contest, IInternalController controller) {
        String filename = Utilities.getReportFilename(report);
        report.setContestAndController(contest, controller);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, "Unable to open file " + filename);
        }
        try {
            printWriter.println(new VersionInfo().getSystemName());
            printWriter.println(new VersionInfo().getSystemVersionInfo());
            ContestInformation contestInformation = contest.getContestInformation();
            String contestTitle = "(Contest title not defined)";
            if (contestInformation != null) {
                contestTitle = contestInformation.getContestTitle();
            }
            printWriter.println("Contest Title: " + contestTitle);
            printWriter.println("On: " + Utilities.getL10nDateTime());
            GregorianCalendar resumeTime = null;
            if (contest.getContestTime() != null) {
                resumeTime = contest.getContestTime().getResumeTime();
            }
            if (resumeTime == null) {
                printWriter.print("  Contest date/time: never started");
            } else {
                printWriter.print("  Contest date/time: " + resumeTime.getTime());
            }
            printWriter.println();
            printWriter.println();
            printWriter.println("** " + report.getReportTitle() + " Report");
            printWriter.println("Site " + contest.getSiteNumber());
            printWriter.println();
            try {
                report.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println();
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            report.printFooter(printWriter);
        }
        catch (Exception e) {
            controller.getLog().log(Log.INFO, "Exception creating report", e);
            printWriter.println("Exception creating report " + e.getMessage());
            e.printStackTrace(printWriter);
        }
        finally {
            printWriter.close();
            printWriter = null;
        }
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(controller.getLog());
        multipleFileViewer.addFilePane(title, filename);
        multipleFileViewer.setTitle("PC^2 Report (Build " + new VersionInfo().getBuildNumber() + ")");
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }
}

