/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Properties;

public class LoadContest {
    private String sumitFilename = "Sumit.java";
    private PermissionGroup permissionGroup = new PermissionGroup();

    public LoadContest() {
        this.locateSumitFile();
    }

    private void locateSumitFile() {
        String[] dirnames;
        if (new File(this.sumitFilename).isFile()) {
            return;
        }
        for (String dirname : dirnames = new String[]{"samps", "testdata" + File.separator + "src", File.separator + "pc2" + File.separator + "samps", File.separator + "pc2" + File.separator + "testdata" + File.separator + "src", File.separator + "usr" + File.separator + "pc2" + File.separator + "testdata" + File.separator + "src"}) {
            String fullname = dirname + File.separator + this.sumitFilename;
            if (!new File(fullname).isFile()) continue;
            this.sumitFilename = fullname;
            return;
        }
    }

    public IInternalContest loadContest(String filename) throws IOException {
        return this.loadContest(filename, null);
    }

    public IInternalContest loadContest(String filename, IInternalContest contest) throws IOException {
        String line;
        if (contest == null) {
            contest = new InternalContest();
        }
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        int runCount = 0;
        while ((line = file.readLine()) != null) {
            String[] fields;
            if (line.trim().startsWith("#") || line.trim().length() == 0 || (fields = line.trim().split("[|]")).length != 19) continue;
            try {
                Date startTime = new Date();
                Run run = this.addRunToContest(contest, fields);
                long seconds = new Date().getTime() - startTime.getTime();
                System.out.println(seconds + " ms, count=" + ++runCount + " for " + run + " elap=" + run.getElapsedMins());
            }
            catch (ClassNotFoundException e) {
                System.out.println("Exception for line: " + line);
                e.printStackTrace();
            }
            catch (FileSecurityException e) {
                System.out.println("Exception for line: " + line);
                e.printStackTrace();
            }
        }
        file.close();
        return contest;
    }

    public Run addRunToContest(IInternalContest contest, String[] fields) throws IOException, ClassNotFoundException, FileSecurityException {
        int siteNumber = this.getNumber(this.stripString(fields[1], "site "));
        int teamNumber = this.getNumber(this.stripString(fields[3], "team "));
        long elapsedMinutes = this.getNumber(this.stripString(fields[12], ""));
        String teamName = this.getField(fields[4], ":", 1).trim();
        if (teamName.length() == 0) {
            teamName = "team" + teamNumber;
        }
        String languageName = this.getField(fields[6], ":", 1);
        String problemName = this.getField(fields[5], ":", 1);
        Language language = this.createLanguage(contest, languageName);
        Problem problem = this.createProblem(contest, problemName);
        Account account = this.createAccount(contest, siteNumber, teamNumber, teamName);
        Run run = new Run(account.getClientId(), language, problem);
        boolean solved = false;
        RunResultFiles[] runResultFiles = null;
        String judgingComplete = this.stripString(fields[11], "jc ");
        if (judgingComplete.trim().equals("true")) {
            solved = this.stripString(fields[14], "mmfr").trim().equals("true");
            String judgementName = this.stripString(fields[18], "jci").trim();
            if (!solved && !judgementName.startsWith("No - ")) {
                judgementName = "No - " + judgementName;
            }
            Judgement judgement = this.createJudgement(contest, judgementName.trim());
            String judgedBy = this.stripString(fields[17], "jby judge");
            Account judgeAccount = null;
            String judgeAccountName = "judge";
            boolean isAdminAccount = judgedBy.startsWith("jby adm");
            if (isAdminAccount) {
                judgedBy = this.stripString(judgedBy, "jby administrator");
                judgeAccountName = "administrator";
            }
            int judgeNumber = this.getNumber(judgedBy);
            judgeAccountName = judgeAccountName + judgeNumber;
            judgeAccount = isAdminAccount ? this.createAccount(contest, siteNumber, judgeNumber, judgeAccountName, ClientType.Type.ADMINISTRATOR) : this.createAccount(contest, siteNumber, judgeNumber, judgeAccountName, ClientType.Type.JUDGE);
            JudgementRecord judgementRecord = new JudgementRecord(judgement.getElementId(), judgeAccount.getClientId(), solved, false, false);
            run.setStatus(Run.RunStates.JUDGED);
            run.addJudgement(judgementRecord);
            runResultFiles = new RunResultFiles[]{new RunResultFiles(run, run.getProblemId(), judgementRecord, new ExecutionData())};
        }
        int maxRunNumber = this.getMaxRun(contest, siteNumber);
        this.createSite(contest, siteNumber, "Site " + siteNumber);
        run.setNumber(maxRunNumber + 1);
        run.setSiteNumber(siteNumber);
        run.setElapsedMins(elapsedMinutes);
        contest.addRun(run);
        RunFiles runFiles = new RunFiles(run, this.getFileNameForRun(run));
        contest.updateRun(run, runFiles, null, runResultFiles);
        return run;
    }

    private String getFileNameForRun(Run run) {
        return this.sumitFilename;
    }

    private Site createNewSite(int siteNumber, String siteName, String hostName, int portNumber) {
        Site site = new Site(siteName, siteNumber);
        Properties props = new Properties();
        if (hostName == null) {
            props.put("IP_KEY", "localhost");
        }
        if (portNumber == 0) {
            portNumber = 50002 + (siteNumber - 1) * 1000;
        }
        props.put("PORT_KEY", "" + portNumber);
        site.setConnectionInfo(props);
        site.setPassword("site" + siteNumber);
        return site;
    }

    private Site createSite(IInternalContest contest, int siteNumber, String siteName) {
        Site site = contest.getSite(siteNumber);
        if (site == null) {
            site = this.createNewSite(siteNumber, siteName, null, 0);
            contest.addSite(site);
        }
        return site;
    }

    private int getMaxRun(IInternalContest contest, int siteNumber) {
        int count = 0;
        for (Run run : contest.getRuns()) {
            if (run.getSiteNumber() != siteNumber) continue;
            ++count;
        }
        return count;
    }

    public Judgement createJudgement(IInternalContest contest, String judgementName) {
        if (contest.getJudgements().length == 0) {
            contest.addJudgement(new Judgement("Yes"));
        }
        for (Judgement judgement : contest.getJudgements()) {
            if (!judgement.getDisplayName().equals(judgementName)) continue;
            return judgement;
        }
        Judgement newJudgement = new Judgement(judgementName);
        contest.addJudgement(newJudgement);
        return newJudgement;
    }

    public Account createAccount(IInternalContest contest, int siteNumber, int accountNumber, String displayName) {
        return this.createAccount(contest, siteNumber, accountNumber, displayName, ClientType.Type.TEAM);
    }

    public Account createAccount(IInternalContest contest, int siteNumber, int accountNumber, String displayName, ClientType.Type clientType) {
        ClientId clientId = new ClientId(siteNumber, clientType, accountNumber);
        Account account = contest.getAccount(clientId);
        if (account == null) {
            String password = clientType.toString().toLowerCase() + accountNumber;
            account = new Account(clientId, password, clientId.getSiteNumber());
            account.setDisplayName(displayName);
            PermissionList permissionList = this.permissionGroup.getPermissionList(account.getClientId().getClientType());
            if (permissionList != null) {
                account.clearListAndLoadPermissions(permissionList);
            } else {
                account.addPermission(Permission.Type.LOGIN);
                account.addPermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
            }
            contest.addAccount(account);
        }
        return account;
    }

    public Problem createProblem(IInternalContest contest, String problemName) {
        Problem[] problems;
        for (Problem problem : problems = contest.getProblems()) {
            if (!problem.getDisplayName().equals(problemName)) continue;
            return problem;
        }
        Problem newProblem = new Problem(problemName);
        contest.addProblem(newProblem);
        return newProblem;
    }

    public Language createLanguage(IInternalContest contest, String languageName) {
        Language[] languages = contest.getLanguages();
        for (Language language : languages) {
            if (!language.getDisplayName().equals(languageName)) continue;
            return language;
        }
        for (String langName : LanguageAutoFill.getLanguageList()) {
            if (!langName.equals(languageName)) continue;
            String[] values = LanguageAutoFill.getAutoFillValues(langName);
            Language language = new Language(langName);
            language.setCompileCommandLine(values[1]);
            language.setExecutableIdentifierMask(values[2]);
            language.setProgramExecuteCommandLine(values[3]);
            contest.addLanguage(language);
            return language;
        }
        Language newLanguage = new Language(languageName);
        contest.addLanguage(newLanguage);
        return newLanguage;
    }

    public String stripString(String string, String stringToStrip) {
        int idx = string.indexOf(stringToStrip);
        if (idx > -1) {
            string = string.replaceAll(stringToStrip, "");
        }
        return string;
    }

    public String getField(String string, String delimit, int fieldNumber) {
        String[] fields = string.split(delimit);
        if (fieldNumber < fields.length) {
            return fields[fieldNumber];
        }
        return string;
    }

    public int getNumber(String source) {
        source = source.trim();
        return Integer.parseInt(source);
    }

    public static void main(String[] args) {
        LoadContest load = new LoadContest();
        String filename = args[0];
        try {
            String line;
            IInternalContest contest = load.loadContest(filename);
            System.out.println("runs " + contest.getRuns().length);
            System.out.println("teams " + contest.getAccounts(ClientType.Type.TEAM).size());
            System.out.println("probs " + contest.getProblems().length);
            System.out.println("langs " + contest.getLanguages().length);
            System.out.println("judgements " + contest.getJudgements().length);
            System.out.println();
            LanguagesReport report = new LanguagesReport();
            Filter filter = new Filter();
            InternalController controller = new InternalController(contest);
            report.setContestAndController(contest, controller);
            report.setFilter(filter);
            String outfilename = "stuf2.rpt.txt";
            report.createReportFile(outfilename, filter);
            RandomAccessFile file = new RandomAccessFile(outfilename, "r");
            while ((line = file.readLine()) != null) {
                System.out.println(line);
            }
            new File(outfilename).deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

