/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class IniFile {
    public static final String SVN_ID = "$Id: IniFile.java 2245 2010-10-28 16:30:11Z ashoos $";
    private static Hashtable<String, String> nameValueHash = new Hashtable();
    private static String currentSectionName = "";
    private static final String INI_FILENAME = "pc2v9.ini";
    private static URL iniFileURL = null;

    public IniFile() {
        this.load();
    }

    public void loadFile() {
        this.load();
    }

    public static boolean containsKey(String key) {
        String k = key.trim().toLowerCase();
        return nameValueHash.containsKey(k);
    }

    public static boolean containsKey(String sectionName, String keyName) {
        String key = sectionName + ":" + keyName;
        String k = key.trim().toLowerCase();
        return nameValueHash.containsKey(k);
    }

    public static void dump() {
        IniFile.dump(System.out);
    }

    public static void dump(PrintStream ps) {
        ps.println("Dumping: " + IniFile.getIniFileURL());
        Enumeration<String> enumeration = nameValueHash.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            ps.println("key=" + key + ";value=" + nameValueHash.get(key));
        }
    }

    public static String getINIFilename() {
        return new String(INI_FILENAME);
    }

    public static URL getIniFileURL() {
        return iniFileURL;
    }

    public static String getValue(String key) {
        String ret = null;
        String k = key.trim().toLowerCase();
        String value = nameValueHash.get(k);
        ret = value == null ? null : new String(value);
        return ret;
    }

    public static String getValue(String sectionName, String keyName) {
        String key = sectionName + ":" + keyName;
        return IniFile.getValue(key);
    }

    public static boolean isFilePresent() {
        File iniFilefile = new File(IniFile.getINIFilename());
        return iniFilefile.exists();
    }

    private void load() {
        try {
            if (iniFileURL == null) {
                File iniFilefile = new File(IniFile.getINIFilename());
                if (!iniFilefile.exists()) {
                    File curdir = new File(".");
                    System.out.println("Unable to read " + IniFile.getINIFilename() + " file not found in " + curdir.getCanonicalPath());
                    new Exception("Unable to read .ini file ").printStackTrace();
                    return;
                }
                IniFile.setIniFileURL(iniFilefile.toURI().toURL());
            }
            iniFileURL.openStream();
            nameValueHash.clear();
            nameValueHash.put("_source", iniFileURL.toString());
            currentSectionName = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(iniFileURL.openStream()));
            String line = in.readLine();
            while (line != null) {
                IniFile.parseLine(line);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading ini " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    private static void parseLine(String line) {
        try {
            if (line.trim().equals("")) {
                return;
            }
            if (line.charAt(0) == ';' || line.charAt(0) == '#') {
                return;
            }
            if (line.charAt(0) == '[') {
                int index = line.indexOf("]");
                currentSectionName = line.substring(1, index).trim().toLowerCase();
            } else {
                int index = line.indexOf("=");
                if (index == -1) {
                    if (line.charAt(0) != ';' && line.charAt(0) != '#') {
                        System.out.println("Invalid line format (missing =)" + line);
                    }
                } else {
                    String key = line.substring(0, index).trim().toLowerCase();
                    String value = line.substring(index + 1);
                    if (currentSectionName.equals("")) {
                        nameValueHash.put(key, value);
                    } else {
                        nameValueHash.put(currentSectionName + "." + key, value);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error processing line: '" + line + "'" + e.getMessage());
        }
    }

    public static void setIniURLorFile(String newIni) throws MalformedURLException {
        try {
            URL url = new URL(newIni);
            IniFile.setIniFileURL(url);
        }
        catch (MalformedURLException e) {
            IniFile.setIniFile(newIni);
        }
    }

    public static void setIniFile(String newIniFile) throws MalformedURLException {
        File inFilefile = new File(newIniFile);
        if (!inFilefile.exists()) {
            throw new SecurityException(newIniFile + " file not found");
        }
        IniFile.setIniFileURL(inFilefile.toURI().toURL());
    }

    public static void setIniFileURL(URL newIniFileURL) {
        iniFileURL = newIniFileURL;
    }
}

