/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Ini {
    private Hashtable<String, String> nameValueHash = new Hashtable();
    private String currentSectionName = "";
    private static final String INI_FILENAME = "pc2v9.ini";
    private URL iniFileURL = null;

    public boolean containsKey(String key) {
        String k = key.trim().toLowerCase();
        return this.nameValueHash.containsKey(k);
    }

    public boolean containsKey(String sectionName, String keyName) {
        String key = sectionName + ":" + keyName;
        String k = key.trim().toLowerCase();
        return this.nameValueHash.containsKey(k);
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream ps) {
        ps.println("Dumping: " + this.getIniFileURL());
        Enumeration<String> enumeration = this.nameValueHash.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            ps.println("key=" + key + ";value=" + this.nameValueHash.get(key));
        }
    }

    public URL getIniFileURL() {
        return this.iniFileURL;
    }

    public String getValue(String key) {
        String ret = null;
        String k = key.trim().toLowerCase();
        String value = this.nameValueHash.get(k);
        ret = value == null ? null : new String(value);
        return ret;
    }

    public String getValue(String sectionName, String keyName) {
        String key = sectionName + ":" + keyName;
        return this.getValue(key);
    }

    private void load() {
        try {
            if (this.iniFileURL == null) {
                File iniFilefile = new File(INI_FILENAME);
                if (!iniFilefile.exists()) {
                    File curdir = new File(".");
                    System.out.println("Unable to read pc2v9.ini file not found in " + curdir.getCanonicalPath());
                    new Exception("Unable to read .ini file ").printStackTrace();
                    return;
                }
                this.setIniFileURL(iniFilefile.toURI().toURL());
            }
            this.iniFileURL.openStream();
            this.nameValueHash.clear();
            this.nameValueHash.put("_source", this.iniFileURL.toString());
            this.currentSectionName = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(this.iniFileURL.openStream()));
            String line = in.readLine();
            while (line != null) {
                this.parseLine(line);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading ini " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    private void parseLine(String line) {
        try {
            if (line.trim().equals("")) {
                return;
            }
            if (line.charAt(0) == ';' || line.charAt(0) == '#') {
                return;
            }
            if (line.charAt(0) == '[') {
                int index = line.indexOf("]");
                this.currentSectionName = line.substring(1, index).trim().toLowerCase();
            } else {
                int index = line.indexOf("=");
                if (index == -1) {
                    if (line.charAt(0) != ';' && line.charAt(0) != '#') {
                        System.out.println("Invalid line format (missing =)" + line);
                    }
                } else {
                    String key = line.substring(0, index).trim().toLowerCase();
                    String value = line.substring(index + 1);
                    if (this.currentSectionName.equals("")) {
                        this.nameValueHash.put(key, value);
                    } else {
                        this.nameValueHash.put(this.currentSectionName + "." + key, value);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error processing line: '" + line + "'" + e.getMessage());
        }
    }

    public void setIniURLorFile(String newIni) throws MalformedURLException {
        try {
            URL url = new URL(newIni);
            this.setIniFileURL(url);
            this.load();
        }
        catch (MalformedURLException e) {
            this.setIniFile(newIni);
        }
    }

    public void setIniFile(String newIniFile) throws MalformedURLException {
        File inFilefile = new File(newIniFile);
        if (!inFilefile.exists()) {
            throw new SecurityException(newIniFile + " file not found");
        }
        this.setIniFileURL(inFilefile.toURI().toURL());
        this.load();
    }

    public void setIniFileURL(URL newIniFileURL) {
        this.iniFileURL = newIniFileURL;
    }
}

